struct fractal_info			/*  for saving data in GIF file     */
{
	char info_id[8];		/* Unique identifier for info block */
	int iterations;
	int fractal_type;	    /* 0=Mandelbrot 1=Julia 2= ... */
	double	xmin;
	double	xmax;
	double	ymin;
	double	ymax;
	double	creal;
	double	cimag;
	int	videomodeax;
	int	videomodebx;
	int	videomodecx;
	int	videomodedx;
	int	dotmode;
	int	xdots;
	int	ydots;
	int colors;
	int version;	    /* used to be 'future[0]' */
    float parm3;
    float parm4;
    float potential[3];
    int rseed;
    int rflag;
    int biomorph;
    int inside;
    int logmap;
    float invert[3];
    int decomp[2];
    int symmetry;
    /* version 2 stuff */
    int init3d[16];
    int previewfactor;
    int xtrans;
    int ytrans;
    int red_crop_left;
    int red_crop_right;
    int blue_crop_left;
    int blue_crop_right;
    int red_bright;
    int blue_bright;
    int xadjust;
    int eyeseparation;
    int glassestype;
    /* version 3 stuff, release 13 */
    int outside;
    /* version 4 stuff, release 14 */
    double x3rd;	  /* 3rd corner */
    double y3rd;
    char stdcalcmode;	  /* 1/2/g/b */
    char useinitorbit;	  /* init Mandelbrot orbit flag */
    int calc_status;	  /* resumable, finished, etc */
    long tot_extend_len;  /* total length of extension blocks in .gif file */
    int distest;
    int floatflag;
    int bailout;
    long calctime;
    unsigned char trigndx[4]; /* which trig functions selected */
    int finattract;
    double initorbit[2];  /* init Mandelbrot orbit values */
    int periodicity;	  /* periodicity checking */
    /* version 5 stuff, release 15 */
    int pot16bit;	  /* save 16 bit continuous potential info */
    float faspectratio;   /* finalaspectratio, y/x */
    int system; 	  /* 0 for dos, 1 for windows */
    int release;	  /* release number, with 2 decimals implied */
    int flag3d; 	  /* stored only for now, for future use */
    int transparent[2];
    int ambient;
    int haze;
    int randomize;
    /* version 6 stuff, release 15.x */
    int rotate_lo;
    int rotate_hi;
    int distestwidth;
    /* version 7 stuff, release 16 */
    double dparm3;
    double dparm4;
    /* version 8 stuff, release 17 */
    int fillcolor;
    int future[31];	  /* for stuff we haven't thought of yet */
};

extern char* name_of[];
