//+------------------------------------------------------------------------+
//+ PROGRAM GHOSTS.CPP                                                     +
//+                                                                        +
//+ By Ramiro Perez (rperez%ns.pa@uga.cc.uga.edu) and Fausto A. A. Barbuto +
//+ (BJ06@C53000.PETROBRAS.ANRJ.BR), August 17, 1994.                      +
//+                                                                        +
//+ Plots phantom-like Julia sets; very fast.  Initial parameters cx & cy  +
//+ are randomically generated. Press any key to jump to another plot and  +
//+ ESC to quit.                                                           +
//+                                                                        +
//+ Uses SVGA256 Package by Jordan Powell Hargrave  (hargrave@dellgate.us. +
//+ dell.com) and  Random Number Generator plus Screen Fading routines by  +
//+ Michael Sargent (msargent@moose.uvm.edu) and Quintessential Sophistry. +
//+------------------------------------------------------------------------+
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <graphics.h>
#include <dos.h>
#include "svga256.h"

double qsrandom(void);
void fade(void);

int Video;

int huge DetectSVGA256()
{
  clrscr();
  printf("\n Program GHOSTS.CPP ");
  printf("\n\n\n Which video mode would you like to use? \n\n");
  printf(" 0 - 320x200x256\n");
  printf(" 1 - 640x400x256\n");
  printf(" 2 - 640x480x256\n");
  printf(" 3 - 800x600x256\n");
  printf(" 4 - 1024x768x256\n\n> ");
  scanf("%d",&Video);
  if ((Video>4) || (Video<0)) Video = 2;
  return Video;
}

void main(void)
{
   int i, npix, npiy, graphdriver=DETECT, graphmode, k, size, dist;
   double a[3] = {0.5, 0.95, 0.05};
   double x[3], y[3], PI, rand1, rand2, cx, cy, wx, wy, theta, r, xt, yt;
   char choicekey, buffer[15];

   installuserdriver("Svga256",DetectSVGA256);
   initgraph(&graphdriver,&graphmode,"C:\\BORLANDC\\BGI");

   if (Video == 0) { npix =  80; npiy =  50; size = 4; dist = 10;}
   if (Video == 1) { npix = 160; npiy = 100; size = 5; dist = 13;}
   if (Video == 2) { npix = 160; npiy = 120; size = 6; dist = 16;}
   if (Video == 3) { npix = 200; npiy = 150; size = 7; dist = 21;}
   if (Video == 4) { npix = 256; npiy = 192; size = 8; dist = 26;}

   PI = 3.1415926535897932;

   do {
      for (i=0;i<=2;i++) {
	 x[i] = 0.0;
	 y[i] = 0.0;
      }
      rand1 = 0.5*(qsrandom() + qsrandom());
      if (rand1 > 0.5) cx = -2.25*qsrandom();
      else cx = 0.75*qsrandom();

      if (cx < 0) cy = 0.65*cx + 1.5;
      else cy = -1.8*cx + 1.5;

      rand1 = qsrandom();
      rand2 = qsrandom();
      cy = cy*(rand1 - rand2);
      cleardevice();
      setcolor(39);
      settextstyle(SMALL_FONT,HORIZ_DIR,size);
      sprintf(buffer," cx = %+e  ",cx);
      outtextxy(0,0,buffer);
      sprintf(buffer," cy = %+e  ",cy);
      outtextxy(0,dist,buffer);

      do {
	 for (i=0;i<=2;i++) {
	    wx = x[i] - cx;
	    wy = y[i] - cy;
	    if (wx > 0) theta = atan(wy/wx);
	    if (wx < 0) theta = PI + atan(wy/wx);
	    if (wx == 0) theta = 0.5*PI;
	    theta = 0.5*theta;
	    r = wx*wx + wy*wy;
	    r = sqrt(sqrt(sqrt(r*r*r)));
	    rand1 = qsrandom();
	    if (rand1 > a[i]) r = -r;
	    x[i] = r*cos(theta);
	    y[i] = r*sin(theta);
	    putpixel((int)npix*(x[i]+2.0),(int)npiy*(y[i]+2.0),34);
	    putpixel((int)npix*(2.0-x[i]),(int)npiy*(2.0-y[i]),33);
	 }
	 rand1 = qsrandom();
	 if (rand1 < 0.1) {
	    xt = x[1];
	    yt = y[1];
	    x[1] = x[2];
	    y[1] = y[2];
	    x[2] = xt;
	    y[2] = yt;
	 }
      } while (!kbhit());
      choicekey = getch();
   } while (choicekey != 0x1B);
   fade();
   closegraph();
}

double qsrandom(void)
{
   int random_integer, temp_integer;
   double random_double, temp_double;
    
   random_integer = random(RAND_MAX);
   random_double = (double)random_integer / RAND_MAX;
    
   temp_integer = random(30519);
   temp_double = (double)temp_integer / 1000000000L;
   random_double += temp_double;

   return(random_double);
}

#pragma warn -eff
void fade(void)
{
   int a, b, p1, p2, p3;

   for (a=0; a<64; a++)
   {
      for (b=0; b<256; b++)
      {
	 outp(0x3C7, b);
	 p1 = inp(0x3C9);
	 p2 = inp(0x3C9);
	 p3 = inp(0x3C9);
	 outp (0x3C8, b);
	 if (p1 > 0) outp(0x3C9, p1 - 1);
	    else outp(0x3C9, 0);
	 if (p2 > 0) outp(0x3C9, p2 - 1);
	    else outp(0x3C9, 0);
	 if (p3 > 0) outp(0x3C9, p3 - 1);
	    else outp(0x3C9, 0);
      }
   delay(50);
   }
}
#pragma warn +eff
