//+-------------------------------------------------------------------+
//+ Program KAMTORUS.CPP, version 0.3                                 +
//+ Plots *hundreds* of Kamtorus fractals.                            +
//+ (when you think it's all over... a new one is produced!)          +
//+                                                                   +
//+ By Ramiro Perez (Panama), RPEREZ@UTPVM1.BITNET                    +
//+ and Fausto A. A. Barbuto (Brazil), BJ06@C53000.PETROBRAS.ANRJ.BR  +
//+ April 9, 1994.                                                    +
//+                                                                   +
//+ New formulation, colour palette and random number generator added +
//+ by Michael Sargent (USA), msargent@moose.uvm.edu, on April 28,    +
//+ 1994.                                                             +
//+                                                                   +
//+ Press any key to stop execution or PAUSE to freeze.               +
//+ SVGA256 version; supports up to five video screens.               +
//+ Authorized version for spanky.triumf.ca site.                     +
//+                                                                   +
//+-------------------------------------------------------------------+
#include <time.h>
#include <graphics.h>
#include <math.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include "Svga256.h"
    
void setVGApalette(char *buffer);
double qsrandom(void);
    
char palette[2][256][3]={{
{ 0, 0, 0},{ 63, 0, 32},{ 63, 0, 32},{ 63, 0, 33},
{ 63, 0, 33},{ 63, 0, 34},{ 63, 0, 34},{ 63, 0, 35},
{ 63, 0, 35},{ 63, 0, 36},{ 63, 0, 36},{ 63, 0, 37},
{ 63, 0, 37},{ 63, 0, 38},{ 63, 0, 38},{ 63, 0, 39},
{ 63, 0, 39},{ 63, 0, 40},{ 63, 0, 40},{ 63, 0, 41},
{ 63, 0, 41},{ 63, 0, 42},{ 63, 0, 42},{ 63, 0, 43},
{ 63, 0, 43},{ 63, 0, 44},{ 63, 0, 44},{ 63, 0, 45},
{ 63, 0, 45},{ 63, 0, 46},{ 63, 0, 46},{ 63, 0, 47},
{ 63, 0, 47},{ 63, 0, 48},{ 63, 0, 48},{ 63, 0, 49},
{ 63, 0, 49},{ 63, 0, 50},{ 63, 0, 50},{ 63, 0, 51},
{ 63, 0, 51},{ 63, 0, 52},{ 63, 0, 52},{ 63, 0, 53},
{ 63, 0, 53},{ 63, 0, 54},{ 63, 0, 54},{ 63, 0, 55},
{ 63, 0, 55},{ 63, 0, 56},{ 63, 0, 56},{ 63, 0, 57},
{ 63, 0, 57},{ 63, 0, 58},{ 63, 0, 58},{ 63, 0, 59},
{ 63, 0, 59},{ 63, 0, 60},{ 63, 0, 60},{ 63, 0, 61},
{ 63, 0, 61},{ 63, 0, 62},{ 63, 0, 62},{ 63, 0, 63},
{ 63, 0, 63},{ 62, 0, 63},{ 61, 0, 63},{ 60, 0, 63},
{ 59, 0, 63},{ 58, 0, 63},{ 57, 0, 63},{ 56, 0, 63},
{ 55, 0, 63},{ 54, 0, 63},{ 53, 0, 63},{ 52, 0, 63},
{ 51, 0, 63},{ 50, 0, 63},{ 49, 0, 63},{ 48, 0, 63},
{ 47, 0, 63},{ 46, 0, 63},{ 45, 0, 63},{ 44, 0, 63},
{ 43, 0, 63},{ 42, 0, 63},{ 41, 0, 63},{ 40, 0, 63},
{ 39, 0, 63},{ 38, 0, 63},{ 37, 0, 63},{ 36, 0, 63},
{ 35, 0, 63},{ 34, 0, 63},{ 33, 0, 63},{ 32, 0, 63},
{ 31, 0, 63},{ 30, 0, 63},{ 29, 0, 63},{ 28, 0, 63},
{ 27, 0, 63},{ 26, 0, 63},{ 25, 0, 63},{ 24, 0, 63},
{ 23, 0, 63},{ 22, 0, 63},{ 21, 0, 63},{ 20, 0, 63},
{ 19, 0, 63},{ 18, 0, 63},{ 17, 0, 63},{ 16, 0, 63},
{ 15, 0, 63},{ 14, 0, 63},{ 13, 0, 63},{ 12, 0, 63},
{ 11, 0, 63},{ 10, 0, 63},{ 9, 0, 63},{ 8, 0, 63},
{ 7, 0, 63},{ 6, 0, 63},{ 5, 0, 63},{ 4, 0, 63},
{ 3, 0, 63},{ 2, 0, 63},{ 1, 0, 63},{ 0, 0, 63},
{ 0, 0, 63},{ 1, 0, 63},{ 2, 0, 63},{ 3, 0, 63},
{ 4, 0, 63},{ 5, 0, 63},{ 6, 0, 63},{ 7, 0, 63},
{ 8, 0, 63},{ 9, 0, 63},{ 10, 0, 63},{ 11, 0, 63},
{ 12, 0, 63},{ 13, 0, 63},{ 14, 0, 63},{ 15, 0, 63},
{ 16, 0, 63},{ 17, 0, 63},{ 18, 0, 63},{ 19, 0, 63},
{ 20, 0, 63},{ 21, 0, 63},{ 22, 0, 63},{ 23, 0, 63},
{ 24, 0, 63},{ 25, 0, 63},{ 26, 0, 63},{ 27, 0, 63},
{ 28, 0, 63},{ 29, 0, 63},{ 30, 0, 63},{ 31, 0, 63},
{ 32, 0, 63},{ 33, 0, 63},{ 34, 0, 63},{ 35, 0, 63},
{ 36, 0, 63},{ 37, 0, 63},{ 38, 0, 63},{ 39, 0, 63},
{ 40, 0, 63},{ 41, 0, 63},{ 42, 0, 63},{ 43, 0, 63},
{ 44, 0, 63},{ 45, 0, 63},{ 46, 0, 63},{ 47, 0, 63},
{ 48, 0, 63},{ 49, 0, 63},{ 50, 0, 63},{ 51, 0, 63},
{ 52, 0, 63},{ 53, 0, 63},{ 54, 0, 63},{ 55, 0, 63},
{ 56, 0, 63},{ 57, 0, 63},{ 58, 0, 63},{ 59, 0, 63},
{ 60, 0, 63},{ 61, 0, 63},{ 62, 0, 63},{ 63, 0, 63},
{ 63, 0, 63},{ 63, 0, 63},{ 63, 0, 62},{ 63, 0, 62},
{ 63, 0, 61},{ 63, 0, 61},{ 63, 0, 60},{ 63, 0, 60},
{ 63, 0, 59},{ 63, 0, 59},{ 63, 0, 58},{ 63, 0, 58},
{ 63, 0, 57},{ 63, 0, 57},{ 63, 0, 56},{ 63, 0, 56},
{ 63, 0, 55},{ 63, 0, 55},{ 63, 0, 54},{ 63, 0, 54},
{ 63, 0, 53},{ 63, 0, 53},{ 63, 0, 52},{ 63, 0, 52},
{ 63, 0, 51},{ 63, 0, 51},{ 63, 0, 50},{ 63, 0, 50},
{ 63, 0, 49},{ 63, 0, 49},{ 63, 0, 48},{ 63, 0, 48},
{ 63, 0, 47},{ 63, 0, 47},{ 63, 0, 46},{ 63, 0, 46},
{ 63, 0, 45},{ 63, 0, 45},{ 63, 0, 44},{ 63, 0, 44},
{ 63, 0, 43},{ 63, 0, 43},{ 63, 0, 42},{ 63, 0, 42},
{ 63, 0, 41},{ 63, 0, 41},{ 63, 0, 40},{ 63, 0, 40},
{ 63, 0, 39},{ 63, 0, 39},{ 63, 0, 38},{ 63, 0, 38},
{ 63, 0, 37},{ 63, 0, 37},{ 63, 0, 36},{ 63, 0, 36},
{ 63, 0, 35},{ 63, 0, 35},{ 63, 0, 34},{ 63, 0, 34},
{ 63, 0, 33},{ 63, 0, 33},{ 63, 0, 32},{ 63, 0, 32}
},
    
{
{ 0, 0, 0},{ 63, 16, 0},{ 63, 15, 0},{ 63, 15, 0},
{ 63, 14, 0},{ 63, 13, 0},{ 63, 12, 0},{ 63, 11, 0},
{ 63, 10, 0},{ 63, 9, 0},{ 63, 8, 0},{ 63, 7, 0},
{ 63, 6, 0},{ 63, 5, 0},{ 63, 4, 0},{ 63, 3, 0},
{ 63, 2, 0},{ 63, 1, 0},{ 63, 0, 0},{ 63, 0, 0},
{ 62, 0, 0},{ 61, 0, 0},{ 61, 0, 0},{ 60, 0, 0},
{ 59, 0, 0},{ 58, 0, 0},{ 58, 0, 0},{ 57, 0, 0},
{ 56, 0, 0},{ 56, 0, 0},{ 55, 0, 0},{ 54, 0, 0},
{ 53, 0, 0},{ 53, 0, 0},{ 52, 0, 0},{ 51, 0, 0},
{ 51, 0, 0},{ 50, 0, 0},{ 49, 0, 0},{ 48, 0, 0},
{ 48, 0, 0},{ 47, 0, 0},{ 46, 0, 0},{ 46, 0, 0},
{ 45, 0, 0},{ 44, 0, 0},{ 43, 0, 0},{ 43, 0, 0},
{ 42, 0, 0},{ 41, 0, 0},{ 40, 0, 0},{ 40, 0, 0},
{ 39, 1, 1},{ 38, 1, 1},{ 37, 2, 2},{ 36, 2, 2},
{ 35, 3, 3},{ 35, 3, 3},{ 34, 4, 4},{ 33, 4, 4},
{ 33, 5, 5},{ 33, 5, 5},{ 33, 6, 6},{ 33, 6, 6},
{ 33, 7, 7},{ 33, 7, 7},{ 33, 8, 8},{ 33, 8, 8},
{ 33, 8, 8},{ 33, 8, 8},{ 33, 8, 8},{ 33, 8, 8},
{ 33, 8, 8},{ 33, 8, 8},{ 33, 8, 8},{ 33, 8, 8},
{ 33, 8, 8},{ 33, 8, 8},{ 33, 8, 8},{ 33, 8, 8},
{ 33, 8, 8},{ 33, 8, 8},{ 33, 8, 8},{ 33, 8, 8},
{ 35, 8, 8},{ 34, 8, 8},{ 35, 8, 8},{ 36, 8, 8},
{ 36, 8, 8},{ 37, 8, 8},{ 37, 8, 8},{ 37, 8, 8},
{ 37, 8, 8},{ 37, 8, 8},{ 38, 8, 8},{ 38, 8, 8},
{ 38, 8, 8},{ 38, 8, 8},{ 39, 8, 8},{ 41, 8, 8},
{ 42, 7, 7},{ 44, 6, 6},{ 45, 6, 6},{ 47, 5, 5},
{ 49, 5, 5},{ 50, 4, 4},{ 52, 4, 4},{ 53, 3, 3},
{ 55, 3, 3},{ 56, 2, 2},{ 58, 2, 2},{ 59, 1, 1},
{ 61, 1, 1},{ 63, 0, 0},{ 63, 1, 0},{ 63, 3, 0},
{ 63, 5, 0},{ 63, 7, 0},{ 63, 9, 0},{ 63, 11, 0},
{ 63, 13, 0},{ 63, 15, 0},{ 63, 17, 0},{ 63, 19, 0},
{ 63, 21, 0},{ 63, 23, 0},{ 63, 25, 0},{ 63, 27, 0},
{ 63, 29, 0},{ 63, 31, 0},{ 63, 33, 0},{ 63, 35, 0},
{ 63, 37, 0},{ 63, 39, 0},{ 63, 41, 0},{ 63, 43, 0},
{ 63, 45, 0},{ 63, 47, 0},{ 63, 49, 0},{ 63, 51, 0},
{ 63, 53, 0},{ 63, 55, 0},{ 63, 57, 0},{ 63, 59, 0},
{ 63, 61, 0},{ 63, 63, 0},{ 63, 63, 1},{ 63, 63, 3},
{ 63, 63, 5},{ 63, 63, 7},{ 63, 63, 9},{ 63, 63, 11},
{ 63, 63, 13},{ 63, 63, 15},{ 63, 63, 17},{ 63, 63, 19},
{ 63, 63, 21},{ 63, 63, 23},{ 63, 63, 25},{ 63, 63, 27},
{ 63, 63, 29},{ 63, 63, 31},{ 63, 63, 33},{ 63, 63, 35},
{ 63, 63, 37},{ 63, 63, 39},{ 63, 63, 41},{ 63, 63, 43},
{ 63, 63, 45},{ 63, 63, 47},{ 63, 63, 49},{ 63, 63, 51},
{ 63, 63, 53},{ 63, 63, 55},{ 63, 63, 57},{ 63, 63, 59},
{ 63, 63, 61},{ 63, 63, 61},{ 63, 63, 63},{ 63, 62, 62},
{ 63, 62, 61},{ 63, 61, 60},{ 63, 61, 59},{ 63, 60, 58},
{ 63, 60, 57},{ 63, 59, 56},{ 63, 59, 55},{ 63, 58, 54},
{ 63, 58, 53},{ 63, 57, 52},{ 63, 57, 51},{ 63, 56, 50},
{ 63, 56, 49},{ 63, 55, 48},{ 63, 55, 47},{ 63, 54, 46},
{ 63, 54, 45},{ 63, 53, 44},{ 63, 53, 43},{ 63, 52, 42},
{ 63, 52, 41},{ 63, 51, 40},{ 63, 51, 39},{ 63, 50, 38},
{ 63, 50, 37},{ 63, 49, 36},{ 63, 49, 35},{ 63, 48, 34},
{ 63, 48, 33},{ 63, 47, 32},{ 63, 46, 31},{ 63, 46, 30},
{ 63, 45, 29},{ 63, 45, 28},{ 63, 44, 27},{ 63, 44, 26},
{ 63, 43, 25},{ 63, 43, 24},{ 63, 42, 23},{ 63, 42, 22},
{ 63, 41, 21},{ 63, 41, 20},{ 63, 40, 19},{ 63, 40, 18},
{ 63, 39, 17},{ 63, 39, 16},{ 63, 38, 15},{ 63, 38, 14},
{ 63, 37, 13},{ 63, 37, 12},{ 63, 36, 11},{ 63, 36, 10},
{ 63, 35, 9},{ 63, 35, 8},{ 63, 34, 7},{ 63, 34, 6},
{ 63, 33, 5},{ 63, 33, 4},{ 63, 32, 3},{ 63, 32, 2},
{ 63, 31, 1},{ 63, 30, 0},{ 63, 30, 0},{ 63, 29, 0},
{ 63, 28, 0},{ 63, 27, 0},{ 63, 26, 0},{ 63, 25, 0},
{ 63, 24, 0},{ 63, 23, 0},{ 63, 22, 0},{ 63, 21, 0},
{ 63, 20, 0},{ 63, 19, 0},{ 63, 18, 0},{ 63, 17, 0}
}};
    
int Vid;  //Global variable

int huge DetectSVGA256()
{
  printf("\n Which video mode would you like to use? \n\n");
  printf(" 1 - 640x400x256\n");
  printf(" 2 - 640x480x256\n");
  printf(" 3 - 800x600x256\n");
  printf(" 4 - 1024x768x256\n\n ===> ");
  scanf("%d",&Vid);
  if((Vid<1) || (Vid)>4) Vid = 2;
  return Vid;
}

void main(void)
{
  int a, c, nx, ny, palflag=0, iopt;
  unsigned long k;
  double an, can, san, can1, san1, r, ax, ay, mult1, mult2;
  double x, xa, x1, x2, x3, y, y1, y2, y3, rand1, rand2;
  int graphdriver=DETECT, graphmode;

  clrscr();
  printf("\n Program KAMTORUS.CPP \n\n");
  printf("\n Select the multipliers: \n");
  printf("\n   0.990 and 1.010 (Ramiro's defaults)      --> Enter 1\n");
  printf("\n   0.995 and 1.005 (Ramiro's suggestion)    --> Enter 2\n");
  printf("\n   0.999 and 1.001 (Mike's new multipliers) --> Enter 3\n\n> ");

  scanf("%d",&iopt);
  if ((iopt > 3) || (iopt<1)) iopt = 2;
  if (iopt == 1) {mult1 = 0.990 ; mult2 = 1.010;}
  if (iopt == 2) {mult1 = 0.995 ; mult2 = 1.005;}
  if (iopt == 3) {mult1 = 0.999 ; mult2 = 1.001;}
  clrscr();

  installuserdriver("Svga256",DetectSVGA256);
  initgraph(&graphdriver,&graphmode,"C:\\BORLANDC\\BGI");
    
  if (Vid == 1) { nx = 320; ny = 200; ax = 640; ay = 533;}
  if (Vid == 2) { nx = 320; ny = 240; ax = ay = 640;}
  if (Vid == 3) { nx = 400; ny = 300; ax = 640; ay = 533;}
  if (Vid == 4) { nx = 512; ny = 384; ax = ay = 640;}

  randomize();
  do {
    cleardevice();
    palflag = (palflag + 1) %2;
    setVGApalette(palette[palflag][0]);
    c = 1;  
    rand1 = qsrandom();
    rand2 = qsrandom();
    an = 10.0*(rand1-rand2);
    can = mult1*cos(an);
    san = mult1*sin(an);
    can1 = mult2*cos(an);
    san1 = mult2*sin(an);
    x3 = 0.01;
    y3 = 0.01;
    do {
      xa = x3*x3 - y3;
      x2 = x3*can1 + xa*san1;
      y2 = x3*san1 - xa*can1;
      x3 = x2;
      y3 = y2;
      x = x2;
      y = y2;
      a = 0;
      do {
	xa = x*x - y;
	x1 = x*can + xa*san;
	y1 = x*san - xa*can;
	x  = x1;
	y  = y1;
	a++;
	putpixel((int)(ax*x+nx),(int)(ay*y+ny),c);
      }  while ((fabs(x1)<=2.0e3) && (fabs(y1)<=2.0e3) && a<=100);
      c++ %255 + 1;
    } while ((fabs(x2) <= 2.0e3) && (fabs(y2) <= 2.0e3));
    delay(1500);
  } while (!kbhit());
  getch();
  closegraph();
}
    
//==========================================================================
// Function to set all 256 color registers
//==========================================================================
#pragma warn -eff
void setVGApalette(char *buffer)
{
   int i, j;
    
   for (i=0;i<256;i++)
   {
      outp(0x3c8, i);
      for (j=0;j<3;j++)
	 outp(0x3c9, *buffer++);
   }
}
#pragma warn +eff
    
//==========================================================================
// Function to generate "random" numbers of 9 decimal places between 0 & 1
//==========================================================================
double qsrandom(void)
{
   int random_integer, temp_integer;
   double random_double, temp_double;
    
   random_integer = random(RAND_MAX);
   random_double = (double)random_integer / RAND_MAX;
   temp_integer = random(30519);
   temp_double = (double)temp_integer / 1000000000L;
   random_double += temp_double;
    
   return(random_double);
}
