//
//+---------------------------------------------------------------------+
//+ Program LORENZ.CPP                                                  +
//+ By Ramiro Perez {RPEREZ@UTPVM1.BITNET}, (Panama)                    +
//+ and Fausto A. A. Barbuto {BJ06@C53000.PETROBRAS.ANRJ.BR}, (Brazil). +
//+ C++ 3.1 programme's creator: Fausto A. A. Barbuto, April 14, 1994.  +
//+ After a TURBO BASIC program by Ramiro Perez.                        +
//+                                                                     +
//+ Plots Lorenz attractors with shaded, colourful spheres.             +
//+                                                                     +
//+ SVGA 256 colours version. Needs SVGA256.BGI and SVGA256.H.          +
//+ We suggest to change the start-up values of the arrays xa, ya, and  +
//+ za to witness how the attractor's shape change.                     +
//+ Press any key to stop and PAUSE to freeze the execution.            +
//+ Authorized version for spanky.triumf.ca site.                       +
//+---------------------------------------------------------------------+
//
#include <graphics.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include "svga256.h"

void Draw (double, double, int);
int Vid;  //Global variable

int huge DetectSVGA256()
{
  printf("\nWhich video mode would you like to use? \n\n");
  printf(" 0 - 320x200x256\n");
  printf(" 1 - 640x400x256\n");
  printf(" 2 - 640x480x256\n");
  printf(" 3 - 800x600x256\n");
  printf(" 4 - 1024x768x256\n\n> ");
  scanf("%d",&Vid);
  if((Vid<0) || (Vid)>4) Vid = 2;
  return Vid;
}

void main()
{
    int c, b, a, l, Iopt;
    double c1, cl, dt, xa[2], ya[2], za[2], x, y, z, x1, y1, z1, xd, yd;
    int graphdriver=DETECT, graphmode;

    clrscr();
    printf("\n                           Program LORENZ.CPP\n\n");
    printf("\n    Select an option:\n\n");
    printf("\n                0: Ramiro's default start-up values;\n");
    printf("\n                1: Enter your own start-up values;\n\n>> ");
    scanf("%d",&Iopt);
    if ((Iopt > 1) || (Iopt < 0)) Iopt = 0;
    clrscr();

    if (Iopt == 1) {
      printf("\n Enter initial value for xa[0] (-99: default is used)\n> ");
      scanf("%lf",&xa[0]);
      if (xa[0] == -99.0) xa[0] = 3.051522;
      printf("\n Enter initial value for xa[1] (-99: default is used)\n> ");
      scanf("%lf",&xa[1]);
      if (xa[1] == -99.0) xa[1] = 3.051522;
      printf("\n Enter initial value for ya[0] (-99: default is used)\n> ");
      scanf("%lf",&ya[0]);
      if (ya[0] == -99.0) ya[0] = 1.592542;
      printf("\n Enter initial value for ya[1] (-99: default is used)\n> ");
      scanf("%lf",&ya[1]);
      if (ya[1] == -99.0) ya[1] = 1.582542;
      printf("\n Enter initial value for za[0] (-99: default is used)\n> ");
      scanf("%lf",&za[0]);
      if (za[0] == -99.0) za[0] = 15.62388;
      printf("\n Enter initial value for za[1] (-99: default is used)\n> ");
      scanf("%lf",&za[1]);
      if (za[1] == -99.0) za[1] = 15.62388;
      clrscr();
    }

    installuserdriver("Svga256",DetectSVGA256);
    initgraph(&graphdriver,&graphmode,"C:\\BORLANDC\\BGI");
    cleardevice();

    c1 = 0.292893;
    dt = 0.02;
    a  = 5;
    b  = 15;
    c  = 1;
//
//  Default start-up values for xa, ya and za.
//
    if (Iopt == 0) {
      xa[0] = 3.051522;
      ya[0] = 1.592542;
      za[0] = 15.62388;
      xa[1] = xa[0];
      ya[1] = 1.582542;
      za[1] = za[0];
    }

    do {
      for (l=0;l<=1;l++) {
	x = xa[l];
	y = ya[l];
	z = za[l];
	x1 = x - a*x*dt + a*y*dt;
	y1 = y + b*x*dt - y*dt - z*x*dt;
	z1 = z - c*z*dt + x*y*dt;
	x = x1;
	y = y1;
	z = z1;
	xd = y - x*c1;
	yd = z + x*c1;
	if (l==1) {
	  cl = 0;
	  Draw(xd,yd,cl);
	}
	else {
	  cl = 7;
	  Draw(xd,yd,cl);
	}
	delay(4);  //Change the time delay to see it slower/faster;
	xa[l] = x;
	ya[l] = y;
	za[l] = z;
      }
    } while (!kbhit());
    getch();
    closegraph();
}

void Draw (double xd, double yd, int cl)
{
    double i1, j1, c, c1, c2, d1, d2;
    int i, k, colour;

    if (Vid == 0) { c1 =  9.7; c2 = 160.0; d1 =  4.6; d2 = 175.0; k=4;}
    if (Vid == 1) { c1 = 19.3; c2 = 325.0; d1 =  9.2; d2 = 345.0; k=7;}
    if (Vid == 2) { c1 = 19.3; c2 = 320.0; d1 = 11.0; d2 = 392.0; k=7;}
    if (Vid == 3) { c1 = 30.0; c2 = 400.0; d1 = 17.1; d2 = 550.0; k=9;}
    if (Vid == 4) { c1 = 38.4; c2 = 500.0; d1 = 21.9; d2 = 675.0; k=12;}

    i1 = c1*xd + c2;
    j1= -d1*yd + d2;

    for (i=1;i<=7;i++) {
      c = 0.09*i;
      colour = (i + cl) + 33;
      setcolor(colour);
      setfillstyle(SOLID_FILL,k);
      circle ((int)(i1+c),(int)(j1+c),k);
      k--;
    }
    return;
}

