#include <rhalib.h>
#include <graphics.h>
#include <svga256.h>

char s[255];

int huge DetectVGA() {
	int Vid;
	printf("Choose a video mode:\n");
	printf("  1)  VGA  [320  x 200]\n");
	printf("  2)  SVGA [640  x 480]\n");
	printf("  3)  SVGA [800  x 600]\n");
	printf("  4)  SVGA [1024 x 768]\n");
	gets(s);
	if (sscanf(s, "%d", &Vid) < 1) Vid=VGA320x200;
	return(Vid);
}

void init() {
	int Gd=DETECT, Gm;
	installuserdriver("SVGA256",DetectVGA);
	initgraph(&Gd,&Gm,getenv("BGIDIR"));
	if (graphresult() != grOk) {
                printf("Unable to initialize graphics driver\n");
	        exit(1);
	}
}

void box(int, int, int, int);

void main() {
	double rxy[2], x0, x1, x2, y1, y2, dx, dy, d, al;
	int nx, ny, xmax, x, y, iter, niter, i, j, k, l;
	
	printf("Enter x dimension (default = 80): ");
	gets(s);
	if (sscanf(s, "%d", &nx) < 1) nx=80;
	printf("Enter y dimension (default = 60): ");
	gets(s);
	if (sscanf(s, "%d", &ny) < 1) ny=60;

	printf("Enter window xmin (default -2.0): ");
	gets(s);
	if (sscanf(s, "%lf", &x1) < 1) x1 = -2.0;

	printf("Enter window xmax (default 2.0): ");
	gets(s);
	if (sscanf(s, "%lf", &x2) < 1) x2 = 2.0;

	printf("Enter window ymin (default -2.0): ");
	gets(s);
	if (sscanf(s, "%lf", &y1) < 1) y1 = -2.0;

	printf("Enter window ymax (default 2.0): ");
	gets(s);
	if (sscanf(s, "%lf", &y2) < 1) y2 = 2.0;

	printf("Enter iterations (default 100): ");
	gets(s);
	if (sscanf(s, "%d", &niter) < 1) niter = 100;

	printf("Enter bailout (default 100): ");
	gets(s);
	if (sscanf(s, "%d", &xmax) < 1) xmax = 100;

	init();

// Set parameter ranges
	x0 = atan(1.0);

// Determine pixel steps
	dx = (x2 - x1) / (double)nx;
	dy = (y2 - y1) / (double)ny;

// Outline the screen
	box (0, 0, nx-1, ny-1);

// Start iterating
// This set up uses a 2 element array rxy[2] to do the periodic
// forcing.  At each iteration, the MOD (%) function is used to
// determine which value of r[] to use.
	for (j = 0; j < ny; j++) {
		rxy[0] = dy * (double)j + y1;
		for (i = 0; i < nx; i++) {
			rxy[1] = dx * (double)i + x1;
			x = x0;
			if (kbhit()) {
				closegraph();
				return;
			}

// For some combinations, the iteration blows up.
// Track and skip these.
			for (iter = 0; iter < niter; iter++) {
				l = iter % 2;
				x = x * (rxy[l] - x);
				if (fabs(x) > (double)xmax) {
					k = 0;
					goto colorpix;
				}
				if (kbhit()) {
					closegraph();
					return;
				}
			}
			al = 0;
// After the transients have died out, compute the average exponent.
			for (iter = 0; iter < niter; iter++) {
				l = iter % 2;
				x = x * (rxy[l] - x);
				if (fabs(x) > (double)xmax) {
					k = 0;
					goto colorpix;
				}
				if (kbhit()) {
					closegraph();
					return;
				}
				d = fabs(rxy[l] - 2 * x);
				if (d == 0) d = .0000000001;
				al = al + log(d);
			}
			al = al / niter;

// If the exponent is >0 , color it black for chaotic orbits.
// If not, then multiply the exponent by -100 & take the MOD 255 to
// choose a color.
			if (al > 0) k = 0;
				else k = (((int)al * (-100)) % 255) + 1;

colorpix:;		putpixel(i, j, k);
	 
		}
	}
	getch();
	closegraph();
}

void box(int a, int b, int c, int d) {
	setcolor(15);
	line(a, b, c, b);
	line(a, d, c, d);
	line(a, b, a, d);
	line(c, b, c, d);
}
