/*   CUMULUS.H--- Header file for cumulus cloud template */

#define NPOINTS 7    /* Number of points on the "parent" polygon */
#define NTRANS  6    /* Number of transformed "children" */
#define NLEVELS 5    /* Number of levels to draw */
#define COUNT 10000  /* Number of dots to paint */
#define CENTERX 320  /* Center of the screen */
#define CENTERY 240
#define SEEDX 23,17,-4,-10,-27,7,44  /* The "parent" polygon */
#define SEEDY 0,55,55,0,9,-66,10

/* The tranformations which define the "children" */
#define MOVEX   85,-94,-3,51.5,-49,0  /* Displacement */
#define MOVEY   15,13,3.5,-35,-40,40
#define SIZEX   .36,.4,.53,.48,.4,.87    /* Size change */
#define SIZEY   .36,.47,.53,.53,.4,.33
#define SPINX   .25,6,6.2,0.15,6.2,0    /* Rotation */
#define SPINY   .25,6,6.2,0.15,6.2,6.3

/* The following color definitions are ignored by the SIERP program
   and used only by FRACDRAW.
   PALETTE defines the 16-color VGA palette
   COLOR intializes a two-dimensional array with color values:
   each column in the array definition below corresponds to one level
   of detail, and each row corresponds to a "part", or transformation.
   Note that the array only needs to be 6 by 3 for the template defined
   above, but more rows are included in case the user inserts additional
   "parts".
*/
#define PALETTE {_BLACK, _RED, _GREEN, _CYAN, \
		_BLUE, _MAGENTA, _BROWN, _WHITE, \
		_GRAY, _LIGHTBLUE, _LIGHTGREEN, _LIGHTCYAN, \
		_LIGHTRED, _LIGHTMAGENTA, _LIGHTYELLOW, _BRIGHTWHITE}

#define COLOR {{15,15,15, 7, 8},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15}}
