/*   FLAKE.H ---     Header file for snowflake template
     This (and the other header files like it) can be used to define
     the initial fractal template for the SIERP.C and FRACDRAW.C programs
     This template models the crystalization process to draw a realistic
     snowflake shape
*/
#define NPOINTS 6    /* Number of points on the "parent" polygon */
#define NTRANS  6    /* Number of transformed "children" */
#define NLEVELS 5    /* Number of levels to draw */
#define COUNT 10000  /* Number of dots to paint */
#define CENTERX 320  /* Center of the screen */
#define CENTERY 240
#define SEEDX 1,21,21,1,-21,-21  /* The "parent" polygon */
#define SEEDY -27,-15,9,40,9,-15

/* The tranformations which define the "children" */
#define MOVEX -1,55,55,1,-55,-55  /* Displacement */
#define MOVEY -65,-35,35,65,35,-35
#define SIZEX   .18,.18,.18,.18,.18,.18    /* Size change */
#define SIZEY   .91,.91,.91,.91,.91,.91
#define SPINX   0,1.05,2.09,3.14,4.19,5.24    /* Rotation */
#define SPINY   0,1.05,2.09,3.14,4.19,5.24

/* The following color definitions are ignored by the SIERP program
   and used only by FRACDRAW.  See comments in SIERP.H */

#define PALETTE {_BLACK, _RED, _GREEN, _CYAN, \
	         _BLUE, _MAGENTA, _BROWN, _WHITE, \
		 _GRAY, _LIGHTBLUE, _LIGHTGREEN, _LIGHTCYAN, \
		 _LIGHTRED, _LIGHTMAGENTA, _LIGHTYELLOW, _BRIGHTWHITE}

#define COLOR {{15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15}}
