/*   PINE.H
     Header file for pine tree template
	 This (and the other header files like it) can be used to define
	 the initial fractal template for the SIERP.C and FRACDRAW.C programs
*/

#define NPOINTS 4    /* Number of points on the "parent" polygon */
#define NTRANS  6    /* Number of transformed "children" */
#define NLEVELS 5    /* Number of levels to draw */
#define COUNT 10000  /* Number of dots to paint */
#define CENTERX 320  /* Center of the screen */
#define CENTERY 350
#define SEEDX 6,20,-6,-12  /* The "parent" polygon */
#define SEEDY -120,120,120,-120

/* The tranformations which define the "children" */

#define MOVEX -41.2,36.9,5.13,-14.64,2.2,40.07 /* Displacement */
#define MOVEY 14.987,-61.31,7.10,-32.33,-50.46
#define SIZEX  0.39,0.41,0.52,0.35,0.86,0.37 /* Size change */
#define SIZEY  0.39,0.31,0.17,0.24,0.79,0.42
#define SPINX  5.62,0.61,6.15,5.43,3.27,0.54 /* Rotation */
#define SPINY  4.91,1.27,0.13,4.71,6.28,1.4

/* The following color definitions are ignored by the SIERP program
   and used only by FRACDRAW.

   PALETTE defines the 16-color VGA palette
   COLOR intializes a two-dimensional array with color values:
   each column in the array definition below corresponds to one level
   of detail, and each row corresponds to a "part", or transformation.
   Note that the array only needs to be 6 by 3 for the template defined
   above, but more rows are included in case the user inserts additional
   "parts".
*/

#define PALETTE {_BLACK, _RED, _GREEN, _CYAN, \
				_BLUE, _MAGENTA, _BROWN, _WHITE, \
				_GRAY, _LIGHTBLUE, _LIGHTGREEN, _LIGHTCYAN, \
				_LIGHTRED, _LIGHTMAGENTA, _LIGHTYELLOW, _BRIGHTWHITE}
#define COLOR {{6, 6,14,10, 2},\
               {6, 6,14,10, 2},\
               {6, 6,14,10, 2},\
               {6, 6,14,10, 2},\
               {6, 6,14,10, 2},\
               {6, 6,14,10, 2},\
               {6, 6,14,10, 2},\
               {6, 6,14,10, 2},\
               {6, 6,14,10, 2}}
