LISTING 2================================================================

/*   SIERP.H --	 Header file for Sierpinski's Triangle template
     This (and the other header files like it) can be used to define
     the initial fractal template for the SIERP.C and FRACDRAW.C programs
*/
#define NPOINTS 3    /* Number of points on the "parent" polygon */
#define NTRANS  3    /* Number of transformed "children" */
#define NLEVELS 6    /* Number of levels to draw */
#define COUNT 10000  /* Number of dots to paint */
#define CENTERX 320  /* Center of the screen x, y*/
#define CENTERY 240
#define SEEDX -200,  200,  0  /* The "parent" polygon */
#define SEEDY -200, -200, 200

        /* The tranformations which define the "children" */
#define MOVEX -100.0,  100.0,   0.0  /* Displacement */
#define MOVEY -100.0, -100.0, 100.0
#define SIZEX   0.5,   0.5,   0.5    /* Size change */
#define SIZEY   0.5,   0.5,   0.5
#define SPINX   0.0,   0.0,   0.0    /* Rotation */
#define SPINY   0.0,   0.0,   0.0

/* The following color definitions are ignored by the SIERP program
   and used only by FRACDRAW.
   PALETTE defines the 16-color VGA palette
   COLOR intializes a two-dimensional array with color values:
   each column in the array definition below corresponds to one level
   of detail, and each row corresponds to a "part", or transformation.
   Note that the array only needs to be 6 by 3 for the template defined
   above, but more rows are included in case the user inserts additional
   "parts".
*/

#define PALETTE {_BLACK, _RED, _GREEN, _CYAN, \
		 _BLUE, _MAGENTA, _BROWN, _WHITE, \
		 _GRAY, _LIGHTBLUE, _LIGHTGREEN, _LIGHTCYAN, \
		 _LIGHTRED, _LIGHTMAGENTA, _LIGHTYELLOW, _BRIGHTWHITE}

#define COLOR   {{2, 2, 2, 2, 2, 2},\
	         {1, 1, 1, 1, 1, 1},\
		 {5, 5, 5, 5, 5, 5},\
		 {4, 4, 4, 4, 4, 4},\
		 {2, 2, 2, 2, 2, 2},\
		 {3, 3, 3, 3, 3, 3},\
		 {7, 7, 7, 7, 7, 7},\
		 {8, 8, 8, 8, 8, 8},\
		 {1, 1, 1, 1, 1, 1}}
		 

