/*   STRATUS.H
     Header file for stratus cloud template
	 This (and the other header files like it) can be used to define
	 the initial fractal template for the SIERP.C and FRACDRAW.C programs
*/

#define NPOINTS 6    /* Number of points on the "parent" polygon */
#define NTRANS  5    /* Number of transformed "children" */
#define NLEVELS 5    /* Number of levels to draw */
#define COUNT 10000  /* Number of dots to paint */
#define CENTERX 320  /* Center of the screen */
#define CENTERY 240
#define SEEDX 40,80,40,-40,-80,-40  /* The "parent" polygon */
#define SEEDY 22,-2,-22,-22,2,22

/* The tranformations which define the "children" */

#define MOVEX -70,-44,45,60,-3.3  /* Displacement */
#define MOVEY 11,-34,-31,1.6,42
#define SIZEX   .75,.43,.38,.75,.8    /* Size change */
#define SIZEY   .45,.47,.44,.61,.2
#define SPINX   6.3,6.3,6.3,6.3,0    /* Rotation */
#define SPINY   6.3,6.3,6.3,6.3,6.3

/* The following color definitions are ignored by the SIERP program
   and used only by FRACDRAW.

   PALETTE defines the 16-color VGA palette
   COLOR intializes a two-dimensional array with color values:
   each column in the array definition below corresponds to one level
   of detail, and each row corresponds to a "part", or transformation.
   Note that the array only needs to be 6 by 3 for the template defined
   above, but more rows are included in case the user inserts additional
   "parts".
*/

#define PALETTE {_BLACK, _RED, _GREEN, _CYAN, \
				_BLUE, _MAGENTA, _BROWN, _WHITE, \
				_GRAY, _LIGHTBLUE, _LIGHTGREEN, _LIGHTCYAN, \
				_LIGHTRED, _LIGHTMAGENTA, _LIGHTYELLOW, _BRIGHTWHITE}
#define COLOR {{15,15,15,7,8},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15}}
