/*   ZOOM.H
     Header file for abstract zooming artwork template
	 This (and the other header files like it) can be used to define
     the initial fractal template for the SIERP.C and FRACDRAW.C programs

     Note that this very simple template creates a visually complex image,
     while seemingly simple linear forms like the cartoon mouse require
     much more work and information to express as fractals.  When drawing
     with fractals, richly detailed trees are simpler and easier to create
     than smooth objects like tables and chairs!
*/

#define NPOINTS 5    /* Number of points on the "parent" polygon */
#define NTRANS  5    /* Number of transformed "children" */
#define NLEVELS 4    /* Number of levels to draw */
#define COUNT 20000  /* Number of dots to paint */
#define CENTERX 320  /* Center of the screen */
#define CENTERY 340
#define SEEDX -66,-334,60,272,66
#define SEEDY -7,100,-120,-27,55

/* The tranformations which define the "children" */

#define MOVEX 55,104,185,30,-45
#define MOVEY -309,-1,-50,28,-25
#define SIZEX .27,.36,.5,.28,.98
#define SIZEY .27,.27,.18,.21,.5
#define SPINX 4.71,3.88,3.34,4.3,6
#define SPINY 2.48,.93,.39,1.16,6

/* The following color definitions are ignored by the SIERP program
   and used only by FRACDRAW.

   PALETTE defines the 16-color VGA palette
   COLOR intializes a two-dimensional array with color values:
   each column in the array definition below corresponds to one level
   of detail, and each row corresponds to a "part", or transformation.
   Note that the array only needs to be 6 by 3 for the template defined
   above, but more rows are included in case the user inserts additional
   "parts".
*/

#define PALETTE {_BLUE, _RED, _GREEN, _CYAN, \
                _BLACK, _MAGENTA, _BROWN, _WHITE, \
				_GRAY, _LIGHTBLUE, _LIGHTGREEN, _LIGHTCYAN, \
				_LIGHTRED, _LIGHTMAGENTA, _LIGHTYELLOW, _BRIGHTWHITE}
#define COLOR {{15,15,15,15},\
               {14,14,14,14},\
               {14,14,14,14},\
               {14,14,14,14},\
               {14,14,14,14},\
               {15,15,15,15},\
               {15,15,15,15}}
