//
//+---------------------------------------------------------------------+
//+ PROGRAM SPIRAL.CPP                                                  +
//+ By Fausto A. A. Barbuto - Rio de Janeiro, BRAZIL, June 25, 1994.    +
//+ E-mail: BJ06@C53000.PETROBRAS.ANRJ.BR                               +
//+                                                                     +
//+ Plots spiral plant forms from a randomic complex number u = v + wi. +
//+                                                                     +
//+ REFERENCE: Pickover, Clifford A.: "Computers, Pattern, Chaos and    +
//+            Beauty", St. Martin's Press, New York, 1990;  pg. 203    +
//+            (Pseudocode 12.1)                                        +
//+                                                                     +
//+ Random number generator by Michael Sargent, msargent@moose.uvm.edu. +
//+ SVGA256.BGI graphic driver by Jordan Powell Hargrave.               +
//+                                                                     +
//+ Press ESC at any time to stop execution, or PAUSE to freeze.        +
//+                                                                     +
//+---------------------------------------------------------------------+
//
#include <stdio.h>
#include <conio.h>
#include <graphics.h>
#include <math.h>
#include <stdlib.h>
#include <complex.h>
#include "svga256.h"

double qsrandom(void);
int Vid;  //* Global variable *//

int huge DetectVGA256()
{
  printf("\n Which video mode would you like to use? \n\n");
  printf(" 0 - 320x200x256\n");
  printf(" 1 - 640x400x256\n");
  printf(" 2 - 640x480x256\n");
  printf(" 3 - 800x600x256\n");
  printf(" 4 - 1024x768x256\n\n> ");
  scanf("%d",&Vid);
  return Vid;
}

void main(void)
{
     double x, xmin, xmax, y, ymin, ymax, deltax, deltay;
     double v, w, Tolerance=10.0;
     complex a, b, c, d, e, f, u, z;
     int npix, npiy, nx, ny, k, icount;
     int graphdriver=DETECT, graphmode;

     clrscr();
     printf(" Program PLANTS.CPP \n\n\n");
     installuserdriver("Svga256",DetectVGA256);
     initgraph(&graphdriver, &graphmode, "C:\\BORLANDC\\BGI");

     if (Vid == 0) { npix = 320; npiy = 200;}
     if (Vid == 1) { npix = 640; npiy = 400;}
     if (Vid == 2) { npix = 640; npiy = 480;}
     if (Vid == 3) { npix = 800; npiy = 600;}
     if (Vid == 4) { npix =1024; npiy = 768;}
     if ((Vid>4) || (Vid<0)) { npix = 640; npiy = 480;}

     xmin=-2.0; xmax=2.00;
     ymin=-2.0; ymax=2.00;
     deltax = (xmax-xmin)/(npix-1);
     deltay = (ymax-ymin)/(npiy-1);
     icount = 0;

     do {
       cleardevice();
       if (icount == 0) {   //* As suggested on Dr. Pickover's book *//
	 v = 0.35;
	 w = 0.35;
       }
       else {               //* Random v & w *//
	 w = qsrandom();    //* Not all combinations of v,w will be able to
	 v = qsrandom();    //* generate beatiful structures. Be patient!
       }
       icount=1;
       u = complex(v,w);

       for (nx=0; nx<=npix-1; nx++) {
	 x = xmin + (double)nx*deltax;
	 for (ny=0; ny<=npiy-1; ny++) {
	   y = ymin + (double)ny*deltay;
	   a = complex(0.0,0.0);
	   b = a; c = a; d = a; e = a; f = a;
	   z = complex(x,y);
	   for (k=1;k<=31;k++) {  //* Inner Loop *//
	     a = z;
	     e = a*a + u;
	     c = e*e + u;
	     b = c*c + u;
	     f = b;
	     a = f*f + u;
	     z = a;
	     if (abs(z) > Tolerance) break;
	     else  //* A few gray contours are OK. *//
	       putpixel(nx,ny,18+(int)(abs(z)));
	   }
	   if ((fabs(real(z)) < Tolerance) || (fabs(imag(z)) < Tolerance))
	     putpixel(nx,ny,k+31); //* Hey, aren't these Julia sets??? *//
	 }
	 if (kbhit()) break;
       }
     } while (!kbhit());
//
//---Clean up and end.
//
     getch();
     closegraph();
}
//
//---qsrandom function by Mike Sargent.
//
double qsrandom(void)
{
   int random_integer, temp_integer;
   double random_double, temp_double;
    
   random_integer = random(RAND_MAX);
   random_double = (double)random_integer / RAND_MAX;
    
   temp_integer = random(30519);
   temp_double = (double)temp_integer / 1000000000L;
   random_double += temp_double;

   return(random_double);
}
