Path: unixg.ubc.ca!news.mic.ucla.edu!library.ucla.edu!europa.eng.gtefsd.com!paladin.american.edu!auvm!NS.PA!rperez
Comments: Gated by NETNEWS@AUVM.AMERICAN.EDU
Newsgroups: bit.listserv.frac-l
Mime-Version: 1.0
Content-Type: TEXT/PLAIN; charset=US-ASCII
content-length: 19571
Message-ID: <Pine.3.89.9412230132.A11881-0100000@ns.pa>
Date: Fri, 23 Dec 1994 01:14:00 -0500
Sender: "\"FRACTAL\" discussion list" <FRAC-L@GITVM1.BITNET>
From: Ramiro Perez <rperez@NS.PA>
Subject: A fractal gift for frac-l people (warning:long)
Lines: 738
 
Hello,
 
Firstly, Merry Christmas to all,
 
Here's a program that I've made, which displays 40 strange attractors in SVGA.
This program has the ability to search for strange attractors testing the
equations with random parameters until an attractor is found.
 
I offer this program as a Christmas gift to FRAC-L people, but since I got
a pulmonary sickness during the last week, I didn't build the full
documentation. Anyways, the program is completed, and I will build a full
doc as soon as I feel better -  but don't worry, here is a small explanation
on how to use the program, so enjoy it!
 
First, the program asks you the video mode you're willing to use, then what
attractor do you want to test.
 
Once you select the video mode and the attractor type the program asks you
about the type of the colouring method you want. There are two options: by
Distance, on where the program uses a rainbow palette and the colour is
determined by the distance between the last iteration and the actual
iteration (use this with the 32,36,20 and any other you may will), and by
Frequency, on where the program use a blue palette. This one is an old
method for displaying attractors, on where the colour of the pixel is
determined by the number of times the orbit is visited by it.
 
After that, the program asks you if you wish to change the colours. At this
point you can load a fractint map file if you wish, or use the default colour
maps that are included on the program (a rainbow palette that I got from
frac-xtra, and a blue-grey palette which is internally calculated).
 
Then the fun begins:  first, the program assigns a random value to the
parameters (p1,p2..p16) of the equation, then the iteration cycle begins.
The parameters are changed if the iteration goes to the infinity or fall into
a periodic cycle, and the line at the top of the screen is increased by one
pixel.
 
If the iteration counter reach to 10000, the program computes the
corners of the attractor, clears the screen, and the image begins
to materialize on the screen.
 
If you choose the default blue palette for the display method, you shall
wait for the image (turn off the light if you have selected a very dark
p8alette which has very dark first colours)..
 
In some cases, the attractor is an invariant circle, then press the space bar
to skip it.  (you can press the spc bar if you don't like the image that you
are seeing, at any time of the entire process)
 
The flashes that you see in the screen are due to the orbits, on where I've
changed the first colours to white in order to see the form of them. (the
palette returns to the normal when the attractor is choosen)
 
Well, as an example, try Storm Julia with the Frequency display metod, and a
brightness value of 1 for the default colours (turn off the lights), or
ifs/ikeda in the same form (in this case, press the spc bar until you see
something interesting). For the distance colouring method use the star,
icons, and frothystars, and wait until the image is complete.
 
I got the inspiration thanks to the images that The Flame program
(created by Scott Draves) which also apears on the book written by
Mr. Julien Sproot which is related to the search of Strange attractors,
But since I don't have the book  I don't know how it works.
 
             Sincerely
 
                       Ramiro Perez
 
 
PS: I've made all of the attractors in this program, except the ones marked
with asteriscs, such as the one called King's Dreams, that was made by Dr.
Clifford A. Pickover.
 
//+-----------------------------------------------------+
//|Program SVGATTR.CPP by Ramiro Perez (rperez@ns.pa)   |
//|Displays 40 Strange Attractors in SVGA video modes   |
//|Requires the svga256.bgi driver made by Jordan Powell|
//|Hargrave.                                            |
//|Random number generator by Michael Sargent           |
//+-----------------------------------------------------+
 
 
#include <math.h>
#include <graphics.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
float p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16,x1,y1,pi;
int Video;
int sw2;
int cr[257],cg[257],cb[257],i,br;
char ranr[256]={12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,
13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32,33,34,35,36,37,40,
39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,62,61,60,59,58,57,56,55,54,
53,52,51,50,49,48,47,46,45,44,43,42,41,40,39,38,37,36,35,34,33,32,31,30,29,
28,27,26,25,24,23,22,21,20,19,18,17,16,16,16,15,15,15,14,14,14,13,13,13,12,
12,12,11,11,11,10,10,10,9,9,9,8,8,7,7,7,6,6,6,5,5,5,4,4,4,3,3,3,2,2,2,1,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 
char rang[256]={12,18,16,15,14,12,11,10,8,7,6,4,3,2,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,
18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,
43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,62,62,62,61,
61,60,60,60,59,59,58,58,58,57,57,56,56,56,55,55,54,54,54,53,53,53,52,52,51,
51,51,50,50,49,49,49,48,48,47,47,47,46,46,45,44,43,42,40,39,38,36,35,34,32,
31,30,28,27,26,24,23,22,20,19};
 
char ranb[256]={12,52,53,53,54,55,56,57,58,58,59,60,61,62,63,62,61,60,59,58,
57,56,55,54,53,52,51,50,49,48,47,46,45,44,43,42,41,40,39,38,37,36,35,34,33,
31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,
5,4,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,2,3,3,4,5,6,6,7,8,9,9,10,11,12,12,13,14,15,15,16,17,18,
19,19,20,21,22,22,23,24,25,25,26,27,28,28,29,30,31,31,32,33,34,35,35,36,37,
38,39,39,40,41,42,43,44,44,45,46,47,48,48,49,50,51};
 
int huge DetectSVGA256()
{
  if ((Video>4) || (Video<0)) Video = 2;
  return Video;
}
double rnd(void);
        void cmaps(int p);
 
/*Routine for computing the corners*/
void rwindow(float xm, float ym, float xa, float ya, float *dx, float *dy,
                float *lx, float *ly)
{
  float diax,diay;
  diax=(xa-xm);
  diay=(ym-ya);
  *dx=getmaxx()/diax;
  *dy=getmaxy()/diay;
  *lx=xm * *dx;
  *ly=ya * *dy;
}
 
 
 
void fmap(void) { /*routine for reading a Fractint map file*/
 
   FILE *fp;
   char ch[100];
   i=0;
   system("Dir *.map /w /p");
   printf("\nMap File: ");
   scanf("%s",&ch);
   if ((fp=fopen(ch,"rt"))==NULL){
    printf("cannot open map file \n");
    }
    else {
   do
   {
   if (fscanf(fp, "%i%i%i", &cr[i],&cg[i],&cb[i])!=3) fgets(ch,80,fp);
   else {
   cr[i]=(int)(cr[i]/4);
   cb[i]=(int)(cb[i]/4);
   cg[i]=(int)(cg[i]/4);
   i++;
    }
    } while(!feof(fp));
 
   fclose(fp);
   printf("Done \n");
   }
   }
 
 
 void cmap(void){ /* blue palette for frecuency plots*/
 printf("\nBrightness 0--10 (0=darkest, 10=brightness):");
 scanf("%d",&br);
 for (i=1; i<=255; i++){
    cr[i]=i*0.25+br; if (cr[i]>63) cr[i]=63;
    cg[i]=i*0.25+br; if (cg[i]>63) cg[i]=63;
    cb[i]=5+i*.2+br; if (cb[i]>63) cb[i]=63;
    }
 }
 
 void rmap(void){ /*rainbow palette for distance plot*/
  for (i=1; i<=255; i++){
    cr[i]=ranr[i];
    cg[i]=rang[i];
    cb[i]=ranb[i];
    }
    }
 
void selectv()
{
 clrscr();
 printf("\n Which video mode would you like to use? \n\n");
 printf(" 0 - 320x200x256\n");
 printf(" 1 - 640x400x256\n");
 printf(" 2 - 640x480x256 (suggested when available)\n");
 printf(" 3 - 800x600x256\n");
 printf(" 4 - 1024x768x256\n\n> ");
 scanf("%d",&Video);
  if ((Video>4) || (Video<0)) Video = 2;
}
 
void main() { /*Main!*/
    int k,a,b,op,j,l,col;
    float z,dx,dy,lx,ly,x,y,rad;
    float xb,yb,s,c1;
    float xn1,yn1,xa,ya;
    float xm,ym,xc,yc,ax,ay;
    float tx,ty,tx1,ty1,tx2,ty2,tx3,ty3,tz,xr,yr;
    int x2,y2,p;
    char sw,ch;
    int graphdriver=DETECT, graphmode;
    sw2=0;
    sw=5;
    pi=3.141592653;
    selectv();
    installuserdriver("Svga256",DetectSVGA256);
    for (i=1; i<=255; i++){
    cr[i]=i*0.25+br; if (cr[i]>63) cr[i]=63;
    cg[i]=i*0.25+br; if (cg[i]>63) cg[i]=63;
    cb[i]=5+i*.2+br; if (cb[i]>63) cb[i]=63;
    }
 
 
do {
clrscr();
printf("Phase Space I: 2D Strange Attractors  \n");
printf("by Ramiro Perez (rperez@ns.pa)\n");
printf("Select :\n");
printf("           1 -Atoms                           21 -Conditional Ifs\n");
printf("           2 -Double Helix                    22 -Storm Julia(imm/imm)\n
");
printf("           3 -Mult. Param. 1                  23*-Duffing Oscillator\n")
;
printf("           4 -Mult. Param. 2                  24*-GingerBreadman\n");
printf("           5 -Thing                           25*-King's Dream\n");
printf("           6 -Ginger-Hop                      26*-Samardiza Oscillator\n
");
printf("           7 -Loops                           27*-Ikeda\n");
printf("           8 -Rings                           28*-FrothyBasin formula\n"
);
printf("           9 -X wings                         29 -Cosine\n");
printf("          10 -Ameba                           30 -Frost Julia\n");
printf("          11 -Mult. Param. 3                  31 -FrothyStars\n");
printf("          12 -Ifs-Mandel                      32 -Star (icon 4 var.)\n")
;
printf("          13*-Ifs                             33 -Spirals (kamtorus var.
)\n");
printf("          14 -Iris                            34 -Ifs/Icon4\n");
printf("          15 -Medusa                          35 -Flakes in the Wind\n")
;
printf("          16 -Mult. Param. 4                  36*-Icons\n");
printf("          17 -Disk                            37*-Duffing II\n");
printf("          18 -Strips                          38*-Volterra\n");
printf("          19 -Real Mandelbrot                 39 -Paintings\n");
printf("          20 -Ikeda/Ifs                       40 -Cosine Waves\n");
printf("                           Option:");
scanf("%d",&op);
clrscr();
printf ("Colouring metod:  [D]istance or  [F]recuency:");
ch=getch();
if (ch=='D' || ch=='d') sw2=1; else sw2=0;
if ((ch=='D' || ch=='d') && sw==5) rmap();
printf ("\nDo you wish to Change the Colours (Y/N):");
        ch=getch();
        if (ch =='y' || ch=='Y') {
        printf ("\nDo you wish to load a fractint map file (Y/N):");
        ch=getch();
        if (ch =='y' || ch=='Y') fmap(); else {
        printf ("\nDo you wish to use the default colour map (Y/N):");
        ch=getch();
        if (ch =='y' || ch=='Y')
        {
         if (sw2==1) rmap(); else cmap();
         }
        }
        }
 
    initgraph(&graphdriver,&graphmode,"C:\\BORLANDC\\BGI");
    cleardevice();
    for (i=1; i<=255; i++){
    setrgbpalette(i, cr[i], cg[i], cb[i]);
    putpixel(i,0,i);
    }
    kbhit();
    randomize();
    rwindow (-2,-1.5,2,1.5,&dx,&dy,&lx,&ly);
    l=0;
 
    do { /*Initializing the variables and palettes*/
          rad=1;
          cleardevice();
          x=(rnd()-rnd())*0.25;
          y=(rnd()-rnd())*0.25;
          sw=0; j=random(10);
          p1=(rnd()-rnd())*2; p2=(rnd()-rnd())*2;
          p3=(rnd()-rnd())*2; p4=(rnd()-rnd())*2;
          p5=(rnd()-rnd())*2; p6=(rnd()-rnd())*2;
          p7=(rnd()-rnd())*2; p8=(rnd()-rnd())*2;
          p9=(rnd()-rnd())*2; p10=(rnd()-rnd())*2;
          p11=(rnd()-rnd())*2; p12=(rnd()-rnd())*2;
          p13=(rnd()-rnd())*2; p14=(rnd()-rnd())*2;
          p15=(rnd()-rnd())*2; p16=(rnd()-rnd())*2;
          tx=1; ty=1; tz=1;
          xa=0; ya=0; xc=0; yc=0; xm=0; ym=0; k=0; l++;
          rwindow (-2,-1.5,2,1.5,&dx,&dy,&lx,&ly);
          setcolor(getmaxcolor());
          if (l>getmaxx()) l=0;
          line (0,0,l,0);
          setrgbpalette(1,63,63,63);
          setrgbpalette(2,63,63,63);
          setrgbpalette(3,63,63,63);
          setrgbpalette(4,63,63,63);
          setrgbpalette(255,63,63,63);
 
do
{
switch (op) {
 
case 1:{ /* Atoms */
        x1=x*sin(y)+cos(y)*4*p1;
        y1=y*cos(x)+sin(y)*4*p1;
        }; break;
 
case 2:{ /* Double Helix */
        x1=x+(y*p1)*2;
        y1=(p1*x-p2*y)*(p2+x*x);
        };break;
 
case 3:{ /* Mult. Param. 1 */
        x1=x*(p2*y+p3*x+p4)+y*(p5*x+y)+p1;
        y1=x*(p8*y+p9*x+p10)+y*(p11*x+y)+p7;
        }; break;
 
case 4:{ /* Mult. Param. 2 */
        x1=p1*x+x*(p2*y+p3*x*x)+p4*y+y*(p5*x+p6*y*y);
        y1=p7*x+x*(p8*y+p9*x*x)+p10*y+y*(p11*x+p12*y*y);
        }; break;
 
case 5:{ /* Thing */
        x1=-x*y+p2+x*(1-y);
        y1=x*x-p1*y;
        }; break;
 
case 6:{ /* Ginger-Hop */
        x1=y-p2*sqrt(fabs(x*p1));
        y1=-x;
        }; break;
 
case 7:{ /* Loops */
        p3=p1*x-p2*y;
        x1=p3*(-p1+y*y);
        y1=p3*(x*x+p2);
        }; break;
 
case 8:{ /* Rings */
        p3=x*x*x;
        x1=(4*p3+y*y*y-2*x)/p1;
        y1=(p3*x+3*y*y-x*x)/p2;
        }; break;
 
case 9:{ /* Wings */
        if (x>0) p1=1; else p1=-1;
        x1=x-p1*sqrt(fabs(y-p3*x));
        y1=x*p2+y;
        }; break;
 
case 10:{ /* Ameba */
        x1=-p1*x+p1*y;
        y1=p2*x-y*y*x;
        }; break;
 
case 11:{ /* Mult. Param. 3 */
        x1= (p1+(x*x-p2)+x*(x-p4*y))+y*(y*y-p6);
        y1= (p7+(x*x-p8)+x*(x-p9*y))+y*(y*y-p10);
        }; break;
 
case 12:{ /* Ifs-Mandel */
        x1 = p1*x+p2*y+p3+(x*x-y*y+p7);
        y1 = p4*x+p5*y+p6+(2*x*y+p8);
        }; break;
 
case 13:{ /* Ifs */
        if (rnd()>0.5){
        x1=p1*x*0.5+p2*y*0.5+p5;
        y1=-p2*x*0.5+p1*y*0.5+p6;
        }
        else
        {
        x1=p3*x*0.5+p4*y*0.5+p7;
        y1=-p4*x*0.5+p3*y*0.5+p8;
        }
        }; break;
 
case 14:{ /* Iris */
        x1=sin(x)*p1+cos(y)*p2;
        y1=cos(x)*p1+sin(y)*p2;
        }; break;
 
case 15:{ /* Medusa */
        x1=p1*x+y-p2*x*x;
        y1=p3*y-x+p2*y*y;
        }; break;
 
case 16:{ /* Mult. Param. 4 */
        x1=p1*x+y*(p9+p2*x-y*p3+p4*y*y);
        y1=p5*x+y*(p10+p6*x-y*p7+p8*y*y);
        }; break;
 
case 17:{ /* Disk */
        x1=p1+p2*(x*cos(x*y)-y*sin(x*y));
        y1=p2*(x*sin(x*y)+y*cos(x*y));
        }; break;
 
case 18:{ /* Strips */
        x1=sin(y/x)*p1+cos(y)*p2;
        y1=cos(y/x)*p3+sin(x)*p4;
        }; break;
 
case 19:{ /* Real Mandelbrot */
        y1=x*x-p1;
        x1=y;
        }; break;
 
case 20:{ /* Ikeda/Ifs */
        if (rnd()>0.7){
        p4=p1-6/(1+x*x+y*y);
        x1=1+p2*(x*cos(p4)-y*sin(p4));
        y1=p2*(x*sin(p4)+y*cos(p4));
        }
        else
        {
        x1=p10*x+p9*y+p11;
        y1=-p9*x+p10*y+p12;
        }
        }; break;
 
case 21:{ /* Conditional Ifs */
        if (x>0){
        x=x-1;
        x1=p1*x-p2*y+p3;
        y1=p1*y+p2*x+p4;
        }
        else {
        x=x+1;
        x1=p1*x+p2*y-p3;
        y1=p1*y-p2*x-p4;
        }
        }; break;
 
case 22:{ /* Storm Julia */
        if (rnd()>rnd()){ x=x-p1; y=y-p2; }
        else
        { x=x-p4; y=y-p5; }
        p3=sqrt(x*x+y*y);
        x1=sqrt((x + p3)/2);
        y1=sqrt((-x + p3)/2);
        if (y<0) y1=-y1;
        if (rnd()>rnd()){
        x1=-x1;
        y1=-y1;
        }
        }; break;
 
case 23:{ /* Duffing Oscillator */
        p1++;
        if (p1>627) p1=0;
        p2=0.01*p1;
        x1 = x + y/6.283184;
        y1 = y + (-(x*x*x) + x-p3*y + p4*cos(p2))/6.283184;
        }; break;
 
case 24:{ /* Gingerbreadman */
        x1=p1-y+fabs(x);
        y1=x;
        }; break;
 
case 25:{ /* King's Dream */
        x1=sin(y*p2)+p3*sin(x*p2);
        y1=sin(x*p1)+p4*sin(y*p1);
        }; break;
 
case 26:{ /* Samardiza Oscillator */
        x1=x+(p1*x+p2*y-p7)*0.05;
        y1=y+(x+p5*y-x*x*x)*0.05;
        p7=p7+x*p6*0.01;
        }; break;
 
case 27:{ /* Ikeda */
        p4=p1-6/(1+x*x+y*y);
        x1=1+p2*(x*cos(p4)-y*sin(p4));
        y1=p2*(x*sin(p4)+y*cos(p4));
        }; break;
 
case 28:{ /* FrothyBasin Formula */
        x1=x*x-y*y-p1*x-p2*-y;
        y1=2*x*y-p1*-y+p2*x;
        }; break;
 
case 29:{ /* Cosine */
        x1 = cos(x+x*(p2*y+p3*x+p4)+p2*y*(x*x-p5)+p12)+p8*x;
        y1 = cos(y+x*(p6*y+p9*x+p10)+p1*y*(x*x+p11)+p7)+p13*y;
        }; break;
 
case 30:{ /* Frost Julia */
        p1=x-p11; p2=y-p12;
        if (p1>0) p3= atan(p2/p1);
        if (p1 < 0) p3=3.141592+atan(p2/p1);
        if (p1 == 0) p3=0.5*3.141592653;
        p3 = 0.5*p3;
        p4 = p1*p1 + p2*p2;
        p4 = sqrt(sqrt(sqrt(p4*p4*p4)));
        if (rnd()>rnd()) p4=-p4;
        x1 = p4*cos(p3);
        y1 = p4*sin(p3);
        }; break;
 
case 31:{ /* FrothyStars */
        p2=x;
        p3=y;
        for (i=1;i<=j;i++){
        p4=p2*x-p3*y;
        p3=p3*x+p2*y;
        p2=p4;
        }
        x1=p2-p5*x-p6*-y;
        y1=p3-p5*-y+p6*x;
        }; break;
 
case 32:{ /* Star */
        p4=sqrt(x*x);
        p5=sqrt(y*y);
        x1=p1*4*x+p2*4*x*(p4+p5)+p3*4*(x*p4-x*p5);
        y1=p1*4*y+p2*4*y*(p4+p5)+p3*4*(-p4*y+y*p5);
        }; break;
 
case 33:{ /* Spirals */
        if (k==0) {
        p10=1+rnd()*0.05; p3=sin(p5*6.28)*p10; p4=cos(p5*6.28)*p10; }
        p9=x*x-y;
        p1=x*p3+p9*p4;
        p2=x*p4-p9*p3;
        p7=sqrt(p1*p1+p2*p2);
        if (p7>2) { p1=-p1*0.005; p2=-p2*0.005; }
        x1=p1;
        y1=p2;
        }; break;
 
case 34:{ /* Ifs/Icon4 */
        if (rnd()>.75){
        p4=x*x;
        p5=y*y;
        x1=p1*4*x+p2*4*x*(p4+p5);
        y1=p1*4*y+p2*4*y*(p4+p5);
        }
        else {
        x1=p7*x+p8*y+p9;
        y1=-p8*x+p7*y+p10;
        }
        }; break;
 
case 35:{ /* Flakes in the Wind */
        if (rnd()>0.3) {
        if (rnd()>0.5){
        x1=0.5*p1*x+0.5*p2*y+p5;
        y1=-0.5*p2*x+0.5*p1*y+p6;
        }
        else
        {
        x1=0.5*p3*x+0.5*p4*y+p7;
        y1=-0.5*p4*x+0.5*p3*y+p8;
        }
        } else {
        p10=random(3);
        if (p10==0) { p11=-0.5*p11+0.25; p13=-0.5*p12+0.08+0.25; }
        if (p10==1) { p11=-0.5*p11-0.072+0.25; p13=-0.5*p12-0.048+0.25; }
        if (p10==2) { p11=-0.5*p11+0.072+0.25; p13=-0.5*p12-0.048+0.25; }
        p12=p13;
        x1=p11;
        y1=p12;
 
        }
        }; break;
 
case 36:{ /* Icons */
        p1=x*x+y*y;
        p2=x;
        p3=y;
        for (i=1;i<=j;i++){
        p4=p2*x-p3*y;
        p3=p3*x+p2*y;
        p2=p4;
        }
        p5=x*p2-y*p3;
        p6=p10*8+p7*8*p1+p8*8*p5;
        x1=p6*x+p9*8*p2;
        y1=p6*y-p9*8*p3;
        }; break;
 
case 37:{ /* Duffing II */
        x1=x+(p1*y)*0.1;
        y1=y+(p2*x+p3*x*x*x+p5*x*y*y+p6*y+p7*y*y*y+p8*sin(p11))*0.1;
        p11=p11+(p9+p10*x*y)*0.1;
        }; break;
 
case 38:{ /* Volterra */
        if (k==0) { x=1.01; y=0.99; p5=fabs(p7)/2; p6=fabs(p8)/2; }
        p3=x-x*y;
        p4=-y+x*y;
        p1=x+p6*p3;
        p2=y+p6*p4;
        x1=x+p5*(p3+(p1-p1*p2));
        y1=y+p5*(p4+(-p2+p1*p2));
        }; break;
 
case 39:{ /* Paintings */
        p1=fabs(y-p7*sin(x));
        p1=fabs((int)(p1)-p1);
        p2=fabs(x*p8);
        p2=fabs((int)(p2)-p2);
        p3=x+p9+p11*p1;
        x1=fabs((int)(p3)-p3);
        p4=y+p10+p12*p2;
        y1=fabs((int)(p4)-p4);
        }; break;
 
case 40:{ /* Cosine Waves */
        x1=y-p1*cos(x*3.1415);
        y1=x*p2;
        }; break;
 
}
 
        if (x1*x1+y1*y1>50) sw=1;
        if (k<10000){
          col=1;
          k++;
          xn1=fabs(fabs(x1)-fabs(xa));
          yn1=fabs(fabs(y1)-fabs(ya));
          if (rnd()>0.7){ xa=x1; ya=y1; }
 
          if ((yn1<0.00005) && (xn1<0.00005)) sw=1;
 
          if (k<=1000) { xm=x1; ym=y1; xc=x1; yc=y1; }
          if (k==995) { tx1=x1; ty1=y1; }
          if (k==997) { tx2=x1; ty2=y1; }
          if (k==999) { tx3=x1; ty3=y1; }
          if (k>1000 && k<=10000) { /*Routine for invariant circles*/
8               if (x1<xm) xm=x1;
                if (y1<ym) ym=y1;
                if (x1>xc) xc=x1;
                if (y1>yc) yc=y1;
                if (tx>0.00025) tx=sqrt(pow(x1-tx1,2)+pow(y1-ty1,2));
                if (ty>0.00025) ty=sqrt(pow(x1-tx2,2)+pow(y1-ty2,2));
                if (tz>0.00025) tz=sqrt(pow(x1-tx3,2)+pow(y1-ty3,2));
                if (tx<0.00025 && ty<0.00025 && tz<0.00025 ) sw=1;
                }
 
          if (k==10000) { /*Routines for calculating the corners*/
          ax=fabs(xc-xm);
          ay=fabs(yc-ym);
 
          if (ax<ay || fabs(ax-ay)<0.1){
          ax=ax*0.24;
          rad=ay;
          }
           else {
           rad=ax;
           ax=ax*0.075;
           }
 
          ay=ay*0.05;
          rwindow (xm-ax,ym-ay,xc+ax,yc+ay,&dx,&dy,&lx,&ly);
          cleardevice();
          setrgbpalette(1,cr[1],cg[1],cb[1]);
          setrgbpalette(2,cr[2],cg[2],cb[2]);
          setrgbpalette(3,cr[3],cg[3],cb[3]);
          setrgbpalette(4,cr[4],cg[4],cb[4]);
          setrgbpalette(255,cr[255],cg[255],cb[255]);
          l=0;
          }
          }
          /*Plotting rutines*/
 
          x2=(int)(x1*dx-lx);
          y2=(int)(y1*dy-ly);
          col=getpixel(x2,y2);
 
          /*Colour by Distance*/
          if (sw2==1) p=(int)((sqrt(pow(x1-x,2)+pow(y1-y,2))/rad)*255);
          x=x1;
          y=y1;
          /*Colour by Frecuency*/
          if (sw2==0) p=col+1;
          if (p>255) p=255;
          if (p<=0) p=1;
          if (col<p) putpixel (x2 ,y2 ,p);
          if (kbhit()) { sw=1; ch=getch(); }
          }
        while (sw!=1);
        sw=0;
        if (kbhit()) ch=getch();
        }
        while (ch!=27);
        closegraph();
        sw=0;
        gotoxy (1,3);
        printf ("Do you wish to continue (Y/N):\n\n");
        ch=getch();
        if (ch =='y' || ch=='Y') sw=1;
        }
        while (sw==1);
        clrscr();
}
 
double rnd(void) //* Random number generator by Mike Sargent. *//
{
   int random_integer, temp_integer;
   double random_double, temp_double;
 
   random_integer = random(RAND_MAX);
   random_double = (double)random_integer / RAND_MAX;
   temp_integer = random(30519);
   temp_double = (double)temp_integer / 1000000000L;
   random_double += temp_double;
   return(random_double);
}
 
 
 
 
 
 
 
 
