;
;
; Filename     : Main.asm
; Included from: Main Assembley Module
; Description  : Main demo of 3dvector library
;
; Written by: John McCarthy
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;         Fidonet:  Brian McCarthy 1:229/15
;   RIME/Relaynet: ->CRS
;
; Home phone, (905) 831-1944, don't call at 2 am eh!
;
; Send me your protected mode source code!
; Send me your Objects!
; But most of all, Send me a postcard!!!!
;
;

           .386p
           jumps

code32     segment para public use32
           assume cs:code32, ds:code32

;
; define externals
;

           include pmode.ext       ; protected mode externals
           include xmouse.ext      ; xmode mouse externals
           include xmode.ext       ; xmode externals by matt pritchard
           include 3d.ext
           include irq.ext
           include stars.ext
           include font.ext
           include file.ext
           include land.ext
           include argc.ext
           include moveit.ext
           include joystick.ext

           include macros.inc
           include equ.inc

           include sphere.inc
           include icon.inc
           include gamecolr.inc    ; dac palette

           include objects.inc     ; table of shapes/colours
           include stuff.inc       ; ending screen stuff
           include sequence.inc    ; the animation

           include stone0.inc
           include stone1.inc
           include stone2.inc
           include stone3.inc
           include stone4.inc
           include stone5.inc
           include stone6.inc
           include stone7.inc
           include stone8.inc
           include stone9.inc
           include stonea.inc
           include stoneb.inc
           include stonec.inc
           include stoned.inc
           include stonee.inc
           include stonef.inc

;
; stuff for 669 load (if you have a GUS) check TRAN's HELLSRC.ZIP for support files
;

           include_GUS equ no

           if include_GUS eq yes
           include \32\gsp669.ext
           include \32\gs.ext
           include \32\kb.ext
           endif

;
; code
;

           public _main
_main:

;
; get enviornment: current directory, current file
;

           sti
           call setup_env          ; set up file envirionment (eg c:\temp\thisprog.exe )

;
; check for and load 669 - link with argc,kb,gsp669,gs
;

           if include_GUS eq yes
           call _gs_find           ; check for and load a .669
           jc exiterr
           mov edx,_lomembase      ; this code belongs to TRAN
           xor al,al
           call _cchekstr
           jc exiterr
           mov edx,_lomembase
           call _openfile
           jc exiterr
           call _gsp669_init
           mov eax,offset _readfile
           mov edx,_lomembase
           call _gsp669_load
           call _closefile
           call _gsp669_play
exiterr:
           endif

;
; get timer IRQ running
;

           call set_pmirq          ; set irq running - must be done at start for palette fading

;
; do the spaceship animation
;

          ;mov esi,offset animation1
          ;mov edx,offset _standard_screen_draw
          ;call animate_this
          ;jmp getout

;
; explode DOS palette to common colour
;

           mov eax,00003f00h       ; what color to fade to
           mov bh,12               ; how much to fade each pel
           mov bl,255              ; how often should i fade the palette
           call _fade_all          ; fade it...
           call _wait_for_fade

;
; fade palette to black
;

           mov eax,00000000h       ; what color to fade to
           mov bh,1                ; how much to fade each pel
           mov bl,120              ; how often should i fade the palette
           call _fade_all          ; fade it...
           call _wait_for_fade

;
; set xmode
;

           pushw xmode
           pushw xactual
           pushw yactual
           pushw pages
           call set_vga_modex
           cmp ax,-1               ; test for error in setting videomode
           jne getout

;
; wipe palette after xmode call ('cause INT 10h resets the palette)
;

           mov eax,00000000h
           call wipeoffpalette

;
; set up pointers to object shape data
;

           call setupbase
           call _calibrate_joystick

;
; initialize xmode page flipping, font style, and get mouse ready
;

           call initpages
           mov esi,o font0
           mov edi,o font1
           mov ebp,o fontlength
           call initfont
           call show_mouse

;
; draw borders, title, and cosmetic screen stuff
;

           mov esi,o runscreen ; this uses the font.asm setup routines
           call tstring
           mov esi,o runtext
           call tstring

;
; use IRQ to fade palette on
;

           mov esi,o gamecolr
           mov bh,1
           mov bl,180
           call _fade_palette_read

;
; set clipping paramters (already done, but this shows how set new parameters)
;

           mov ax,xmin
           mov bx,ymin
           mov cx,xmax
           mov dx,ymax
           call set_clip_absolute

;
; set clipping parameters, (these are already set on startup so this isnt really needed)
;

           mov ax,xmin
           mov bx,ymin
           mov cx,xmax
           mov dx,ymax
           mov si,xcenter
           mov di,ycenter
           call set_clip_offset

;
; initialize the bitmaps: remember first two words are x and y size
;

           mov bitx   +4*0,15       ; base bitmap scaling
           mov bity   +4*0,15
           mov bitbase+4*0,o sphere
           mov bitx   +4*1,15       ; base bitmap scaling
           mov bity   +4*1,15
           mov bitbase+4*1,o icon

           mov stonetbl[0*4],o headerf   ; stone texture table
           mov stonetbl[1*4],o headere
           mov stonetbl[2*4],o headerd
           mov stonetbl[3*4],o headerc
           mov stonetbl[4*4],o headerb
           mov stonetbl[5*4],o headera
           mov stonetbl[6*4],o header9
           mov stonetbl[7*4],o header8
           mov stonetbl[8*4],o header7
           mov stonetbl[9*4],o header6
           mov stonetbl[10*4],o header5
           mov stonetbl[11*4],o header4
           mov stonetbl[12*4],o header3
           mov stonetbl[13*4],o header2
           mov stonetbl[14*4],o header1
           mov stonetbl[15*4],o header0

;
; plop some objects in space
;

;
; camera location/angle
;

           mov esi,cameraobject ; set the camera position
           mov bx,0             ; camera angle
           mov cx,0
           mov bp,0
           call set_angle
           mov ebx,100000       ; camera position
           mov ecx,25000
           mov ebp,-915000
           call put_object

;
; cube
;

           call search_next_available_object ; return si as next available object (1)
           call init_object
           mov ebx,-260000      ; to this position (x,y,z)=ebx,ecx,ebp
           mov ecx,650000       ; locations are 32 bit
           mov ebp,0
           call put_object      ; plop..
           mov bx,0             ; angles are 16 bit
           mov cx,0
           mov bp,0
           call set_angle       ; duhhh...i wonder what this call does...
           call set_object_on   ; turn object si on (make visible)
           call use_full_rotations ; full rotations for this object (0)
           mov userotate[esi],0 ; full rotations for this object (0)
           mov ax,0
           call set_shape       ; set object si to shape ax
           mov ebx,000545100h   ; x,y,z angular velocities
           mov ecx,000a91500h   ; high word = number of turns/revolutions
           mov ebp,000d42300h   ; lo word = final angle (position)
           mov di,58000         ; di = time to twist there (total frames)
           call twist_si        ; set angular velocity
           call set_finala      ; set final anglular position (pre-calculation)
           mov bl,0             ; set cross referencing palette (null)
           call set_xref_palette

           mov xreftable[4],offset gtab

;
; wireframe cube
;

           call search_next_available_object
           call init_object
           mov ebx,230000
           mov ecx,0
           mov ebp,190000
           call put_object
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           call use_full_rotations ; full rotations for this object (0)
           mov ax,1
           call set_shape
           mov ebx,000000000h
           mov ecx,000000000h
           mov ebp,000300000h
           mov di,65500
           call twist_si
           call set_finala
           mov bl,0
           call set_xref_palette

;
; ring
;

           call search_next_available_object
           call init_object
           mov ebx,80000
           mov ecx,170000
           mov ebp,80000
           call put_object
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           call use_full_rotations ; full rotations for this object (0)
           mov ax,2
           call set_shape
           mov ebx,000310124h
           mov ecx,0ffbc2340h
           mov ebp,000530100h
           mov di,16000
           call twist_si
           call set_finala
           mov bl,0
           call set_xref_palette

;
; diamond
;

           call search_next_available_object
           call init_object
           mov ebx,80000
           mov ecx,-200000
           mov ebp,-80000
           call put_object
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           call use_full_rotations ; full rotations for this object (0)
           mov ax,3
           call set_shape
           mov ebx,000600000h
           mov ecx,0fff23400h
           mov ebp,000100000h
           mov di,21000
           call twist_si
           call set_finala
           mov bl,0
           call set_xref_palette

;
; rubine (flat diamond)
;

           call search_next_available_object
           call init_object
           mov ebx,-190000
           mov ecx,130000
           mov ebp,-240000
           call put_object
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           call use_full_rotations ; full rotations for this object (0)
           mov ax,4
           call set_shape
           mov ebx,000200000h
           mov ecx,000100000h
           mov ebp,0ffa00000h
           mov di,12000
           call twist_si
           call set_finala
           mov bl,0
           call set_xref_palette

;
; vectorball cube thingy
;

           call search_next_available_object ; this next object is the bitmaped cube
           call init_object
           mov ebx,-150000      ; remove this and see the speed of
           mov ecx,-130000      ; only vectors
           mov ebp,120000
           call put_object      ; note: the bitmaps take a lot of cpu time
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           call use_full_rotations ; full rotations for this object (0)
           mov ax,5
           call set_shape
           mov ebx,000300000h
           mov ecx,000700000h
           mov ebp,000500000h
           mov di,13000
           call twist_si
           call set_finala

;
; stand alone bitmap
;

           call search_next_available_object ; stand alone bitmap - good for smoke or
           call init_object
           mov ebx,-5000        ; explosions
           mov ecx,5000
           mov ebp,25000
           call put_object      ; set location
           call set_object_on   ; turn it on
           mov ax,0             ; zeroth bitmap is shape
           call set_shape       ; will load from bitbase[0]
           call set_to_hibitmap ; it's a bitmap...
           mov bx,50            ; bitmap scaling (gets added to bitx and bity)
           mov cx,50            ; bitmap scaling bx=x scaling, cx=y scaling
           call set_bitmap_scaling

;
; this is the body of those wierd three blocks
;

           call search_next_available_object
           call init_object
           mov ebx,-190000
           mov ecx,-180000
           mov ebp,-140000
           call put_object
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           call use_full_rotations
           mov ax,6
           call set_shape
           mov ebx,000600000h
           mov ecx,0fff23400h
           mov ebp,000200000h
           mov di,16000
           call twist_si
           call set_finala
           mov bl,0
           call set_xref_palette

;
; this defines one "arm" of that wierd block - remember, it is "attached" to the body above
;

           inc esi
           call init_object
           mov ebx,0/256        ; this is not an actual object, it is only
           mov ecx,0/256        ; a reference to where the arm will get
           mov ebp,0/256        ; the angle data from.
           call put_object      ; put_object sets location of arm relative to body
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle       ; set initial angle of arm (relative to body)
           call set_object_off
           call set_sub_object_on
           call use_full_rotations ; full = rotation is relative to body , no = arm angle is not relative to body
          ;mov ax,xx            ; arm shape is already defined in block above
          ;call set_shape
           mov ebx,000200000h   ; set anglular velocity of arm (relative to body)
           mov ecx,000600000h
           mov ebp,000120000h
           mov di,22000
           call twist_si
           call set_finala       ; set final angle of arm (when it finally stops)
           mov bl,0              ; not an object, just angle and location data
           call set_xref_palette ; so we dont need this

;
; this defines the other "arm"
;

           inc esi
           call init_object
           mov ebx,0/256        ; the locations of sub_objects are /256 because of the way
           mov ecx,0/256        ; conversion between real space co-ordinates and object
           mov ebp,0/256        ; co-ordinates are calculated.  objects are 256 times larger than their appearance in real space
           call put_object      ; this is because there is greater accuracy in real space!!
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_off
           call set_sub_object_on
           call use_full_rotations ; full = rotation is relative to body , no = arm angle is not relative to body
          ;mov ax,xx
          ;call set_shape
           mov ebx,000220000h
           mov ecx,0ff700000h
           mov ebp,0ffe30000h
           mov di,18000
           call twist_si
           call set_finala
           mov bl,0
           call set_xref_palette

;
; make camera rotate along z axis if you want - make sure equ.inc has "use_z equ yes"
;

          ;mov eyezadds,50      ; make the camera rotate along it's z axis (just for fun)
          ;mov esi,cameraobject
          ;call set_finala

;
; reset IRQ counter before animation begins
;

           call reset_raster_count   ; done before any animation loop!!!

;
; intialize 3d pointers\indexers\sortvalues
;

           call init_tables          ; initialize 3d vector stuff

;
; example of how to point an object toward another object in a certin time
;

          ;mov esi,5                 ; an example of how to use point_time
          ;mov ebx,-10000            ; si = obj, bx,cx,bp = location, di = time
          ;mov ecx,-30000
          ;mov ebp,90000
          ;mov edi,150
          ;call point_time

;
; THE MAIN LOOP...
;

ieox:

;
; point an object toward the camera (just a cheap example)
;

          ;mov si,3                  ; try uncommenting this!, this will point
          ;mov di,cameraobject       ; the red ring at the camera.
          ;call point_it

;
; debugging tool: would you believe some idiot actually called me to tell me I
;                 needed more debugging tools - I told him he  needs  to  stop
;                 writing programs with bugs...
;

          ;mov eax,your_problem     ; debugging tool                                                    mov eax,your_problem      ; debugging tool!!!!
          ;mov number_eax,eax
           call put_at_top

;
; make sun move around
;

          ;add y_angle_of_sun,150    ; watch the red ring carefully! the sun will move around the room!

;
; make camera respond to joystick
;

           call _cartisian_joystick

           neg ebx         ; makes the joystick like an airplane...sorta...
           shr eax,6
           shr ebx,6
           imul eax,_old_traces_past
           imul ebx,_old_traces_past
           add eyeax,bx
           add eyeay,ax
           call fix_xangleq ; make it so user doesn wrap around upside down. (so stars wont mess up)

           call _justgetbutton
           test eax,2 ; test if second button pressed
           jz dobut2

           and eax,1
           xor eax,1
           imul eax,12000

           mov esi,cameraobject      ; move camera...esi - object
           mov ebp,eax               ; ebp = speed (make it faster!)
           mov edi,10                ; edi = total time (not in calculation)
           call set_speed            ; move object in direction it is pointing
           call set_finall           ; then calculate final position (not important as long as it keeps moving)
           jmp contxx
dobut2:
           and eax,2
           shr eax,1
           xor eax,1
           imul eax,-12000           ; if button 2 pressed, move camera backwards

           mov esi,cameraobject      ; move camera...esi - object
           mov ebp,eax               ; ebp = speed (make it faster!)
           mov edi,10                ; edi = total time (not in calculation)
           call set_speed            ; move object in direction it is pointing
           call set_finall           ; then calculate final position (not important as long as it keeps moving)
contxx:

;
; set camera rotation matrix - done once per frame so other routines know how to plot objects
;

           call setsincose           ; set rotation multipliers for eye
          ;call draw_landscape       ; draw background landscape
           call clear_fill           ; clear video memory before plot

;
; plot the stars in the background
;

           call show_stars           ; plot background stars

;
; plot all objects on screen
;

           call makeobjs             ; plot all objects in sides table

;
; plot mouse on screen - only a 1 page mouse so it flickers on two pages
;

          ;call instant_mouse        ; plot mouse on screen

;
; show how long it took to draw that last screen
;

          ;mov eax,traces_past       ; show number of traces past per re-draw
          ;mov number_eax,eax
          ;call put_at_top

;
; show user the new screen
;

           call flip_page            ; flip video pages

;
; update vector positions/angles
;

           call updvectors           ; move objects around, rotate them

;
; test escape key - if none, return to top of main loop
;

           in al,60h                 ; test keyboard
           cmp al,1
           jne ieox
ieox2:
           in al,60h                 ; test keyboard
           cmp al,1
           je ieox2
getout:

;
; make endpage screen
;

           mov eax,0
           mov bh,1
           mov bl,200
           call _fade_all
           call _wait_for_fade

           call mode03
           mov  eax,0
           call wipeoffpalette

           mov  edx,offset endtext
           call _putdosmsg

           mov esi,o _default_palette
           mov bh,2
           mov bl,255
           call _fade_palette_read
           call _wait_for_fade

           call reset_pmirq  ; reset irq vectors

           if include_GUS eq yes
           call _gsp669_uninit
           endif

           jmp _exit

;
; sample routines to show how to use some routines
;

comment %
           push offset gamecolr
           pushw 0
           pushw 255
           pushw 1
           call load_dac_registers
;

           mov esi,04       ; esi = object
           mov edi,55       ; edi = time to get there (# of frames)
           call newfollow
;

           mov ebx,x
           mov ecx,y
           mov ebp,z
           mov edi,time
           mov esi,cameraobject
           call move_si
           call set_finall
;

           block 0,0,319,399,14
           call flip_page
           block 0,0,319,399,14
;

           call flip_page    ; example of how to draw a single polygon

           p1x equ -50
           p1y equ -50
           p2x equ -90
           p2y equ 70
           p3x equ 60
           p3y equ 80

           mov x1,p1x
           mov y1,p1y
           mov x2,p2x
           mov y2,p2y
           call fakeline

           mov x1,p2x
           mov y1,p2y
           mov x2,p3x
           mov y2,p3y
           call fakeline

           mov x1,p3x
           mov y1,p3y
           mov x2,p1x
           mov y2,p1y
           call fakeline

           mov colq,7
           mov steel,-1
           call poly_fill

           call flip_page

;

           mov si,6                  ; move cube around...si - object
           mov ebp,45000             ; ebp = speed (make it faster!)
           mov di,600                ; di = total time (not in calculation)
           call set_speed            ; move object in direction it is pointing
           call set_finall           ; then calculate final position (not important as long as it keeps moving)
;
%

gtab       db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 011h,012h,013h,014h,015h,016h,017h,018h
           db 019h,01ah,01bh,01ch,01dh,01eh,01fh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
           db 010h,011h,012h,013h,014h,015h,016h,017h
           db 018h,019h,01ah,01bh,01ch,01dh,01eh,01fh

code32     ends
           end
