#include "ack3d.hpp"
#include "ackext.hpp"
#include <conio.h>
unsigned int PageTable[4] = {0,0,0,0},WritePage=0,ViewPage=0,
             ScreenWidth=320/4,PageSize=320/4*240;

void graphinit(void)
{ asm {
        push si
        push di
        push ds

        mov bx,320/4
        mov [ScreenWidth],bx
        mov bx,320/4*240
        mov [PageSize],bx

        xor ax,ax              // Set up the page table
        xor si,si
        mov word ptr [si+offset PageTable],ax
        add ax,bx
        add si,02
        mov word ptr [si+offset PageTable],ax
        add ax,bx
        add si,02
        mov word ptr [si+offset PageTable],ax
        add ax,bx
        add si,02
        mov word ptr [si+offset PageTable],ax
        cld

        mov ax,13h            // Now set up the graphics mode
        int 10h               // Set 320x200x256

        mov dx,3d4h
        mov al,13h
        out dx,al
        inc dx
        mov al,2dh      //Set bytes per line at 90
        out dx,al

        mov dx,3c4h
        mov al,4
        out dx,al
        inc dx
        in  al,dx
        and al,0f7h     //Turn off chain4 mode
        out dx,al
        dec     dx
        mov al,17h
        out dx,al
        inc dx
        in  al,dx
        or  al,40h      //Turn on byte mode
        out dx,al
        dec     dx              //mov     dx,3d4h
        mov al,14h
        out dx,al
        inc dx
        in  al,dx
        and al,0bfh     //Turn off double-word mode
        out dx,al

        mov dx,3dah
        in  al,dx
        mov dx,3c0h
        mov al,30h      //Select Attribute index 10h
        out dx,al
        mov al,71h      //Turn on PCS, PPC and G/A
        out dx,al

        mov ax,0a000h   //now clear all display memory, 8 pixels
        mov es,ax       //at a time
        sub di,di       //point ES:DI to display memory
        sub ax,ax       //clear to zero-value pixels
        mov cx,8000h    //# of words in display memory
        rep stosw       //clear all of display memory

        pop ds
        pop di          //restore C register vars
        pop si
} }




void SetVGAmode(void)
{
asm {   mov	ax,13h
	int	10h		// Set 320x200x256
} }


void SetPalette(unsigned char *PalBuf)
{ int i;
  for(i=0;i<256;i++)
  { outp(0x3c8,i);
    outp(0x3c9,*(PalBuf++)); outp(0x3c9,*(PalBuf++)); outp(0x3c9,*(PalBuf++));
} }

void pageflip(void)
{
  asm {
        mov  ax,[ViewPage]  //changing buffer to write to
        xchg ax,[WritePage]
        mov  [ViewPage],ax
        mov  dx,3d4h
        mov  al,0ch
        out  dx,ax   //doing the actual hardware page flipping
} }

void pageinit(void)
{ ViewPage =PageTable[0];
  WritePage=PageTable[1];
}

void DrawWalls(void)
{
  asm {
#define Y2       [bp-2]
#define AVLOW    [bp-4]
#define AVHI     [bp-6]
#define VCOL     [bp-8]
#define BOFFLOW  [bp-10]
#define BOFFHI   [bp-12]

push    bp
mov     bp,sp
sub     sp,18
push    ds
push    si
push    di
mov     dx,3c4H
mov     ax,0F02H
out     dx,ax           //Select map mask and all planes
mov     bx,MaxDistance // Get max distance to wall
shl     bx,1            // Make a word index
mov     ax,DistanceTable[bx] //Look up actual height
cmp     ax,200          // Full screen height?
jae     drw000          // Yes, nothing to fill in
and     ax,0FFFEH       // Strip any odd values
mov     bx,ax           // Save height
mov     si,ax           // Again save height
shr     bx,1            // Get Height / 2
mov     dx,100          // Pick up our center row
sub     dx,bx           // and sub ht/2
mov     bx,dx           // Save new value
mov     ax,90
imul    dx
mov     bx,ax
mov     ax,90
imul    si
mov     si,ax
//   mov cl,6            // Get ready to mult by 80
//   shl bx,cl           // first mult by 64
//   shl si,cl           // also mult the original ht
//   mov cl,4            // No do a mult by 16
//   shl dx,cl           // to top layer
//   shl ax,cl           // and initial height
//   add bx,dx           // Add x64 and x16 for x80
//   add si,ax           // do same with height
mov     ax,0A000H
mov     es,ax
mov     di,WritePage        //get start of buffer
mov     ax,TopColor
mov     ah,al
shr     bx,1            //only fill words
mov     cx,bx           //get amount to fill in
cld
rep     stosw
add     di,si           //then skip amount of wall
mov     ax,BottomColor
mov     ah,al
mov     cx,bx
rep     stosw
}
drw000:
asm  xor bx,bx           //Initial loop/plane counter
drw010:
asm {
push    bx          //save loop/plane counter
mov     VCOL,bx         //Set beginning video column
mov     dx,3c5H
mov     al,lowmask[bx]
out     dx,al           //select mask to write to
mov     si,offset Walls    // Point to wall array
shl     bx,1
shl     bx,1
shl     bx,1            //x 8 for correct wall structure
add     si,bx
mov     cx,80           //Number of walls to display
}
drw020:
asm {
push    ds          //save data segment
push    si          //save wall pointer
push    cx          //save wall count
lodsw               //Get bitmap number
xchg    ax,bx           //use bx as the index
shl     bx,1
shl     bx,1            //dword index into bitmap table
mov     di,bMaps[bx]       //offset to bitmap
mov     es,bMaps[bx+2]     //segment of bitmap
lodsw               //get bitmap column to display
mov     cl,6
shl     ax,cl           //x64 to get correct row
add     di,ax           //and add to bitmap offset
lodsw               //get bitmap distance
shl     ax,1            // Make word index for table lookup
mov     si,ax           //save distance
mov     bx,DistanceTable[si]  //get height of bitmap
mov     cx,100
mov     ax,bx           // Pick up the height
shr     ax,1            // Divide by two
sub     cx,ax           // And subtract from center for Y1
mov     ax,cx           // Start with Y1
add     ax,bx           // and add height to it for Y2
cmp     ax,199          // Don't let Y2 go beyond screen height
jle     short drw030
mov     ax,199          // Else force it to screen height
}
drw030:
asm {
mov     Y2,ax           //save y2
shl     si,1            // Turn object distance into dword index
mov     ax,AdjustTable[si+2]
mov     dx,AdjustTable[si]
mov     AVHI,ax         // Get (64 * 65536) / height
mov     AVLOW,dx
xchg    si,di           //si now points to bitmap
mov     di,VCOL         // Video column to display at
sar     di,1            // Divide by 4 to get correct planar col
sar     di,1            // Divide by 4 to get correct planar col
add     di,WritePage           // Add in page offset
mov     ax,es           // Pick up segment to bitmap
//!!!!!!
mov     ds,ax                   // now ds:si points to bitmap
mov     ax,0A000H       // Video segment
mov     es,ax           // now es:di points to screen
mov     word ptr BOFFLOW,0  // Initialize the current bitmap offset
mov     word ptr BOFFHI,0
cmp     cx,word ptr Y2      // is Y1 > Y2?
jge     short drw090        // Yes, get on out
or      cx,cx           // Y1 <= 0?
jle     drw050          // Yes, no sky color needed
//   mov   ax,cx           // Get copy of Y1
//   mov   bx,cx           // and another copy
//   mov   cl,6
//   shl   ax,cl           // do a mult 64
//   add   di,ax           // and add to video offset
//   mov   cl,4
//   mov   ax,bx           // get original Y1
//   shl   ax,cl           // do a mult 16
//   add   di,ax           // and add to video for a mult 80
//   xchg  cx,bx           // restore original Y1
mov     ax,90
imul    cx
add     di,ax
}
drw050:
asm {
mov     bx,89           // Offset to next video row
mov     dx,AVLOW        // Hold onto lsb of adjustment
mov     ax,AVHI         // Pick up msb of bitmap adjustment

//------------------------------------------------------------------------------
// Here is where the actual bitmap is transferred to the screen. Better
// optimization could be done by precalculating the adjustment factor instead
// of looping until Y1 >= 0. This has not been tried so I don't know if the
// speed would make it worth it....
//------------------------------------------------------------------------------
  }
drw060:
asm {
or      cx,cx           // Is Y1 still < 0 ?
jl      short drw070        // Yes, don't start drawing yet
movsb               //Move bitmap to video
dec     si
add     di,bx           //next row of video
}
drw070:
asm {
add     word ptr BOFFLOW,dx // Add lsb to current offset
adc     si,ax           // Use msb to get next bitmap location
inc     cx          // Next y1
cmp     cx,word ptr Y2      // Beyond Y2 yet?
jl      short drw060        // Nope, keep looping
}
drw090:
asm {
pop     cx          //get wall count
pop     si          //recover structure pointer
pop     ds
add     si,32           //Wall structure size * 4
add     word ptr VCOL,4     //next video column to display at
dec     cx
jz      drw100
jmp     drw020          //next wall to display
}
drw100:
asm {
pop     bx          //recover loop/plane counter
inc     bx
cmp     bx,4            //all 4 planes?
je      drwDone
jmp     drw010
}
drwDone:
asm {
mov     dx,3c5H
mov     al,0FFH         //Enable all planes again
out     dx,al
pop     di
pop     si
pop     ds
mov     sp,bp
pop     bp
} }



/*
 * Preparing dynamic buffering (only used bitmaps in memory)
 * Reading from disk if new bitmap encountered...
 */
void get_bitmap(...)
{ asm {
    mov bx,[bp+4]
    mov ax,oMaps[bx+2]
    mov [bp+4+2],ax
    mov ax,oMaps[bx]
    mov [bp+4+4],ax
} }


void DrawOneObject(int aObjNum,int aObjCol,int aObjDist,int aVidCol)
{
  asm {
#define TRANSPARENT 0
#define ObjNum    [bp+4+6]
#define ObjCol    [bp+6+6]
#define ObjDist   [bp+8+6]
#define VidCol    [bp+10+6]
//TC++ pushes 6 bytes on top of stack before passing controll to my code
#define OLD_Y2   word ptr [bp-2]
#define BM_LOW    word ptr [bp-6]
#define BM_HI   word ptr [bp-8]
#define ADJLOW   word ptr [bp-14]
#define ADJHI    word ptr [bp-16]
#define BOFF_LOW word ptr [bp-18]
#define BOFF_HI  word ptr [bp-20]

push    bp
mov     bp,sp
sub     sp,20
push    si
push    di
push    ds
mov     cx,VidCol       // Video column
and     cx,3                    // Only need lower three bits
mov     ah,11h
rol     ah,cl
mov     al,2
mov     dx,3c4h
out     dx,ax
mov     bx,ObjDist      // Get the distance to the bitmap
shl     bx,1                    // Make word index for table lookup
mov     si,bx                   // Save index for now
mov     bx,DistanceTable[bx]
}
dob010:
asm {
mov     cx,100
mov     ax,bx               // Pick up the height
shr     ax,1                // Divide by two
sub     cx,ax               // And subtract from center for Y1
mov     di,cx               // Start with Y1
add     di,bx               // and add height to it for Y2
cmp     di,199              // Don't let Y2 go beyond screen height
jle     short dob020
mov     di,199              // Else force it to screen height
}
dob020:
asm {
mov     OLD_Y2,di       //save y2
shl     si,1                // Turn object distance into dword index
mov     ax,AdjustTable[si+2]
mov     dx,AdjustTable[si]
mov     ADJLOW,ax       // Get (64 * 65536) / height
mov     ADJHI,dx
mov     bx,ObjNum       // Bitmap number to display
shl     bx,1                    // dword index
shl     bx,1                    // dword index
push    dx
push    ax
push    bx
}
get_bitmap();
asm {
//mov   ax,oMaps[bx+2]
//mov   dx,oMaps[bx]
pop     ax
pop     ax
pop     dx
mov     bx,ObjCol       // Bitmap column to display
shl     bx,1
shl     bx,1
shl     bx,1
shl     bx,1
shl     bx,1
shl     bx,1                    // x 64 to get correct bitmap row
add     dx,bx                   // then add to start of bitmap
mov     BM_LOW,ax       //used indirectly by 'lds' instruction
mov     BM_HI,dx
mov     di,VidCol       // Video column to display at
sar     di,1            // Divide by 4 to get correct planar col
sar     di,1            // Divide by 4 to get correct planar col
add     di,WritePage    //Pick up actual offset
mov     ax,0A000H       // Video segment
mov     es,ax
mov     BOFF_LOW,0          // Initialize the current bitmap offset
mov     BOFF_HI,0
or      cx,cx               // Is Y1 > 0 ?
jle     short dob030    // Nope, start above video
//      xchg    si,cx              // hold onto original value
//	mov	ax,si			// get Y1 coordinate
//	mov	cl,6			// mult by 64
//	shl	ax,cl
//	mov	dx,si			// get back Y1
//	mov	cl,4
//	shl	dx,cl			// mult by 16
//	add	ax,dx			// now add to Y1 * 64 to get Y1 * 80
//	add	di,ax			// and add to start of video
//	xchg	cx,si			// get back original Y1
mov     ax,90
imul    cx
add     di,ax
}
dob030:
asm {
cmp     cx,OLD_Y2           // is Y1 > Y2?
jge     short dob090            // Yes, get on out
mov     bx,90               //Amount to next row of video
lds     si,dword ptr BM_HI  //Get image buffer
mov     dx,ADJHI            // Hold onto lsb of adjustment
}
dob040:
asm {
or      cx,cx                   // Is Y1 still < 0 ?
jl      short dob080            // Yes, don't start drawing yet
lodsb
dec     si
cmp     al,TRANSPARENT          //Transparent color?
jz      dob050                  //Yes, don't write it to video
mov     byte ptr es:[di],al     //place character in video
}
dob050:
asm     add di,bx           //next row of video
dob080:
asm {
mov     ax,ADJLOW           // Pick up msb of bitmap adjustment
add     BOFF_HI,dx          //   and add to current offset
adc     si,ax               // Keep the msb correct
inc     cx                  // Next y1
cmp     cx,OLD_Y2           // Beyond Y2 yet?
jl      short dob040        // Nope, keep looping
}
dob090:
asm {
pop     ds
pop     di
pop     si
mov     sp,bp
pop     bp
  }
}



