/* EXAMPLE6 -- using the configuration file to simplify setup */

/* Written by Bernie Roehl, August 1994 */

#include "avril.h"

static void object_manipulator(void)
	{
	extern vrl_Object *active_object;  /* defined in input.c */
	vrl_Device *dev = vrl_TaskGetData();
	vrl_Object *viewer = vrl_CameraGetObject(vrl_WorldGetCamera());
	vrl_Vector v;
	if (dev->buttons)
		{
		vrl_ObjectRotReset(active_object);
		vrl_ObjectVectorMove(active_object, vrl_VectorNULL);
		}
	vrl_ObjectRotate(active_object, vrl_DeviceGetValue(dev, YROT), Y, VRL_COORD_OBJREL, viewer);
	vrl_ObjectRotate(active_object, vrl_DeviceGetValue(dev, XROT), X, VRL_COORD_OBJREL, viewer);
	vrl_ObjectRotate(active_object, vrl_DeviceGetValue(dev, ZROT), Z, VRL_COORD_OBJREL, viewer);
	vrl_VectorCreate(v, vrl_DeviceGetValue(dev, X), vrl_DeviceGetValue(dev, Y), vrl_DeviceGetValue(dev, Z));
	vrl_ObjectTranslate(active_object, v, VRL_COORD_OBJREL, viewer);
	vrl_SystemRequestRefresh();
	}

void main(int argc, char *argv[])
	{
	vrl_Device *dev;
	vrl_ConfigStartup("example6.cfg");
	vrl_SystemCommandLine(argc, argv);
	dev = vrl_ConfigFindDevice("manipulator");
	if (dev)
		vrl_TaskCreate(object_manipulator, dev, 0);
	vrl_SystemRun();
	}
