#define _MAIN_

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include <mem.h>
#include "vidlib.h"
#include "vesa.h"

char teststring1[]= "0123456789abcdefghijklmnopqrstuvwxyz";
char teststring2[]= "ŴABCDEFGHIJKLMNOPQRSTUVWXYZ";

char temps[100];
char newpalette[768];
char * capture;

void pause(void);
void palette_check(void);
void Make_newpalette(void);
void Test_textmode(void);
void Test_modex10(void);
void Test_modex12(void);
void Test_modex13(void);
void Test_vesax100(void);
void Test_palettes(void);

void main(int argc, char *argv[])
{
  int choice=-1;

  printf("VIDLIB v%s Testvl (Test video lib).\n",
                  VIDLIB_VERSION);
  if ( ! isVGA() ) {
      printf("\nSorry, you need to have a VGA video board to run this.\n");
      exit(1);
  }
  if ( (capture=(char *)malloc(6400)) == NULL) {
      printf("Malloc failed.\n");
      exit(1);
  }

  if (argc > 1) {
      if ( argv[1][0]== '-' ) {
         Start_vgadebug("testvl.dbg");
         sprintf(tdbg,"capture=%Fp\n", capture);
         fputs(tdbg,vgadebug);
      }
  }

  Vinit();
  /* start */
  while ( choice != 0 ) {
    Textmode(25);
    printf("VIDLIB v%s Testvl (Test video lib).\n",
                  VIDLIB_VERSION);
    printf("\n\n     Enter your choice of tests:\n\n");
    printf(    "     0 - Exit\n");
    printf(    "     1 - Text modes (25, 28, 33, 40, and 50 line modes)\n");
    printf(    "     2 - EGA mode 0x10 (640x350 16 colors)\n");
    printf(    "     3 - VGA mode 0x12 (640x480 16 colors)\n");
    printf(    "     4 - VGA mode 0x13 (320x200 256 colors)\n");
    printf(    "     5 - VESA mode 0x100 (640x400 256 colors)\n");
    printf(    "     6 - Mode 0x13 palettes\n");
    choice=getch()-'0';
    switch (choice) {
      case 0 : break;
      case 1 : Test_textmode();
               break;
      case 2 : Test_modex10();
               break;
      case 3 : Test_modex12();
               break;
      case 4 : Test_modex13();
               break;
      case 5 : Test_vesax100();
               break;
      case 6 : Test_palettes();
               break;
    }
  }

  /**************************************/
  /* Exit                               */
  /**************************************/
  Vclose();
  if (vgadebug) Close_vgadebug();
  exit(0);
}
/****************************** E n d  M a i n ******************************/

/**************************************/
/* 640x350  functions                 */
/**************************************/
void Test_modex10(void)
{
   int rc, i, t;

   rc=VGAmode(0x10, NULL);
   sprintf(temps,"VGAmode 0x10: 25 lines (hit any key to continue)"
                 "\r\n", rc);
   _foreground_color=0x21;
   Vputs(temps);
   _foreground_color=0x22;
   for (i=2; i<16; i++) {
       sprintf(temps,"%2u %s%s\r\n", i, teststring1, teststring2);
       Vputs(temps);
   }
   pause();
   _foreground_color=0x23;
   Vputs(
     "Testing Vdisable_refresh (will blank the screen until you hit a key)");
   pause();
   Vdisable_refresh();
   pause();
   Venable_refresh();
   _foreground_color=0x24;
   Vputs("\r\n...tested Venable_refresh\r\n");
   pause();
   _foreground_color=0x25;
   Vputs("Doing Vcopy16(0, 350, 0, 0, 40, 175).(off-screen)\r\n");
   pause();
   rc=Vcopy16(0, 350, 0, 0, 40, 175);
   pause();
   sprintf(temps,"Vcopy16(...)=%u\r\n", rc);
   _foreground_color=0x26;
   Vputs(temps);
   pause();
   _foreground_color=0x27;
   Vputs("Doing Vcopy16(30, 171, 0, 350, 40, 175).\r\n");
   pause();
   rc=Vcopy16(30, 171, 0, 350, 40, 175);
   pause();
   sprintf(temps,"Vcopy16(...)=%u\r\n", rc);
   _foreground_color=0x28;
   Vputs(temps);
   pause();
   _foreground_color=0x29;
   Vputs("Doing Vcapt16(&capture, 20, 80, 0, 0, 11, 3, 20, 80).\r\n");
   pause();
   rc=Vcapt16(capture, 20, 80, 0, 0, 11, 3, 20, 80);
   pause();
   sprintf(temps,"Vcapt16(...)=%u\r\n", rc);
   _foreground_color=0x2a;
   Vputs(temps);
   pause();
   _foreground_color=0x2b;
   Vputs("Doing Vdisp16(10, 76, &capture, 20, 80, 0, 0, 20, 80).\r\n");
   pause();
   rc=Vdisp16(15, 26, capture, 20, 80, 0, 0, 20, 80);
   pause();
   sprintf(temps,"Vdisp16(...)=%u\r\n", rc);
   _foreground_color=0x2c;
   Vputs(temps);
   pause();
}

/**************************************/
/* 640x480  functions                 */
/**************************************/
void Test_modex12(void)
{
   int rc, i, t;

   rc=VGAmode(0x12,NULL);
   sprintf(temps,"VGAmode 0x12: 30 lines (hit any key to continue)"
                 "\r\n", rc);
   _foreground_color=0x32;
   Vputs(temps);
   _foreground_color=0x33;
   for (i=2; i<22; i++) {
       sprintf(temps,"%2u %s%s\r\n", i, teststring1, teststring2);
       Vputs(temps);
   }
   pause();
   _foreground_color=0x34;
   Vputs("Doing Vcopy16(0, 480, 0, 0, 40, 240).(off-screen)\r\n");
   pause();
   rc=Vcopy16(0, 480, 0, 0, 40, 240);
   pause();
   sprintf(temps,"Vcopy16(...)=%u\r\n", rc);
   _foreground_color=0x35;
   Vputs(temps);
   pause();
   _foreground_color=0x37;
   Vputs("Doing Vcopy16(30, 201, 0, 480, 40, 240).\r\n");
   pause();
   rc=Vcopy16(30, 201, 0, 480, 40, 240);
   pause();
   sprintf(temps,"Vcopy16(...)=%u\r\n", rc);
   _foreground_color=0x38;
   Vputs(temps);
   pause();

   _foreground_color=0x39;
   Vputs("Doing Vcapt16(&capture, 20, 80, 0, 0, 0, 0, 20, 80).\r\n");
   pause();
   rc=Vcapt16(capture, 20, 80, 0, 0, 0, 0, 20, 80);
   pause();
   sprintf(temps,"Vcapt16(...)=%u\r\n", rc);
   _foreground_color=0x3a;
   Vputs(temps);
   pause();
   _foreground_color=0x3b;
   Vputs("Doing Vdisp16(10, 76, &capture, 20, 80, 0, 0, 20, 80).\r\n");
   pause();
   rc=Vdisp16(15, 26, capture, 20, 80, 0, 0, 20, 80);
   pause();
   sprintf(temps,"Vdisp16(...)=%u\r\n", rc);
   _foreground_color=0x3c;
   Vputs(temps);
   pause();
}

/**************************************/
/* 320x200  functions                 */
/**************************************/
void Test_modex13(void)
{
   int rc, i, t;

  rc=VGAmode(0x13,NULL);
  sprintf(temps,"VGAmode 0x13: 40 x 25 lines"
                "  (hit any key to continue)\r\n", rc);
  _foreground_color=0x44;
  Vputs(temps);
  _foreground_color++;
  for (i=3; i<19; i++) {
       sprintf(temps,"%2u %s\r\n", i, teststring1+1);
       Vputs(temps); _foreground_color++;
  }
  pause();
  _foreground_color=0x13;
  Vputs("Doing Vcopy256(...).\r\n");
  pause();
  rc=Vcopy256(160, 100, 0, 0, 160, 100);
  pause();
  sprintf(temps,"Vcopy256(...)=%u\r\n", rc);
  _foreground_color++;
  Vputs(temps);
  pause();

  _foreground_color++;
  Vputs("Doing Vcapt256(...).\r\n");
  pause();
  rc=Vcapt256(capture, 80, 80, 0, 0, 0, 0, 80, 80);
  pause();
  sprintf(temps,"Vcapt256(...)=%u\r\n", rc);
  _foreground_color++;
  Vputs(temps);
  pause();

  _foreground_color++;
  Vputs("Doing Vdisp256(...).\r\n");
  pause();
  rc=Vdisp256(44, 44, capture, 80, 80, 0, 0, 80, 80);
  pause();
  sprintf(temps,"Vdisp256(...)=%u\r\n", rc);
  _foreground_color++;
  Vputs(temps);
  pause();
}

void Test_palettes(void)
{
  printf("\n\n");
  printf("DEFAULTDAC : the dac register contents when Vinit() was run.\n");
  printf("NULL       : the dac register contents after the last mode change.\n");
  printf("newpalette : an example palette created by this program.\n");
  printf("\n(Hit a key)\n");
  pause();
  printf("Doing palette_check() with 'DEFAULTDAC'\n");
  pause();
  VGAmode(0x13,DEFAULTDAC);
  palette_check();
  pause();
  Vputs("Doing palette_check() with 'NULL'\r\n");
  pause();
  VGAmode(0x13,NULL);
  palette_check();
  pause();
  Make_newpalette();
  Vputs("Doing palette_check() with 'newpalette'\r\n");
  pause();
  VGAmode(0x13,newpalette);
  palette_check();
  pause();
}

void pause(void)
{
   int t;
   t=getch();
   if ( t == 27 ) {
      if (vgadebug) Close_vgadebug();
      Vclose();
      exit(0);
   }
}

void palette_check(void)
{
   int i,j,c;
   Vfill256(0,0,320,200,0); /* clear screen */
   for (i=c=0; i<16; i++) {
       for (j=0; j<16; j++) {
           Vfill256(j*20,i*11+13,19,10,c);
           c++;
       }
   }
}

void Make_newpalette(void)
{
   int i;
   char *np;

   np=newpalette;
   memcpy(np,_olddacs,96); /* 32 entries */
   for (i=32; i<64; i++) {
      *(np+i*3)=i*2;
      *(np+i*3+1)=i*2;
      *(np+i*3+2)=i*2;
   }
   for (i=64; i<96; i++) {
      *(np+i*3)=i*2;
      *(np+i*3+1)=0;
      *(np+i*3+2)=0;
   }
   for (i=96; i<128; i++) {
      *(np+i*3)=0;
      *(np+i*3+1)=i*2;
      *(np+i*3+2)=0;
   }
   for (i=128; i<160; i++) {
      *(np+i*3)=0;
      *(np+i*3+1)=0;
      *(np+i*3+2)=i*2;
   }
   for (i=160; i<192; i++) {
      *(np+i*3)=i*2;
      *(np+i*3+1)=i*2;
      *(np+i*3+2)=0;
   }
   for (i=192; i<224; i++) {
      *(np+i*3)=i*2;
      *(np+i*3+1)=0;
      *(np+i*3+2)=i*2;
   }
   for (i=224; i<256; i++) {
      *(np+i*3)=0;
      *(np+i*3+1)=i*2;
      *(np+i*3+2)=i*2;
   }
}

/**************************************/
/* Textmode functions                 */
/**************************************/
void Test_textmode(void)
{
   int rc,i;
   rc=Textmode(25);
   printf("Textmode(25)=%u. (80x25)\n", rc);
   for (i=2; i<25; i++) {
       if (kbhit()) break;
       printf("%2u %s%s\r\n", i, teststring1, teststring2);
   }
   pause();

   printf("Doing Textmode(28).");
   pause();
   rc=Textmode(28);
   printf("  Textmode(28)=%u.\n",rc);
   for (i=2; i<28; i++) {
       if (kbhit()) break;
       printf("%2u %s%s\r\n", i, teststring1, teststring2);
   }
   pause();

   printf("Doing Textmode(33).");
   pause();
   rc=Textmode(33);
   printf("  Textmode(33)=%u.\n",rc);
   for (i=2; i<33; i++) {
       if (kbhit()) break;
       printf("%2u %s%s\r\n", i, teststring1, teststring2);
   }
   pause();

   printf("Doing Textmode(40).");
   pause();
   rc=Textmode(40);
   printf("  Textmode(40)=%u.\n",rc);
   for (i=2; i<40; i++) {
       if (kbhit()) break;
       printf("%2u %s%s\r\n", i, teststring1, teststring2);
   }
   pause();

   printf("Doing Textmode(50).");
   pause();
   rc=Textmode(50);
   printf("  Textmode(50)=%u.\n",rc);
   for (i=2; i<50; i++) {
       if (kbhit()) break;
       printf("%2u %s%s\r\n", i, teststring1, teststring2);
   }
   pause();
}

/*****************************************************/
/*   VESA modes                                      */
/*****************************************************/
void Test_vesax100(void)
{
   int rc, i, t;

   rc=isVESA();
   if ( rc == 0 ) {
       printf("\nSorry, VESA BIOS not found.\n");
       pause();
       return;
   }
   printf("Doing VESAmode(0x100,NULL).\n");
   pause();
   rc=VESAmode(0x100,NULL);
   Vborder_color(0);
   sprintf(temps,"VESAmode(0x100,NULL)=%u. (640x400 in 256 colors)\r\n",rc);
   _foreground_color=0x41; Vputs(temps);
   t=Vnext_break;
   sprintf(temps,"Page 0: next page break= scan line %u\r\n",t);
   _foreground_color=0x42; Vputs(temps);
   VESAsetpage(1);
   t=Vnext_break;
   sprintf(temps,"Page 1: next page break= scan line %u\r\n",t);
   _foreground_color=0x43; Vputs(temps);
   VESAsetpage(2);
   t=Vnext_break;
   sprintf(temps,"Page 2: next page break= scan line %u\r\n",t);
   _foreground_color=0x43; Vputs(temps);
   VESAsetpage(3);
   t=Vnext_break;
   sprintf(temps,"Page 3: next page break= scan line %u\r\n",t);
   _foreground_color=0x44; Vputs(temps);
   _foreground_color=0x50;
   for (i=6; i<22; i++) {
       sprintf(temps,"%2u %s%s\r\n", i, teststring1, teststring2);
       Vputs(temps); _foreground_color++;
   }
   pause();
   _foreground_color=0x60; Vputs("Doing VESAcopy256(...)\r\n");
   pause();
   rc=VESAcopy256(350, 150, 10, 50, 240, 200);
   pause();
   sprintf(temps,"VESAcopy256(...)=%u\r\n",rc);
   _foreground_color=0x61; Vputs(temps);
   pause();
   _foreground_color=0x62;
   Vputs("Note that the putstty BIOS function doesn't support scrolling"
         " in VESA modes.\r");
   pause();
   VESAcopy256(0, 0, 0, 16, 640, 384);
   VESAfill256(0, 384, 640, 16, 255);
   _foreground_color=0x63; Vputs("But we can fake it.\r");
   pause();
   VESAcopy256(0, 0, 0, 16, 640, 384);
   VESAfill256(0, 384, 640, 16, 255);
   _foreground_color=0x64; Vputs(" (if a bit slowly)\r");
   pause();
   VESAcopy256(0, 0, 0, 16, 640, 384);
   VESAfill256(0, 384, 640, 16, 255);
   pause();
}

