/*****************************************************************************
*   "Gif-Lib" - Yet another gif library.				     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 0.1,	Jul. 1989    *
******************************************************************************
* Program to create a test image of White and Red/Green/Blue levels for      *
* test purposes. The Primary (RGB) and Secondary (YCM) are also displayed.   *
* background.								     *
* Options:								     *
* -s Width Height : set image size.					     *
* -l levels : number of color levels.					     *
* -h : on line help.							     *
******************************************************************************
* History:								     *
* 4 Jan 90 - Version 1.0 by Gershon Elber.				     *
*****************************************************************************/

#ifdef __MSDOS__
#include <stdlib.h>
#include <alloc.h>
#endif /* __MSDOS__ */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "gif_lib.h"
#include "getarg.h"

#define PROGRAM_NAME	"GifWedge"
#define VERSION		" Version 1.0, "

#define DEFAULT_WIDTH	640
#define DEFAULT_HEIGHT	350

#define DEFAULT_NUM_LEVELS	16	/* Number of colors to gen the image */

#ifdef __MSDOS__
extern unsigned int
    _stklen = 16384;			      /* Increase default stack size */
#endif /* __MSDOS__ */

#ifdef SYSV
static char *VersionStr =
        "Gif library module,\t\tGershon Elber\n\
	(C) Copyright 1989 Gershon Elber, Non commercial use only.\n";
static char
    *CtrlStr = "GifWedge l%-#Lvls!d s%-Width|Height!d!d h%-";
#else
static char
    *VersionStr =
	PROGRAM_NAME
	"	IBMPC "
	VERSION
	"	Gershon Elber,	"
	__DATE__ ",   " __TIME__ "\n"
	"(C) Copyright 1989 Gershon Elber, Non commercial use only.\n";
static char
    *CtrlStr =
	PROGRAM_NAME
	" l%-#Lvls!d s%-Width|Height!d!d h%-";
#endif /* SYSV */

static char
    *ProgramName;
static int
    NumLevels = DEFAULT_NUM_LEVELS,
    ImageWidth = DEFAULT_WIDTH,
    ImageHeight = DEFAULT_HEIGHT;

static void QuitGifError(GifFileType *GifFile);

/******************************************************************************
* Interpret the command line and scan the given GIF file.		      *
******************************************************************************/
void main(int argc, char **argv)
{
    int	i, j, l, c, Error, LevelStep, LogNumLevels,
	Count = 0, LevelsFlag = FALSE, SizeFlag = FALSE, HelpFlag = FALSE;
    RowType Line;
    GifColorType *ColorMap;
    GifFileType *GifFile;

    if (strlen(ProgramName = argv[0]) == 0)		    /* DOS 3.x only! */
	ProgramName = PROGRAM_NAME;	  /* Do something reasonable for 2.x */

    if ((Error = GAGetArgs(argc, argv, CtrlStr,
		&LevelsFlag, &NumLevels,
		&SizeFlag, &ImageWidth, &ImageHeight,
		&HelpFlag)) != FALSE) {
	GAPrintErrMsg(Error);
	GAPrintHowTo(CtrlStr);
	exit(1);
    }

    if (HelpFlag) {
	fprintf(stderr, VersionStr);
	GAPrintHowTo(CtrlStr);
	exit(0);
    }

    /* Make sure the number of levels is power of 2 (up to 32 levels.). */
    for (i=1; i<6; i++) if (NumLevels == (1 << i)) break;
    if (i == 6) EXIT("#Lvls (-l option) is not power of 2 up to 32\n");
    LogNumLevels = i + 3;		       /* Multiple by 8 (see below). */
    LevelStep = 256 / NumLevels;

    /* Make sure the image dimension is a multiple of NumLevels horizontally */
    /* and 7 (White, Red, Green, Blue and Yellow Cyan Magenta) vertically.   */
    ImageWidth = (ImageWidth / NumLevels) * NumLevels;
    ImageHeight = (ImageHeight / 7) * 7;

    /* Open stdout for the output file: */
    if ((GifFile = EGifOpenFileHandle(1)) == NULL)
	QuitGifError(GifFile);

    /* Dump out screen description with given size and generated color map:  */
    /* The color map has 7 NumLevels colors for White, Red, Green and then   */
    /* The secondary colors Yellow Cyan and magenta.			     */
    if ((ColorMap = (GifColorType *)
	    malloc(8 * NumLevels * sizeof(GifColorType)))
		== NULL) EXIT("Failed to allocate memory required, aborted");

    for (i=0; i<8; i++)					   /* Set color map. */
	for (j=0; j<NumLevels; j++) {
	    l = LevelStep * j;
	    c = i * NumLevels + j;
	    ColorMap[c].Red = (i == 0 || i == 1 || i == 4 || i == 6) * l;
	    ColorMap[c].Green =	(i == 0 || i == 2 || i == 4 || i == 5) * l;
	    ColorMap[c].Blue = (i == 0 || i == 3 || i == 5 || i == 6) * l;
	}

    if (EGifPutScreenDesc(GifFile,
	ImageWidth, ImageHeight, LogNumLevels, 0, LogNumLevels, ColorMap)
	== ERROR)
	QuitGifError(GifFile);

    /* Dump out the image descriptor: */
    if (EGifPutImageDesc(GifFile,
	0, 0, ImageWidth, ImageHeight, FALSE, LogNumLevels, NULL) == ERROR)
	QuitGifError(GifFile);

    fprintf(stderr, "\n%s: Image 1 at (%d, %d) [%dx%d]:     ",
		    ProgramName, GifFile -> ILeft, GifFile -> ITop,
		    GifFile -> IWidth, GifFile -> IHeight);

    /* Allocate one scan line to be used for all image.			     */
    if ((Line = (RowType) malloc(sizeof(PixelType) * ImageWidth)) == NULL)
	EXIT("Failed to allocate memory required, aborted");

    /* Dump the pixels: */
    for (c=0; c<7; c++) {
	for (i=0, l=0; i<NumLevels; i++)
	    for (j=0; j<ImageWidth / NumLevels; j++)
		Line[l++] = i + NumLevels * c;
	for (i=0; i<ImageHeight / 7; i++) {
	    if (EGifPutLine(GifFile, Line, ImageWidth) == ERROR)
		QuitGifError(GifFile);
	    fprintf(stderr, "\b\b\b\b%-4d", Count++);
	}
    }

    if (EGifCloseFile(GifFile) == ERROR)
	QuitGifError(GifFile);
}

/******************************************************************************
* Close output file (if open), and exit.				      *
******************************************************************************/
static void QuitGifError(GifFileType *GifFile)
{
    PrintGifError();
    if (GifFile != NULL) DGifCloseFile(GifFile);
    exit(1);
}
