/* graphics.c */

#include "header.h"
#include "demineur.h"

typedef void *bloc;

extern struct jeu    **tableau ;
extern int             nb_lig , nb_col , mines ;
extern unsigned long          temps ;
extern int         perdu , gagne ;

static unsigned int gamepal[16]=
{
	0x0000,0x3888,0x5ccc,0x7ff0,
	0x8fff,0x4800,0x4aa0,0x2080,
	0x1008,0x400f,0x50f0,0x3808,
	0x4f00,0x5f0f,0x3088,0x8fff
};


#define noir         0
#define gris         1
#define gris_clair   2
#define jaune        3
#define blanc        4
#define rouge        5
#define kaki         6
#define vert         7
#define bleu         8
#define bleu_violet  9
#define vert_clair   10
#define violet       11
#define marron       12
#define violet_clair 13
#define cyan         14
#define blancs       15

static bloc     numero [ 10 ] , backup ,
                bof , heureux , triste , joue , icone_select ,
                case_relief , marquee , interro ,
                num_case [ 9 ] , mine , mine_perdu , manquee ;
static int      couleur [ ] = { cyan, vert, rouge, bleu,
								violet , vert , noir , noir} ;

typedef struct mon_pixmap
{
   char *bits ;
   int couleur ;
}
MON_PIXMAP ;

#define bof_width 40
#define bof_height 40
static char bof_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
   0xe0, 0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0x1f, 0x00, 0x00, 0xfc, 0xff,
   0x3f, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,
   0x00, 0xff, 0xff, 0xff, 0x00, 0x80, 0x3f, 0xff, 0xfc, 0x01, 0x80, 0x1f,
   0x7e, 0xf8, 0x01, 0x80, 0x1f, 0x7e, 0xf8, 0x01, 0xc0, 0x3f, 0xff, 0xfc,
   0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0,
   0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff,
   0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03,
   0x80, 0xdf, 0xff, 0xfb, 0x01, 0x80, 0xbf, 0xff, 0xfd, 0x01, 0x80, 0x7f,
   0xff, 0xfe, 0x01, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff,
   0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x00,
   0xf8, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0x00, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define case_width 20
#define case_height 20
static char case_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01,
   0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01,
   0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01,
   0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01,
   0xf8, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define croix_width 20
#define croix_height 20
static char croix_bits[] = {
   0x00, 0x00, 0x00, 0x06, 0x00, 0x06, 0x0e, 0x00, 0x07, 0x1c, 0x80, 0x03,
   0x38, 0xc0, 0x01, 0x70, 0xe0, 0x00, 0xe0, 0x70, 0x00, 0xc0, 0x39, 0x00,
   0x80, 0x1f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x80, 0x1f, 0x00,
   0xc0, 0x39, 0x00, 0xe0, 0x70, 0x00, 0x70, 0xe0, 0x00, 0x38, 0xc0, 0x01,
   0x1c, 0x80, 0x03, 0x0e, 0x00, 0x07, 0x06, 0x00, 0x06, 0x00, 0x00, 0x00};
#define drapeau_width 20
#define drapeau_height 20
static char drapeau_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x06, 0x00, 0x80, 0x07, 0x00, 0xe0, 0x07, 0x00, 0xf0, 0x07, 0x00,
   0xe0, 0x07, 0x00, 0x80, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define heureux_width 40
#define heureux_height 40
static char heureux_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
   0xe0, 0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0x1f, 0x00, 0x00, 0xfc, 0xff,
   0x3f, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,
   0x00, 0x0f, 0x00, 0xf0, 0x00, 0x80, 0x07, 0x00, 0xe0, 0x01, 0x80, 0x0b,
   0x00, 0xd0, 0x01, 0x80, 0x0d, 0x18, 0xb0, 0x01, 0xc0, 0x0e, 0x3c, 0x70,
   0x03, 0x40, 0x1f, 0x7e, 0xf8, 0x02, 0x80, 0x3f, 0xff, 0xfc, 0x01, 0xc0,
   0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff,
   0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03,
   0x80, 0xff, 0xff, 0xff, 0x01, 0x80, 0xbf, 0xff, 0xfd, 0x01, 0x80, 0x7f,
   0xff, 0xfe, 0x01, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff,
   0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x00,
   0xf8, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0x00, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define icone_width 40
#define icone_height 40
static char icone_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x1f, 0xf8, 0xff, 0xff, 0xff,
   0x1f, 0xf8, 0xff, 0x00, 0xff, 0x1f, 0xf8, 0x1f, 0x00, 0xf8, 0x1f, 0xf8,
   0x07, 0x00, 0xe0, 0x1f, 0xf8, 0x03, 0x00, 0xc0, 0x1f, 0xf8, 0x01, 0x00,
   0x80, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0x78, 0x00, 0x00, 0x00, 0x1e,
   0x78, 0x00, 0x00, 0x00, 0x1e, 0x38, 0x00, 0x00, 0x00, 0x1c, 0x38, 0x00,
   0x00, 0x00, 0x1c, 0x38, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x00, 0x00, 0x00,
   0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18,
   0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
   0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18,
   0x38, 0x00, 0x00, 0x00, 0x1c, 0x38, 0x00, 0x00, 0x00, 0x1c, 0x38, 0x00,
   0x00, 0x00, 0x1c, 0x78, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x00, 0x00, 0x00,
   0x1e, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x01, 0x00, 0x80, 0x1f, 0xf8,
   0x03, 0x00, 0xc0, 0x1f, 0xf8, 0x07, 0x00, 0xe0, 0x1f, 0xf8, 0x1f, 0x00,
   0xf8, 0x1f, 0xf8, 0xff, 0x00, 0xff, 0x1f, 0xf8, 0xff, 0xff, 0xff, 0x1f,
   0xf8, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define icone_blanc_width 40
#define icone_blanc_height 40
static char icone_blanc_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff,
   0xff, 0xff, 0x1f, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
   0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
   0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
   0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define icone_gris_width 40
#define icone_gris_height 40
static char icone_gris_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
#define interro_width 20
#define interro_height 20
static char interro_bits[] = {
   0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0xf8, 0xff, 0xf1,
   0x78, 0xe0, 0xf1, 0x38, 0xc0, 0xf1, 0x18, 0x8f, 0xf1, 0x18, 0x8f, 0xf1,
   0xf8, 0xc7, 0xf1, 0xf8, 0xe3, 0xf1, 0xf8, 0xe3, 0xf1, 0xf8, 0xf1, 0xf1,
   0xf8, 0xff, 0xf1, 0xf8, 0xf1, 0xf1, 0xf8, 0xf1, 0xf1, 0xf8, 0xf1, 0xf1,
   0xf8, 0xff, 0xf1, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0};
#define joue_width 40
#define joue_height 40
static char joue_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
   0xe0, 0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0x1f, 0x00, 0x00, 0xfc, 0xff,
   0x3f, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,
   0x00, 0x3f, 0xff, 0xfc, 0x00, 0x80, 0x1f, 0x7e, 0xf8, 0x01, 0x80, 0x0f,
   0x3c, 0xf0, 0x01, 0x80, 0x0f, 0x3c, 0xf0, 0x01, 0xc0, 0x1f, 0x7e, 0xf8,
   0x03, 0xc0, 0x3f, 0xff, 0xfc, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0,
   0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff,
   0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xe7, 0xff, 0x03,
   0x80, 0xff, 0xdb, 0xff, 0x01, 0x80, 0xff, 0xbd, 0xff, 0x01, 0x80, 0xff,
   0xbd, 0xff, 0x01, 0x00, 0xff, 0xdb, 0xff, 0x00, 0x00, 0xff, 0xe7, 0xff,
   0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x00,
   0xf8, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0x00, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define manquee_width 20
#define manquee_height 20
static char manquee_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xf0, 0xff,
   0x3f, 0xc0, 0xff, 0x7f, 0xe0, 0xff, 0xef, 0x70, 0xff, 0xcf, 0x39, 0xff,
   0x87, 0x1f, 0xfe, 0x01, 0x0f, 0xf8, 0x01, 0x0f, 0xf8, 0x87, 0x1f, 0xfe,
   0xcf, 0x39, 0xff, 0xef, 0x70, 0xff, 0x7f, 0xe0, 0xff, 0x3f, 0xc0, 0xff,
   0xff, 0xf0, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff};
#define mine_width 20
#define mine_height 20
static char mine_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xf9, 0xff, 0xf7, 0xf0, 0xfe,
   0x2f, 0x40, 0xff, 0x1f, 0x80, 0xff, 0x0f, 0x00, 0xff, 0x0f, 0x00, 0xff,
   0x07, 0x00, 0xfe, 0x01, 0x00, 0xf8, 0x01, 0x00, 0xf8, 0x07, 0x00, 0xfe,
   0x0f, 0x00, 0xff, 0x0f, 0x00, 0xff, 0x1f, 0x80, 0xff, 0x2f, 0x40, 0xff,
   0xf7, 0xf0, 0xfe, 0xff, 0xf9, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff};
#define num_case_0_width 20
#define num_case_0_height 20
static char num_case_0_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define num_case_1_width 20
#define num_case_1_height 20
static char num_case_1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x0f, 0x00, 0x80, 0x0f, 0x00, 0xc0, 0x0f, 0x00, 0xe0, 0x0f, 0x00,
   0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00,
   0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0xe0, 0x7f, 0x00,
   0xe0, 0x7f, 0x00, 0xe0, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define num_case_2_width 20
#define num_case_2_height 20
static char num_case_2_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0xe0, 0x7f, 0x00,
   0xf0, 0xff, 0x00, 0x70, 0xe0, 0x00, 0x70, 0xf0, 0x00, 0x00, 0x78, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x0f, 0x00, 0x80, 0x07, 0x00,
   0xc0, 0x03, 0x00, 0xe0, 0x01, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0xff, 0x00,
   0xf0, 0xff, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define num_case_3_width 20
#define num_case_3_height 20
static char num_case_3_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0xf0, 0x7f, 0x00,
   0xf0, 0xff, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00,
   0x00, 0x7f, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0xf0, 0x00,
   0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0xf0, 0xff, 0x00, 0xf0, 0x7f, 0x00,
   0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define num_case_4_width 20
#define num_case_4_height 20
static char num_case_4_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7b, 0x00, 0xc0, 0x7b, 0x00,
   0xc0, 0x7b, 0x00, 0xe0, 0x79, 0x00, 0xe0, 0x79, 0x00, 0xf0, 0x78, 0x00,
   0xf0, 0x78, 0x00, 0xf0, 0xff, 0x00, 0xf0, 0xff, 0x00, 0xf0, 0xff, 0x00,
   0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00,
   0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define num_case_5_width 20
#define num_case_5_height 20
static char num_case_5_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0xf0, 0xff, 0x00,
   0xf0, 0xff, 0x00, 0x70, 0x00, 0x00, 0x70, 0x00, 0x00, 0x70, 0x00, 0x00,
   0xf0, 0x3f, 0x00, 0xf0, 0x7f, 0x00, 0xf0, 0xff, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0xe0, 0x00, 0x70, 0xe0, 0x00, 0xf0, 0xff, 0x00, 0xe0, 0x7f, 0x00,
   0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define num_case_6_width 20
#define num_case_6_height 20
static char num_case_6_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x00, 0xe0, 0xff, 0x00,
   0xf0, 0xff, 0x00, 0x70, 0x00, 0x00, 0x70, 0x00, 0x00, 0x70, 0x00, 0x00,
   0xf0, 0x3f, 0x00, 0xf0, 0x7f, 0x00, 0xf0, 0xff, 0x00, 0x70, 0xe0, 0x00,
   0x70, 0xe0, 0x00, 0x70, 0xe0, 0x00, 0xf0, 0xff, 0x00, 0xe0, 0x7f, 0x00,
   0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define num_case_7_width 20
#define num_case_7_height 20
static char num_case_7_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0xf0, 0xff, 0x00,
   0xf0, 0xff, 0x00, 0x00, 0x70, 0x00, 0x00, 0x70, 0x00, 0x00, 0x38, 0x00,
   0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x07, 0x00, 0x00, 0x07, 0x00, 0x80, 0x03, 0x00,
   0x80, 0x03, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define num_case_8_width 20
#define num_case_8_height 20
static char num_case_8_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0xe0, 0x7f, 0x00,
   0xf0, 0xff, 0x00, 0xf0, 0xf9, 0x00, 0xf0, 0xf0, 0x00, 0xf0, 0xf9, 0x00,
   0xe0, 0x7f, 0x00, 0xc0, 0x3f, 0x00, 0xe0, 0x7f, 0x00, 0xf0, 0xf9, 0x00,
   0xf0, 0xf0, 0x00, 0xf0, 0xf9, 0x00, 0xf0, 0xff, 0x00, 0xe0, 0x7f, 0x00,
   0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_0_width 20
#define numero_0_height 30
static char numero_0_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0xf4, 0xff, 0x02,
   0xec, 0x7f, 0x03, 0xdc, 0xbf, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x1c, 0x80, 0x03,
   0x0c, 0x00, 0x03, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02,
   0x0c, 0x00, 0x03, 0x1c, 0x80, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0xdc, 0xbf, 0x03, 0xec, 0x7f, 0x03, 0xf4, 0xff, 0x02, 0xf8, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_1_width 20
#define numero_1_height 30
static char numero_1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
   0x00, 0x00, 0x03, 0x00, 0x80, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x80, 0x03,
   0x00, 0x00, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
   0x00, 0x00, 0x03, 0x00, 0x80, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0x80, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_2_width 20
#define numero_2_height 30
static char numero_2_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0xf0, 0xff, 0x02,
   0xe0, 0x7f, 0x03, 0xc0, 0xbf, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x80, 0x03,
   0xe0, 0x7f, 0x03, 0xf0, 0xff, 0x02, 0xf8, 0xff, 0x01, 0xf4, 0xff, 0x00,
   0xec, 0x7f, 0x00, 0x1c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0xdc, 0x3f, 0x00, 0xec, 0x7f, 0x00, 0xf4, 0xff, 0x00, 0xf8, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_3_width 20
#define numero_3_height 30
static char numero_3_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0xf0, 0xff, 0x02,
   0xe0, 0x7f, 0x03, 0xc0, 0xbf, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x80, 0x03,
   0xe0, 0x7f, 0x03, 0xf0, 0xff, 0x02, 0xf8, 0xff, 0x01, 0xf0, 0xff, 0x02,
   0xe0, 0x7f, 0x03, 0x00, 0x80, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0xc0, 0xbf, 0x03, 0xe0, 0x7f, 0x03, 0xf0, 0xff, 0x02, 0xf8, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_4_width 20
#define numero_4_height 30
static char numero_4_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02,
   0x0c, 0x00, 0x03, 0x1c, 0x80, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x1c, 0x80, 0x03,
   0xec, 0x7f, 0x03, 0xf4, 0xff, 0x02, 0xf8, 0xff, 0x01, 0xf0, 0xff, 0x02,
   0xe0, 0x7f, 0x03, 0x00, 0x80, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0x80, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_5_width 20
#define numero_5_height 30
static char numero_5_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0xf4, 0xff, 0x00,
   0xec, 0x7f, 0x00, 0xdc, 0x3f, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x1c, 0x00, 0x00,
   0xec, 0x7f, 0x00, 0xf4, 0xff, 0x00, 0xf8, 0xff, 0x01, 0xf0, 0xff, 0x02,
   0xe0, 0x7f, 0x03, 0x00, 0x80, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0xc0, 0xbf, 0x03, 0xe0, 0x7f, 0x03, 0xf0, 0xff, 0x02, 0xf8, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_6_width 20
#define numero_6_height 30
static char numero_6_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0xf4, 0xff, 0x00,
   0xec, 0x7f, 0x00, 0xdc, 0x3f, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x1c, 0x00, 0x00,
   0xec, 0x7f, 0x00, 0xf4, 0xff, 0x00, 0xf8, 0xff, 0x01, 0xf4, 0xff, 0x02,
   0xec, 0x7f, 0x03, 0x1c, 0x80, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0xdc, 0xbf, 0x03, 0xec, 0x7f, 0x03, 0xf4, 0xff, 0x02, 0xf8, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_7_width 20
#define numero_7_height 30
static char numero_7_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0xf0, 0xff, 0x02,
   0xe0, 0x7f, 0x03, 0xc0, 0xbf, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x80, 0x03,
   0x00, 0x00, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
   0x00, 0x00, 0x03, 0x00, 0x80, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0x80, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_8_width 20
#define numero_8_height 30
static char numero_8_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0xf4, 0xff, 0x02,
   0xec, 0x7f, 0x03, 0xdc, 0xbf, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x1c, 0x80, 0x03,
   0xec, 0x7f, 0x03, 0xf4, 0xff, 0x02, 0xf8, 0xff, 0x01, 0xf4, 0xff, 0x02,
   0xec, 0x7f, 0x03, 0x1c, 0x80, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0xdc, 0xbf, 0x03, 0xec, 0x7f, 0x03, 0xf4, 0xff, 0x02, 0xf8, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define numero_9_width 20
#define numero_9_height 30
static char numero_9_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0xf4, 0xff, 0x02,
   0xec, 0x7f, 0x03, 0xdc, 0xbf, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03,
   0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x3c, 0xc0, 0x03, 0x1c, 0x80, 0x03,
   0xec, 0x7f, 0x03, 0xf4, 0xff, 0x02, 0xf8, 0xff, 0x01, 0xf0, 0xff, 0x02,
   0xe0, 0x7f, 0x03, 0x00, 0x80, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
   0xc0, 0xbf, 0x03, 0xe0, 0x7f, 0x03, 0xf0, 0xff, 0x02, 0xf8, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define pied_width 20
#define pied_height 20
static char pied_bits[] = {
   0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0xf8, 0xff, 0xf1,
   0xf8, 0xf9, 0xf1, 0x78, 0xf8, 0xf1, 0x18, 0xf8, 0xf1, 0x08, 0xf8, 0xf1,
   0x18, 0xf8, 0xf1, 0x78, 0xf8, 0xf1, 0xf8, 0xf9, 0xf1, 0xf8, 0xfb, 0xf1,
   0xf8, 0xfb, 0xf1, 0xf8, 0xf0, 0xf1, 0x38, 0xc0, 0xf1, 0x18, 0x80, 0xf1,
   0xf8, 0xff, 0xf1, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0};
#define reflet_width 20
#define reflet_height 20
static char reflet_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00,
   0x80, 0x03, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define reflet_manquee_width 20
#define reflet_manquee_height 20
static char reflet_manquee_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
   0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define relief_blanc_width 20
#define relief_blanc_height 20
static char relief_blanc_bits[] = {
   0xff, 0xff, 0x07, 0xff, 0xff, 0x03, 0xff, 0xff, 0x01, 0x07, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00};
#define relief_gris_width 20
#define relief_gris_height 20
static char relief_gris_bits[] = {
   0x00, 0x00, 0x08, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e,
   0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e,
   0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e,
   0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e,
   0x00, 0x00, 0x0e, 0xfc, 0xff, 0x0f, 0xfe, 0xff, 0x0f, 0xff, 0xff, 0x0f};
#define select_blanc_width 40
#define select_blanc_height 40
static char select_blanc_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff,
   0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff};
#define select_gris_width 40
#define select_gris_height 40
static char select_gris_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
   0xff, 0xff, 0x3f, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
   0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
   0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
   0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00};
#define triste_width 40
#define triste_height 40
static char triste_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
   0xe0, 0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0x1f, 0x00, 0x00, 0xfc, 0xff,
   0x3f, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,
   0x00, 0xff, 0xff, 0xff, 0x00, 0x80, 0xdf, 0x7e, 0xfb, 0x01, 0x80, 0x3f,
   0xff, 0xfc, 0x01, 0x80, 0x3f, 0xff, 0xfc, 0x01, 0xc0, 0xdf, 0x7e, 0xfb,
   0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0,
   0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff,
   0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0x03,
   0x80, 0xff, 0x00, 0xff, 0x01, 0x80, 0x7f, 0xff, 0xfe, 0x01, 0x80, 0xbf,
   0xff, 0xfd, 0x01, 0x00, 0xdf, 0xff, 0xfb, 0x00, 0x00, 0xff, 0xff, 0xff,
   0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x00,
   0xf8, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0x00, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/* ~~~~~~~~~~~~~~~~~~~~~~~~~ Gestion de l'affichage ~~~~~~~~~~~~~~~~~~~~~~~~~ */

int gmode=0;
unsigned char t[50][50];

void getbackup()
{
	getbloc(&backup,0,0,320,200);
}

void putbackup()
{
	putbloc(&backup,0,0);
}


bloc createbloc(s,width,height,c1,c0)
char *s;
int width,height,c1,c0;
{
   int x , y , n , m ;
   int w2=width/RATIO;
   int h2=height/RATIO;
   int w=16*((w2+15)/16);
   bloc result;
   int seuil=RATIO*RATIO/2;
   
	initbloc(&result);

	pbox(0,0,w,h2,FOND);
	pbox(0,0,w2,h2,c0);

	
      for ( y = 0 ; y < h2+1 ; y ++ )
         for ( x = 0 ; x < w2+1 ; x ++ )
			t[y][x]=0;

      setcolor ( c1 ) ;
      n = m = 0 ;
      for ( y = 0 ; y < height ; y ++ )
      {
         if ( m != 0 )
         {
            n ++ ;
         }
         m = 0 ;
         for ( x = 0 ; x < width ; x ++ )
         {
            if ( s [ n ] & ( 1 << m ) )
            {
               t[y/RATIO][x/RATIO]++;
            }
            m ++ ;
            if ( m == 8 )
            {
               m = 0 ;
               n ++ ;
            }
         }
      }

      for ( y = 0 ; y < h2 ; y ++ )
         for ( x = 0 ; x < w2 ; x ++ )
			if (t[y][x]>seuil) plot(x,y,-1);
   
   getbloc(&result,0,0,w,h2);

   pbox(0,0,w2,h2,MASK);
   getmask(&result,0,0);

	return result;
}


bloc copie ( pixmap , width , height , nb )
struct mon_pixmap pixmap [ ] ;
unsigned int width , height ;
int nb ;
{
   bloc result ;
   int i , x , y , n , m , c, dx , dy , min , nmin;
   int w2=width/RATIO;
   int h2=height/RATIO;
   int w=16*((w2+15)/16);

	initbloc(&result);
	pbox(0,0,w,h2,FOND);
	pbox(0,0,w2,h2,noir);

      for ( y = 0 ; y < height ; y ++ )
         for ( x = 0 ; x < width ; x ++ )
			t[y][x] = 0;

   for ( i = 0 ; i < nb ; i ++ )
   {

      setcolor ( c=pixmap [ i ] . couleur ) ;

      n = m = 0 ;
      for ( y = 0 ; y < height ; y ++ )
      {
         if ( m != 0 )
         {
            n ++ ;
         }
         m = 0 ;
         for ( x = 0 ; x < width ; x ++ )
         {
            if ( pixmap [ i ] . bits [ n ] & ( 1 << m ) )
            {
               t[y][x]=(char)c;
            }
            m ++ ;
            if ( m == 8 )
            {
               m = 0 ;
               n ++ ;
            }
         }
      }
   }

      for ( y = 0 ; y < height ; y += RATIO )
         for ( x = 0 ; x < width ; x += RATIO )
         {
         	if (RATIO==1)
         		c=(int)t[y][x];
         	else
         	{
         	  i=0;
         	  n=0;
         	  c= -1;
         	  min= -1;
         	  nmin= 0;
		      for ( dy = 0 ; dy < RATIO ; dy ++ )
        		 for ( dx = 0 ; dx < RATIO ; dx ++ )
				 {
        		 	m=(int)t[y+dy][x+dx];
					i+=m;
					if (m==noir) n++;
					if (m>c) c=m;
					if ((min!=noir)&&(min!=rouge)) min=m;
					if (m==gris_clair) nmin++;
         		 }
			  if (!gmode) c=i/(RATIO*RATIO);
			  else
			  if (gmode==2) { c=min; if (nmin>2) c=gris_clair; }
			  else
			  if (n>1) c=0;
         	}
         	
			plot(x/RATIO,y/RATIO,c);
		 }

   refresh();
   getbloc(&result,0,0,w,h2);

   refresh();
   pbox(0,0,w2,h2,MASK);
   getmask(&result,0,0);

   return result ;
}


void cree_pixmaps ( )
{
   int             fore [ 10 ] ;
   int             i ;
   MON_PIXMAP      pixmap [ 4 ] ;

	cls();
	setpalette(gamepal);
	
	setcolor(blanc);	
	dbox(0,0,320,200,blanc);
	afftext(160-8*4-4,100-4-20,"demineur!");
	afftext(8*3+4,100-4+20,"documentation dans \"demineur.txt\"");
	afftext(8,142,"touches:");
	afftext(8,158,"p : podium");
	afftext(8,166,"q : quitter le jeu");
	afftext(8,174,"a : autre type de demineur");
	afftext(8,182,"espace : verifier drapeaux adjacents");

	swap();

   initbloc(&backup);
   getbackup();

	gmode=1;

   fore [ 0 ] = gris_clair ;
   for ( i = 1 ; i <= 8 ; i ++ )
   {
      fore [ i ] = couleur [ i - 1 ] ;
   }

   numero [ 0 ] = createbloc (
                                                numero_0_bits ,
                                                numero_0_width , numero_0_height ,
                                                rouge , noir );
                                                
   numero [ 1 ] = createbloc (
                                                numero_1_bits ,
                                                numero_1_width , numero_1_height ,
                                                rouge , noir );
                                                
   numero [ 2 ] = createbloc (
                                                numero_2_bits ,
                                                numero_2_width , numero_2_height ,
                                                rouge , noir );
                                                
   numero [ 3 ] = createbloc (
                                                numero_3_bits ,
                                                numero_3_width , numero_3_height ,
                                                rouge , noir );
                                                
   numero [ 4 ] = createbloc (
                                                numero_4_bits ,
                                                numero_4_width , numero_4_height ,
                                                rouge , noir );
                                                
   numero [ 5 ] = createbloc (
                                                numero_5_bits ,
                                                numero_5_width , numero_5_height ,
                                                rouge , noir );
                                                
   numero [ 6 ] = createbloc (
                                                numero_6_bits ,
                                                numero_6_width , numero_6_height ,
                                                rouge , noir );
                                                
   numero [ 7 ] = createbloc (
                                                numero_7_bits ,
                                                numero_7_width , numero_7_height ,
                                                rouge , noir );
                                                
   numero [ 8 ] = createbloc (
                                                numero_8_bits ,
                                                numero_8_width , numero_8_height ,
                                                rouge , noir );
                                                
   numero [ 9 ] = createbloc (
                                                numero_9_bits ,
                                                numero_9_width , numero_9_height ,
                                                rouge , noir );
	gmode=0;                                                

   pixmap [ 0 ] . bits    = icone_blanc_bits ;
   pixmap [ 0 ] . couleur = blanc ;
   pixmap [ 1 ] . bits    = icone_gris_bits ;
   pixmap [ 1 ] . couleur = gris ;
   pixmap [ 2 ] . bits    = icone_bits ;
   pixmap [ 2 ] . couleur = gris_clair ;
   pixmap [ 3 ] . bits    = bof_bits ;
   pixmap [ 3 ] . couleur = jaune ;
   bof = copie ( pixmap , bof_width , bof_height , 4 ) ;

   pixmap [ 3 ] . bits = heureux_bits ;
   heureux = copie ( pixmap , heureux_width , heureux_height , 4 ) ;

   pixmap [ 3 ] . bits = triste_bits ;
   triste = copie ( pixmap , triste_width , triste_height , 4 ) ;

   pixmap [ 3 ] . bits = joue_bits ;
   joue = copie ( pixmap , joue_width , joue_height , 4 ) ;

   pixmap [ 0 ] . bits    = select_gris_bits ;
   pixmap [ 0 ] . couleur = gris ;
   pixmap [ 1 ] . bits    = select_blanc_bits ;
   pixmap [ 1 ] . couleur = blanc ;
   pixmap [ 2 ] . bits    = icone_bits ;
   pixmap [ 2 ] . couleur = gris_clair ;
   pixmap [ 3 ] . bits    = bof_bits ;
   pixmap [ 3 ] . couleur = jaune ;
   icone_select = copie ( pixmap , bof_width , bof_height , 4 ) ;

	gmode=1;

   pixmap [ 0 ] . bits    = relief_blanc_bits ;
   pixmap [ 0 ] . couleur = blanc ;
   pixmap [ 1 ] . bits    = relief_gris_bits ;
   pixmap [ 1 ] . couleur = gris ;
   pixmap [ 2 ] . bits    = case_bits ;
   pixmap [ 2 ] . couleur = kaki ;
   case_relief = copie ( pixmap , case_width , case_height , 3 ) ;

	gmode=2;

   pixmap [ 2 ] . couleur = gris_clair ;
   pixmap [ 2 ] . bits    = pied_bits ;
   pixmap [ 3 ] . bits    = drapeau_bits ;
   pixmap [ 3 ] . couleur = rouge ;
   marquee = copie ( pixmap , drapeau_width , drapeau_height , 4 ) ;

	gmode=0;

   pixmap [ 2 ] . bits = interro_bits ;
   interro = copie ( pixmap , interro_width , interro_height , 3 ) ;

	gmode=1;

   num_case [ 0 ] = createbloc (
                                                  num_case_0_bits ,
                                                  num_case_0_width , num_case_0_height ,
                                                  fore [ 0 ] , gris_clair );
                                                  
   num_case [ 1 ] = createbloc (
                                                  num_case_1_bits ,
                                                  num_case_1_width , num_case_1_height ,
                                                  fore [ 1 ] , gris_clair );
                                                  
   num_case [ 2 ] = createbloc (
                                                  num_case_2_bits ,
                                                  num_case_2_width , num_case_2_height ,
                                                  fore [ 2 ] , gris_clair );
                                                  
   num_case [ 3 ] = createbloc (
                                                  num_case_3_bits ,
                                                  num_case_3_width , num_case_3_height ,
                                                  fore [ 3 ] , gris_clair );
                                                  
   num_case [ 4 ] = createbloc (
                                                  num_case_4_bits ,
                                                  num_case_4_width , num_case_4_height ,
                                                  fore [ 4 ] , gris_clair );
                                                  
   num_case [ 5 ] = createbloc (
                                                  num_case_5_bits ,
                                                  num_case_5_width , num_case_5_height ,
                                                  fore [ 5 ] , gris_clair );
                                                  
   num_case [ 6 ] = createbloc (
                                                  num_case_6_bits ,
                                                  num_case_6_width , num_case_6_height ,
                                                  fore [ 6 ] , gris_clair );
                                                  
   num_case [ 7 ] = createbloc (
                                                  num_case_7_bits ,
                                                  num_case_7_width , num_case_7_height ,
                                                  fore [ 7 ] , gris_clair );
                                                  
   num_case [ 8 ] = createbloc (
                                                  num_case_8_bits ,
                                                  num_case_8_width , num_case_8_height ,
                                                  fore [ 8 ] , gris_clair );
                                                  

   pixmap [ 0 ] . bits    = mine_bits ;
   pixmap [ 0 ] . couleur = gris_clair ;
   pixmap [ 1 ] . bits    = reflet_bits ;
   pixmap [ 1 ] . couleur = blanc ;
   mine = copie ( pixmap , mine_width , mine_height , 2 ) ;

   pixmap [ 0 ] . bits    = mine_bits ;
   pixmap [ 0 ] . couleur = rouge ;
   pixmap [ 1 ] . bits    = reflet_bits ;
   pixmap [ 1 ] . couleur = blanc ;
   mine_perdu = copie ( pixmap , mine_width , mine_height , 2 ) ;

   pixmap [ 0 ] . bits    = manquee_bits ;
   pixmap [ 0 ] . couleur = gris_clair ;
   pixmap [ 1 ] . bits    = croix_bits ;
   pixmap [ 1 ] . couleur = rouge ;
   pixmap [ 2 ] . bits    = reflet_manquee_bits ;
   pixmap [ 2 ] . couleur = blanc ;
   manquee = copie ( pixmap , manquee_width , manquee_height , 3 ) ;
}


void nombre_de_mines ( )
{
   int n [ 3 ] ;

   n [ 0 ] = mines / 100 ;
   n [ 1 ] = ( mines % 100 ) / 10 ;
   n [ 2 ] = mines - ( n [ 0 ] * 100 ) - ( n [ 1 ] * 10 ) ;
   
   putbloc(&numero [ n [ 0 ] ] , 
               X_NB_MINES , Y_NB_MINES ) ;
   putbloc(&numero [ n [ 1 ] ] , 
               X_NB_MINES + LARG_NUMERO , Y_NB_MINES ) ;
   putbloc(&numero [ n [ 2 ] ] , 
               X_NB_MINES + 2 * LARG_NUMERO , Y_NB_MINES ) ;

   setcolor ( blanc ) ;

   dline (
               X_NB_MINES                   , Y_NB_MINES + HAUT_NUMERO ,
               X_NB_MINES + 3 * LARG_NUMERO , Y_NB_MINES + HAUT_NUMERO ,-1) ;
   dline (
               X_NB_MINES + 3 * LARG_NUMERO , Y_NB_MINES ,
               X_NB_MINES + 3 * LARG_NUMERO , Y_NB_MINES + HAUT_NUMERO,-1) ;

   setcolor ( gris ) ;

   dline (
               X_NB_MINES - 1               , Y_NB_MINES - 1 ,
               X_NB_MINES + 3 * LARG_NUMERO , Y_NB_MINES - 1 ,-1) ;
   dline (
               X_NB_MINES - 1 , Y_NB_MINES - 1 ,
               X_NB_MINES - 1 , Y_NB_MINES + HAUT_NUMERO ,-1) ;
}

void icone_perdu_gagne ( )
{
   if ( perdu )
   {
      putbloc(&triste , 
                  X_ICONE , Y_ICONE ) ;
   }
   else if ( gagne )
   {
      putbloc(&heureux , 
                  X_ICONE , Y_ICONE ) ;
   }
   else
   {
      putbloc(&bof , 
                  X_ICONE , Y_ICONE ) ;
   }
}

void chronometre ( )
{
   int n [ 3 ] ;

	unsigned int t=(unsigned int)temps;

   n [ 0 ] = ( int ) ( t / 100 ) ;
   n [ 1 ] = ( int ) ( ( t % 100 ) / 10 ) ;
   n [ 2 ] = ( int ) ( t % 10 ) ;

   putbloc(&numero [ n [ 0 ] ] , 
               X_CHRONO , Y_CHRONO ) ;
   putbloc(&numero [ n [ 1 ] ] , 
               X_CHRONO + LARG_NUMERO , Y_CHRONO ) ;
   putbloc(&numero [ n [ 2 ] ] , 
               X_CHRONO + 2 * LARG_NUMERO , Y_CHRONO ) ;

   setcolor ( blanc ) ;

   dline (
               X_CHRONO                   , Y_CHRONO + HAUT_NUMERO ,
               X_CHRONO + 3 * LARG_NUMERO , Y_CHRONO + HAUT_NUMERO ,-1) ;
   dline (
               X_CHRONO + 3 * LARG_NUMERO , Y_CHRONO ,
               X_CHRONO + 3 * LARG_NUMERO , Y_CHRONO + HAUT_NUMERO,-1) ;

   setcolor ( gris ) ;

   dline (
               X_CHRONO - 1               , Y_CHRONO - 1 ,
               X_CHRONO + 3 * LARG_NUMERO , Y_CHRONO - 1 ,-1) ;
   dline (
               X_CHRONO - 1 , Y_CHRONO - 1 ,
               X_CHRONO - 1 , Y_CHRONO + HAUT_NUMERO ,-1) ;
}

void grille ( )
{
   int coord ;

   setcolor ( noir ) ;

   for ( coord = X_JEU ; coord < X_JEU + LARG_JEU ; coord += LARG_CASE + 1 )
   {
      dline (
                  coord , Y_JEU , coord , Y_JEU + HAUT_JEU - 1 ,-1) ;
   }

   for ( coord = Y_JEU ; coord < Y_JEU + HAUT_JEU ; coord += HAUT_CASE + 1 )
   {
      dline (
                  X_JEU , coord , X_JEU + LARG_JEU - 1 , coord ,-1) ;
   }
}

void affiche_case ( lig , col )
int lig , col ;
{
   int x , y ;

   if ( lig < 1 || lig > nb_lig || col < 1 || col > nb_col )
   {
      return ;
   }

   x = X_JEU + 1 + ( col - 1 ) * ( LARG_CASE + 1 ) ;
   y = Y_JEU + 1 + ( lig - 1 ) * ( HAUT_CASE + 1 ) ;

   switch ( tableau [ lig ] [ col ] . etat )
   {
   case COUVERTE :
      if ( perdu && tableau [ lig ] [ col ] . mine )
      {
         putbloc(&mine , 
                     x , y ) ;
      }
      else
      {
         putbloc(&case_relief , 
                     x , y ) ;
      }
      break ;
   case DECOUVERTE :
      if ( ! tableau [ lig ] [ col ] . mine )
      {
         putbloc(&num_case [ tableau [ lig ] [ col ] . nombre ] ,
                     x , y ) ;
      }
      else
      {
         putbloc(&mine_perdu , 
                     x , y ) ;
      }
      break ;
   case MARQUEE :
      if ( perdu && ! tableau [ lig ] [ col ] . mine )
      {
         putbloc(&manquee , 
                     x , y ) ;
      }
      else
      {
         putbloc(&marquee , 
                     x , y ) ;
      }
      break ;
   case INTERRO :
      if ( perdu && tableau [ lig ] [ col ] . mine )
      {
         putbloc(&mine , 
                     x , y ) ;
      }
      else
      {
         putbloc(&interro , 
                     x , y ) ;
      }
      break ;
   }
}


void affiche_jeu ( )
{
   int l , c ;

   nombre_de_mines ( ) ;
   icone_perdu_gagne ( ) ;
   chronometre ( ) ;
   grille ( ) ;
   for ( l = 1 ; l <= nb_lig ; l ++ )
   {
      for ( c = 1 ; c <= nb_col ; c ++ )
      {
         affiche_case ( l , c  ) ;
      }
   }
}

void bord ( )
{
   int coord ;

   pbox ( 0,0, LARGEUR_FEN - 1 , HAUTEUR_FEN - 1 , gris_clair ) ;

   dbox(0,0,320,200,gris);

   setcolor ( blanc ) ;

   for ( coord = 0 ; coord < LARG_BORD ; coord ++ )
   {

      dline (
                  0 , coord , LARGEUR_FEN - 2 - coord , coord , -1) ;
      dline (
                  coord , 0 , coord , HAUTEUR_FEN - 2 - coord, -1 ) ;
      dline (
                  BORD - LARG_BORD + coord + 1               ,
                  MARGE_HAUT  - BORD - 1 - coord + LARG_BORD ,
                  LARGEUR_FEN - BORD + LARG_BORD - 1         ,
                  MARGE_HAUT  - BORD - 1 - coord + LARG_BORD, -1 ) ;
      dline (
                  LARGEUR_FEN - BORD + LARG_BORD - coord - 1 ,
                  BORD - LARG_BORD + coord + 1               ,
                  LARGEUR_FEN - BORD + LARG_BORD - coord - 1 ,
                  MARGE_HAUT - BORD - 1 + LARG_BORD , -1) ;
      dline (
                  BORD - 1 - coord       , HAUTEUR_FEN - BORD + coord ,
                  LARGEUR_FEN - BORD - 1 , HAUTEUR_FEN - BORD + coord , -1) ;
      dline (
                  LARGEUR_FEN - BORD + coord ,
                  MARGE_HAUT - coord         ,
                  LARGEUR_FEN - BORD + coord ,
                  HAUTEUR_FEN - BORD + LARG_BORD - 1, -1 ) ;
   }

   setcolor ( gris ) ;

   for ( coord = 0 ; coord < LARG_BORD ; coord ++ )
   {
      dline (
                  coord           , HAUTEUR_FEN - 1 - coord ,
                  LARGEUR_FEN - 1 , HAUTEUR_FEN - 1 - coord , -1) ;
      dline (
                  LARGEUR_FEN - 1 - coord , coord ,
                  LARGEUR_FEN - 1 - coord , HAUTEUR_FEN - 1 , -1) ;
      dline (
                  BORD - 1                    , BORD - 1 - coord ,
                  LARGEUR_FEN - BORD  + coord , BORD - 1 - coord , -1) ;
      dline (
                  BORD - 1 - coord , BORD - LARG_BORD ,
                  BORD - 1 - coord , MARGE_HAUT - BORD  + coord , -1) ;
      dline (
                  BORD - 1                   , MARGE_HAUT - 1 - coord ,
                  LARGEUR_FEN - BORD + coord , MARGE_HAUT - 1 - coord , -1 ) ;
      dline (
                  BORD - 1 - coord , MARGE_HAUT - LARG_BORD ,
                  BORD - 1 - coord , HAUTEUR_FEN - BORD + coord , -1) ;
   }
}

void icone_joue ( )
{
   putbloc(&joue , 
               X_ICONE , Y_ICONE ) ;
}

void icone_activee ( )
{
   putbloc(&icone_select , 
               X_ICONE , Y_ICONE ) ;
}

void case_vide ( lig , col )
int lig , col ;
{
   int x , y ;

   if ( lig < 1 || lig > nb_lig || col < 1 || col > nb_col )
   {
      return ;
   }

   x = X_JEU + 1 + ( col - 1 ) * ( LARG_CASE + 1 ) ;
   y = Y_JEU + 1 + ( lig - 1 ) * ( HAUT_CASE + 1 ) ;

   putbloc(&num_case [ 0 ] , 
               x , y ) ;
}

void cases_vides ( lig , col )
int lig , col ;
{
   int l , c ;

   for ( l = lig - 1 ; l <= lig + 1 ; l ++ )
   {
      for ( c = col - 1 ; c <= col + 1 ; c ++ )
      {
         if ( tableau [ l ] [ c ] . etat == COUVERTE ||
              tableau [ l ] [ c ] . etat == INTERRO )
         {
            case_vide ( l , c ) ;
         }
      }
   }
}

void affiche_bloc ( lig , col )
int lig , col ;
{
   int l , c ;

   for ( l = lig - 1 ; l <= lig + 1 ; l ++ )
   {
      for ( c = col - 1 ; c <= col + 1 ; c ++ )
      {
         affiche_case ( l , c ) ;
      }
   }
}

void detruit_pixmaps ( )
{
   int i ;

   for ( i = 0 ; i <= 9 ; i ++ )
   {
      freebloc(&numero [ i ] ) ;
   }
   freebloc(&bof          ) ;
   freebloc(&heureux      ) ;
   freebloc(&triste       ) ;
   freebloc(&joue         ) ;
   freebloc(&icone_select ) ;
   freebloc(&case_relief  ) ;
   freebloc(&marquee      ) ;
   freebloc(&interro      ) ;
   for ( i = 0 ; i <= 8 ; i ++ )
   {
      freebloc(&num_case [ i ] ) ;
   }
   freebloc(&mine       ) ;
   freebloc(&mine_perdu ) ;
   freebloc(&manquee    ) ;

   freebloc(&backup);
}
