include hobbes.inc
include extrn.inc

EXTRN _HLineClipR

.CODE

;----------------------------------------------------------------------------
; void PixelR(void);
; uses register-based paramater passing
;	ax=posX
;	cx=posY
;	bx=COLOR
_PixelR proc
;		push    bp
;		mov     bp,sp
		push	ax
		push	bx
		push	dx
		push    ds
;duh. if i am saving all these stupid registers, then there's really no point
;in using register parameter-passing, is there?  ugh
		mov     cx,@data
		mov     ds,cx
pc_okay:
		mov     es,_ModeX_Segment     ; put video segment in ES

;	ax=posX
;	bx=posY
;	dx=COLOR

;		mov     bx,Y
		shl     bx,1
		mov     bx,word ptr _RowOffset[bx]
		add		bx,_Display_Offset
;		mov     ax,X
		mov     cl,al           ; prepare CL to compute plane
		shr     ax,2            ; X/4 = offset of pixel in scan line
		add     bx,ax           ; final offset of pixel in page

		and     cl,011b         ; CL = pixel's plane
		mov     ax,1100h+MAP_MASK ; AL = index in SC of Map Mask reg
		shl     ah,cl           ; set only the bit for the pixel's plane to 1
		mov		cx,dx			; move the COLOR
		mov     dx,SC_INDEX     ; set the Map Mask to enable only
		out     dx,ax           ;   the pixel's plane

;		mov     al,dl
		mov     es:[bx],cl      ; draw the pixel in the desired color

		pop     ds
		pop		dx
		pop		bx
		pop		ax
;		pop     bp
		ret
_PixelR          endp



;----------------------------------------------------------------------------
; void Circle(int x_center, int y_center, int radius, COLOR)
;
;	public _Circle
_Circle 	proc 	far
ARG X_CENTER:WORD, Y_CENTER:WORD, RADIUS:WORD, COLOR:WORD
LOCAL X:WORD, Y:WORD, D:WORD, deltaE:WORD, deltaSE:WORD = STACKSIZE
	push 	bp
	mov		bp,sp
	sub		bp,STACKSIZE
	push	ds
	mov		ax,@data
	mov		ds,ax
	push	si
	push	di

	;x=0
	mov		X,0

	;y=radius
	mov		ax,RADIUS
	mov		Y,ax
	neg		ax
	inc		ax
	;d=1-radius
	mov		D,ax

	;deltaE=3
	mov		deltaE,3

	;deltaSE=-2*radius+5
	dec		ax
	sar		ax,1
	add		ax,5

	jmp		@@CirclePoints

@@StartLoop:

	mov		ax,Y
	cmp		ax,X
	jg		@@While
	jmp		@@Done
;	WHILE (y < x)
@@While:
	mov		ax,d
	cmp		ax,0
	je		@@elseif
;	IF (d < 0)
	mov		ax,deltaE
	add		d,ax
	inc		deltaE
	inc		deltaE
	inc		deltaSE
	inc		deltaSE
	inc		x
@@elseif:
;	ELSE
	mov		ax,deltaSE
	add		d,ax
	inc		deltaE
	inc		deltaE
	add		deltaSE,4
	inc		x
	dec		y
;	ENDIF
	jmp		@@StartLoop
;	ENDWHILE


@@CirclePoints:
	mov		dx,COLOR
	mov		ax,X_CENTER
	add		ax,X
	mov		bx,Y_CENTER
	add		bx,Y
	call	_PixelR
;	Pixel( x+X_CENTER, y+Y_CENTER, COLOR);
	sub		ax,X
	sub		ax,X
	call	_PixelR
;	Pixel(-x+X_CENTER, y+Y_CENTER, COLOR);
	sub		bx,Y
	sub		bx,Y
	call	_PixelR
;	Pixel(-x+X_CENTER,-y+Y_CENTER, COLOR);
	add		ax,X
	add		ax,X
	call	_PixelR
;	Pixel( x+X_CENTER,-y+Y_CENTER, COLOR);

	mov		ax,X_CENTER
	add		ax,Y
	mov		bx,Y_CENTER
	add		bx,X
	call	_PixelR
;	Pixel( y+X_CENTER, x+Y_CENTER, COLOR);
	sub		ax,Y
	sub		ax,Y
	call	_PixelR
;	Pixel(-y+X_CENTER, x+Y_CENTER, COLOR);
	sub		bx,X
	sub		bx,X
	call	_PixelR
;	Pixel(-y+X_CENTER,-x+Y_CENTER, COLOR);
	add		ax,Y
	add		ax,Y
	call	_PixelR
;	Pixel( y+X_CENTER,-x+Y_CENTER, COLOR);
	jmp		@@StartLoop

@@Done:
	pop		di
	pop		si
	pop		ds
	pop		bp
	ret
_Circle endp




;-----------------------------------------------------------------------
; void CircleFill( int x_center, int y_center, int radius, char color)
;
		public  _CircleFill
_CircleFill   proc    far
ARG	X_CENTER:WORD, Y_CENTER:WORD, Radius:WORD, Color:WORD
		push    bp
		mov     bp,sp
		push    ds
		mov     ax,@data
		mov     ds,ax
		push    si
		push    di

		mov     si,0                ; si has X variable
		mov     di,RADIUS           ; di has Y variable

		mov     ax,X_CENTER
		mov     dx,ax
		sub     ax,di
		add     dx,di
		mov     cx,Y_CENTER
		mov     bx,COLOR
		call    far ptr far ptr _HLineClipR
;        HLineClip( x_center-y, x_center+y, y_center, color );

		mov     bx,RADIUS
		shl     bx,1
		mov     ax,3
		sub     ax,bx               ; ax has P variable
@@DiscTop:
		cmp     si,di
		jge     @@DiscDone            ; Check for done

		cmp     ax,0
		jge     @@Disc_2              ; Check if P greater than zero
		mov     dx,si
		shl     dx,2
		add     dx,6
		adc     ax,dx               ; p+=(x<<2)+6
		jmp     short   @@DiscCommon
@@Disc_2:
		push    ax              ; Save P variable

		mov     ax,X_CENTER
		mov     dx,ax
		sub     ax,si
		add     dx,si
		push    ax              ; Save X1 for later
		push    dx              ; Save X2 for later
		mov     cx,Y_CENTER
		sub     cx,di
		mov     bx,COLOR
		call    far ptr _HLineClipR
;        HLineClip( x_center-x, x_center+x, y_center-y, color );
		pop     dx              ; Get X2 back
		pop     ax              ; Get X1 back
		mov     cx,Y_CENTER
		add     cx,di
		mov     bx,COLOR
		call    far ptr _HLineClipR
;        HLineClip( x_center-x, x_center+x, y_center+y, color );

		pop     ax              ; Get P variable back

		mov     dx,si
		sub     dx,di
		dec     di
		shl     dx,2
		add     dx,10
		adc     ax,dx

		; Fall through into common code
@@DiscCommon:
		inc     si                  ; x++

		push    ax              ; Save P variable

		mov     ax,X_CENTER
		mov     dx,ax
		sub     ax,di
		add     dx,di
		push    ax              ; Save X1 for later
		push    dx              ; Save X2 for later
		mov     cx,Y_CENTER
		sub     cx,si
		mov     bx,COLOR
		call    far ptr _HLineClipR
;        HLineClip( x_center-y, x_center+y, y_center-x, color );
		pop     dx              ; Get X2 back
		pop     ax              ; Get X1 back
		mov     cx,Y_CENTER
		add     cx,si
		mov     bx,COLOR
		call    far ptr _HLineClipR
;        HLineClip( x_center-y, x_center+y, y_center+x, color );

		pop     ax              ; Get P variable back
		jmp     @@DiscTop

@@DiscDone:
		pop     di
		pop     si
		pop     ds
		pop     bp
		ret
_CircleFill   endp





;-----------------------------------------------------------------------
; void CircleFillClip( int x_center, int y_center, int radius, char color)

		public  _CircleFillClip
_CircleFillClip   proc    far
ARG	X_CENTER:WORD, Y_CENTER:WORD, RADIUS:WORD, COLOR:WORD
		push    bp
		mov     bp,sp
		push    ds
		mov     ax,@data
		mov     ds,ax
		push    si
		push    di

		mov     si,0                ; si has X variable
		mov     di,RADIUS           ; di has Y variable

		mov     ax,X_CENTER
		mov     dx,ax
		sub     ax,di
		add     dx,di
		mov     cx,Y_CENTER
		mov     bx,COLOR
		call    far ptr _HLineClipR
;        HLineClip( x_center-y, x_center+y, y_center, color );

		mov     bx,RADIUS
		shl     bx,1
		mov     ax,3
		sub     ax,bx               ; ax has P variable
@@CDiscTop:
		cmp     si,di
		jge     @@CDiscDone            ; Check for done

		cmp     ax,0
		jge     @@CDisc_2              ; Check if P greater than zero
		mov     dx,si
		shl     dx,2
		add     dx,6
		adc     ax,dx               ; p+=(x<<2)+6
		jmp     short   @@CDiscCommon
@@CDisc_2:
		push    ax              ; Save P variable

		mov     ax,X_CENTER
		mov     dx,ax
		sub     ax,si
		add     dx,si
		push    ax              ; Save X1 for later
		push    dx              ; Save X2 for later
		mov     cx,Y_CENTER
		sub     cx,di
		mov     bx,COLOR
		call    far ptr _HLineClipR
;        HLineClip( x_center-x, x_center+x, y_center-y, color );
		pop     dx              ; Get X2 back
		pop     ax              ; Get X1 back
		mov     cx,Y_CENTER
		add     cx,di
		mov     bx,COLOR
		call    far ptr _HLineClipR
;        HLineClip( x_center-x, x_center+x, y_center+y, color );

		pop     ax              ; Get P variable back

		mov     dx,si
		sub     dx,di
		dec     di
		shl     dx,2
		add     dx,10
		adc     ax,dx

		; Fall through into common code
@@CDiscCommon:
		inc     si                  ; x++

		push    ax              ; Save P variable

		mov     ax,X_CENTER
		mov     dx,ax
		sub     ax,di
		add     dx,di
		push    ax              ; Save X1 for later
		push    dx              ; Save X2 for later
		mov     cx,Y_CENTER
		sub     cx,si
		mov     bx,COLOR
		call    far ptr _HLineClipR
;        HLineClip( x_center-y, x_center+y, y_center-x, color );
		pop     dx              ; Get X2 back
		pop     ax              ; Get X1 back
		mov     cx,Y_CENTER
		add     cx,si
		mov     bx,COLOR
		call    far ptr _HLineClipR
;        HLineClip( x_center-y, x_center+y, y_center+x, color );

		pop     ax              ; Get P variable back
		jmp     @@CDiscTop

@@CDiscDone:
		pop     di
		pop     si
		pop     ds
		pop     bp
		ret
_CircleFillClip   endp


END