#include"hobbes.h"

void PixelPattern(int x, int y, PATTERN p) {
	RectangleFillPattern(x,y,x+1,y+1,p);
}

void PixelPatternClip(int x, int y, PATTERN p) {
	RectangleFillPatternClip(x,y,x+1,y+1,p);
}

void HLinePattern(int x0, int x1, int y, PATTERN p) {
	RectangleFillPattern(x0, y, x1+1, y+1, p);
}

void HLinePatternClip(int x0, int x1, int y, PATTERN p) {
	RectangleFillPatternClip(x0, y, x1+1, y+1, p);
}

void VLinePattern(int x, int y0, int y1, PATTERN p) {
	RectangleFillPattern(x, y0, x+1, y1+1, p);
}

void VLinePatternClip(int x, int y0, int y1, PATTERN p) {
	RectangleFillPatternClip(x, y0, x+1, y1+1, p);
}



void LineClip(int x0, int y0, int x1, int y1, COLOR color) {
	int temp, c;

	if (x0 > x1) {
		temp = x0;
		x0 = x1;
		x1 = temp;
		temp = y0;
		y0 = y1;
		y1 = temp;
		}

	if ((x0 < ClipLeft) && (x1 < ClipLeft)) 		return;
	if ((x0 > ClipRight) && (x1 > ClipRight)) 		return;
	if ((y0 < ClipTop) && (y1 < ClipTop)) 			return;
	if ((y0 > ClipBottom) && (y1 > ClipBottom)) 	return;

	if (x0 < ClipLeft) {
		{c = (y1 - y0) / (x1 - x0) * (x1 - ClipLeft);
		x0 = ClipLeft;
		y0 = y1 - c;};
		if ((y0 < ClipTop) && (y1 < ClipTop)) 		return;
		if ((y0 > ClipBottom) && (y1 > ClipBottom)) return;
		}


	if (x1 > ClipRight) {
		c = (y1 - y0) / (x1 - x0) * (ClipRight - x0);
		x1 = ClipRight;
		y1 = y0 + c;
		if ((y0 < ClipTop) && (y1 < ClipTop)) 		return;
		if ((y0 > ClipBottom) && (y1 > ClipBottom)) return;
		}


	if (y0 > y1) {
		temp = y0;
		y0 = y1;
		y1 = temp;
		temp = x0;
		x0 = x1;
		x1 = temp;
		}

	if (y0 < ClipTop) {
		c = (x1 - x0) / (y1 - y0) * (y1 - ClipTop);
		x0 = x1 - c;
		y0 = ClipTop;
		}

	if (y1 > ClipBottom) {
		c = (x1 - x0) / (y1 - y0) * (ClipBottom - y0);
		x1 = x0 + c;
		y1 = ClipBottom;
		}

	Line(x0,y0,x1,y1,color);
}


/*
void MyLine (int x0, int y0, int x1, int y1, int color) {

	int 	x;
	float	dx, dy, y, m;

	dy = y1-y0;
	dx = x1-x0;
	m = dy/dx;
	y=y0;

	for(x=x0; x<=x1; x++) {
		PixelClip(x, y, color);
		y=y+m;
	}
}

void MyLine2 (int x0, int y0, int x1, int y1, int color) {

	int dx, dy,
		incrE, incrNE,
		d, x, y;

	if (x0 == x1)
		VLineClip(x0,y0,y1,color);
	if (y0 == y1)
		HLineClip(x0,x1,y0,color);
	dx = x1-x0;
	dy = y1-y0;
	d = 2*dy-dx;
	incrE = 2*dy;
	incrNE = 2*(dy-dx);
	x = x0;
	y = y0;
	PixelClip(x,y,color);
	while (x<x1) {
		if (d <= 0) {
			d+=incrE;
			x++;
			}
		  else {
			d+=incrNE;
			x++;
			y++;
			}
		PixelClip(x,y,color);
	}
}

*/