include hobbes.inc
include extrn.inc


Prefix MACRO
	  push bp
	  mov  bp,sp
	  push ds
	  push si
	  push di
	  ENDM

Postfix MACRO
	  pop  di
	  pop  si
	  pop  ds
	  mov  sp,bp
      pop  bp
      ret
      ENDM


MOUSE_SAVE_BUFFER  equ 65439

THE_DELAY    equ   4


DATASEG

Public _MouseX, _MouseY, _MPresent, _MouseKey
Public _UserDefCurs1,_UserDefCurs2,_UserDefCurs3,_UserDefCurs4
public _MousePage_Offset

_MouseX       		dw  (?)
_MouseY       		dw  (?)
MHHot         		dw  (?)
MVHot         		dw  (?)
MMaskPtr      		dw  (?)
MouseVisible  		dw  (?)
_MPresent     		dw  (?)
_MouseKey     		dw  (?)
_MKP          		dw  0
oldinfopos    		dw  (?)
_MousePage_Offset 	dw 	0
inter_ok      		dw  0
savedbitmask  		db  (?)
savedmapmask  		db  (?)
top_clip      		dw  (?)
left_clip     		dw  (?)
bottom_clip   		dw  (?)
_Mouse_Top			dw 	(?)
_Mouse_Left			dw 	(?)
_Mouse_Right		dw 	(?)
_Mouse_Bottom		dw 	(?)


StandardHHot  	db 0
StandardVHot  	db 0
StandardCurs  	db 00111111b
				db 00011111b
				db 00001111b
				db 00011111b
				db 00111011b
				db 01110001b
				db 11100000b
				db 11000000b

UpArrowHHot   	db 3
UpArrowVHot   	db 0
UpArrowCurs   	db 00001000b
				db 00011100b
				db 00111110b
				db 01111111b
				db 00001000b
				db 00001000b
				db 00001000b
				db 00001000b


LeftArrowHHot 	db 0
LeftArrowVHot 	db 3
LeftArrowCurs 	db 00001000b
				db 00001100b
				db 00001110b
				db 11111111b
				db 00001110b
				db 00001100b
				db 00001000b
				db 00000000b

CheckMarkHHot 	db 2
CheckMarkVHot 	db 6
CheckMarkCurs 	db 00000000b
				db 10000000b
				db 11000000b
				db 01100000b
				db 00110011b
				db 00011110b
				db 00001100b
				db 00000000b

PointHandHHot 	db 2
PointHandVHot 	db 0
PointHandCurs 	db 00001100b
				db 00001100b
				db 00001100b
				db 10101100b
				db 11111101b
				db 11111111b
				db 11111111b
				db 01111110b

XHHot         	db 3
XVHot         	db 3
XCurs     		db 11000011b
				db 01100110b
				db 00111100b
				db 00011000b
				db 00111100b
				db 01100110b
				db 11000011b
				db 00000000b

PlusHHot      	db 3
PlusVHot      	db 3
PlusCurs      	db 00011000b
				db 00011000b
				db 00011000b
				db 11111111b
				db 11111111b
				db 00011000b
				db 00011000b
				db 00011000b

HourGlassHHot 	db 3
HourGlassVHot 	db 3
HourGlassCurs 	db 11111111b
				db 01000010b
				db 00100100b
				db 00011000b
				db 00011000b
				db 00100100b
				db 01011010b
				db 11111111b

UserDef1HHot  	db 0
UserDef1VHot  	db 0
_UserDefCurs1 	db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b

UserDef2HHot  	db 0
UserDef2VHot  	db 0
_UserDefCurs2 	db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b

UserDef3HHot  	db 0
UserDef3VHot  	db 0
_UserDefCurs3 	db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b

UserDef4HHot  	db 0
UserDef4VHot  	db 0
_UserDefCurs4 	db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b
				db 00000000b


.code

db "Yffud Ekim"


	  Public _MouseInit
_MouseInit proc
ARG X:word,Y:word,Color:byte

; Prefix
		push 	bp
		mov  	bp,sp
		push 	ds
		push 	di
		push 	si

		mov  	ax,@data
		mov  	ds,ax

		mov		ax,_Display_Offset
		mov		_MousePage_Offset,ax
		xor  	ax,ax
		mov  	[_mpresent],ax
		mov  	[MouseVisible],ax
		int  	33h
		cmp  	ax,0
		je   	@@MouseNotInstalled
		mov  	ax,000fh              ; set mickey to pixel ratio
		mov  	cx,8
		mov  	dx,8
		int  	33h
		mov  	ax,1
		mov  	[_mpresent],ax

		mov  	ax,0007h              ; Set min/max x,y boundaries
		xor  	cx,cx
		mov  	dx,_Virtual_Width_Pix
		int  	33h
		mov  	ax,0008h
		xor  	cx,cx
		mov  	dx,_Virtual_Height_Pix
		int  	33h


		mov  	si,OFFSET MMaskPtr
		mov  	ax,OFFSET StandardCurs   ; set mask to mouse
		mov  	ds:[si],ax
		mov  	al,[StandardHHot]
		xor  	ah,ah
		mov  	[MHHot],ax
		mov  	al,[StandardVHot]
		xor  	ah,ah
		mov  	[MVHot],ax

		mov  	cx,[x]                ; set mouse position
		mov  	[_MouseX],cx
		mov  	dx,[y]
		mov  	[_MouseY],dx
		mov  	ax,0004h
		int  	33h

		mov  	ax,0a000h             ; set the color of the mouse
		mov  	es,ax
		mov  	di,MOUSE_SAVE_BUFFER - 4
		mov  	ax,0f00h + MAP_MASK
		mov  	dx,SC_INDEX
		out  	dx,ax
		mov  	al,[color]
		mov  	es:[di],al

		mov  	ax,cs                 ; set up the interrupt vector
		mov  	es,ax
		mov  	dx,OFFSET _MouseCursorDisplay
		mov  	ax,000ch
		mov  	cx,00101011b
		int  	33h

		jmp 	SHORT @@Postfix
@@MouseNotInstalled:
		xor  	ax,ax

@@Postfix:
		pop  	si
		pop  	di
		pop  	ds
		pop  	bp
		ret
_MouseInit endp




;----------------------------------------------------------------------------
; void MouseUnInit(void);

	  Public _MouseUnInit
_MouseUnInit proc

; Prefix
		push 	bp
		mov  	bp,sp
		push 	ds
		push 	di
		push 	si

		mov  	ax,@data
		mov  	ds,ax

		cmp  	[_mpresent],1
		jne  	@@Postfix
		mov  	ax,000ch
		xor  	cx,cx
		mov  	es,cx
		xor  	dx,dx
		int  	33h

@@Postfix:
		pop  	si
		pop  	di
		pop  	ds
		pop  	bp
		ret
_MouseUnInit endp




;----------------------------------------------------------------------------
; void MouseShowCursor(void);

	   Public _MouseShowCursor
_MouseShowCursor proc

		mov  	ax,@data
		mov  	ds,ax

		xor  	ax,ax
		mov  	[inter_ok],ax

		cmp  	[MouseVisible],0
		je   	@@NotTheEnd
		jmp  	@@End

@@NotTheEnd:

	   ; Prefix
		push 	bp
		mov  	bp,sp
		push 	ds
		push 	di
		push 	si

; cld

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov  dx,GC_INDEX                 ;
; mov  ax,00000h+BIT_MASK          ;
; out  dx,ax                       ;
;                                  ;
; mov  dx,SC_INDEX                 ;
; mov  ax,0ff00h + MAP_MASK        ;
; out  dx,ax                       ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
; mov  dx,GC_INDEX
; mov  al,BIT_MASK
; out  dx,al
; inc  dx
; in   al,dx
; mov  [savedbitmask],al
; xor  ax,ax
; out  dx,al
;
;
; mov  dx,SC_INDEX
; mov  al,MAP_MASK
; out  dx,al
; inc  dx
; in   al,dx
; mov  [savedmapmask],al
; mov  al,0ffh
; out  dx,al


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; mov  ax,0A000h
; mov  es,ax

; mov  ax,0003h
; int  33h

;Save current background 3 bytes x 8 rows
;
; Now we need a save buffer pointer and a new mouse position pointer, thus
;  we need the x and y coordinates as well.

 ;cx = horizontal pos
 ;dx = vertical pos


; push cx
;
; mov  ax,SCREEN_WIDTH              ;
; mov  [_mousey],dx                 ; put vertical position in mousey
; mov  bx,dx                        ;
;				   ;
; mov  cx,8                         ; cx = default lines to save
; mov  dx,cx                        ; dx = 8
; add  dx,bx                        ;        + vpos
; sub  dx,[MVHot]                   ;               - vhot
; cmp  dx,240                       ; dx must = vpos + 8 - vhot
; jle  @@Bottom_Not_Clipped         ;
; mov  cx,240                       ;
; sub  cx,bx                        ;
; add  cx,[MVHot]                   ; cx is set here to the number of lines saved at the bottom of the screen
;@@Bottom_Not_Clipped:              ;
; mov  [_Mouse_Bottom],cx             ; move to _Mouse_Bottom the number of lines to save on the bottom
; mov  cx,8                         ;
; sub  bx,[MVHot]                   ; bx is still vpos
; js   @@Above_The_Top              ;
; jmp  SHORT @@Not_Above_The_Top    ;
;@@Above_The_Top:                   ;
; add  cx,[_mousey]                 ;
; sub  cx,[MVHot]                   ;
; xor  bx,bx                        ;
;@@Not_Above_The_Top:               ;
; mul  bx                           ;
; mov  [top_clip],cx                ;
; pop  si                           ; move horizontal pos to si
; mov  [_mousex],si                 ;
; mov  dx,3                         ;
; sub  si,[MHHot]                   ;
; js   @@Off_The_Left               ;
; jmp  SHORT @@Not_Off_The_Left     ;
;@@Off_The_Left:                    ;
; xor  si,si                        ;
; mov  cx,[MHHot]                   ;
; sub  cx,[_mousex]                 ;
; shr  cx,1                         ;
; shr  cx,1                         ;
; inc  cx                           ;
; sub  dx,cx
;@@Not_Off_The_Left:
; mov  [_Mouse_Left],dx    ; _Mouse_Left is equal to the number of bytes needed
; shr  si,1
; shr  si,1
; mov  bx,80   ; save the number of bytes we can write at the right edge of
; sub  bx,si   ;  the screen to account for clipping.
; mov  bh,bl   ;  save it in bh.
; add  si,ax
; add  si,[_MousePage_Offset]
; mov  [oldinfopos],si
;
; mov  di,MOUSE_SAVE_BUFFER
;
; mov  bx,[top_clip]
; cmp  bx,[_Mouse_Bottom]
; jle  @@Mouse_Row_Loop_Save
; mov  bx,[_Mouse_Bottom]
;@@Mouse_Row_Loop_Save:
; mov  cx,[_Mouse_Left]
; rep  movs BYTE PTR es:[di],BYTE PTR es:[si]
; add  si,80
; sub  si,[_Mouse_Left]
; dec  bx
; jnz  @@Mouse_Row_Loop_Save

		inc  	[MouseVisible]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; mov  dx,GC_INDEX
; mov  al,BIT_MASK
; mov  ah,[savedbitmask]
; out  dx,ax
;
; mov  dx,SC_INDEX
; mov  al,MAP_MASK
; mov  ah,[savedmapmask]
; out  dx,ax

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		mov  	ax,2
		mov  	[inter_ok],ax
		mov  	ax,0003h
		int  	33h
		xor  	ax,ax
; mov  cx,[_mousex]
; mov  dx,[_mousey]

		call far ptr _MouseCursorDisplay

		mov  	ax,1
		mov  	[inter_ok],ax

@@Postfix:
		pop  	si
		pop  	di
		pop  	ds
		mov  	sp,bp
		pop  	bp
@@End:
		ret
_MouseShowCursor endp



;----------------------------------------------------------------------------
; void MouseHideCursor(void);
;
	   Public _MouseHideCursor
_MouseHideCursor proc

		mov  	ax,@data
		mov  	ds,ax

		xor  	ax,ax
		mov  	[inter_ok],ax

		cmp  	[MouseVisible],0
		je   	@@End

; Prefix
		push 	bp
		mov  	bp,sp
		push 	ds
		push 	di
		push 	si

		cld
		dec  [MouseVisible]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov  dx,GC_INDEX                 ;
; mov  ax,00000h+BIT_MASK          ;
; out  dx,ax                       ;
;                                  ;
;                                  ;
; mov  dx,SC_INDEX                 ;
; mov  ax,0ff00h + MAP_MASK        ;
; out  dx,ax                       ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		mov  	dx,GC_INDEX
		mov  	al,BIT_MASK
		out  	dx,al
		inc  	dx
		in   	al,dx
		mov  	[savedbitmask],al
		xor  	ax,ax
		out  	dx,al


		mov  	dx,SC_INDEX
		mov  	al,MAP_MASK
		out  	dx,al
		inc  	dx
		in   	al,dx
		mov  	[savedmapmask],al
		mov  	al,0ffh
		out  	dx,al


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;Restore old background 3 bytes x 8 rows
;
; We need a pointer to the save buffer and a pointer to the current mouse
;  position.

		mov  	di,[oldinfopos]

		mov 	ax,0A000h
		mov  	es,ax

		mov 	si,MOUSE_SAVE_BUFFER

		mov  	bx,[_Mouse_Top]
		cmp  	bx,[_Mouse_Bottom]
		jl   	@@Mouse_Row_Loop_Restore
		mov  	bx,[_Mouse_Bottom]
@@Mouse_Row_Loop_Restore:
		mov  	cx,[_Mouse_Left]
		rep  	movs BYTE PTR es:[di],BYTE PTR es:[si]
		add  	di,_Virtual_Width_Addr
		sub  	di,[_Mouse_Left]
		dec  	bx
		jnz  	@@Mouse_Row_Loop_Restore

; mov  dx,GC_INDEX
; mov  ax,0ff00h+BIT_MASK
; out  dx,ax

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		mov  	dx,GC_INDEX
		mov  	al,BIT_MASK
		mov  	ah,[savedbitmask]
		out  	dx,ax

		mov  	dx,SC_INDEX
		mov  	al,MAP_MASK
		mov  	ah,[savedmapmask]
		out  	dx,ax

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		mov  ax,1
		mov  [inter_ok],ax


@@Postfix:
		pop  si
		pop  di
		pop  ds
		mov  sp,bp
		pop  bp
@@End:
		ret
_MouseHideCursor endp




;----------------------------------------------------------------------------
; void MouseCursorDisplay(void);
;
	   Public _MouseCursorDisplay
_MouseCursorDisplay proc

		cli
		push 	bp
		mov  	bp,sp
		push 	es
		push 	ds

		mov  	bx,@data
		mov  	ds,bx
		and  	ax,00101010b
		mov  	[_mousekey],ax
		cmp  	[inter_ok],0
		je   	@@Get_Outta_Here
		cmp  	[MouseVisible],0
		jne  	@@Prefix

@@Get_Outta_Here:
		pop  	ds
		pop  	es
		pop  	bp
		sti
		ret           ; <==== Note that you have a return here too.

@@Prefix:
		mov  [_MouseX],cx
		mov  [_MouseY],dx

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; mov  dx,GC_INDEX                 ;
; mov  ax,00000h+BIT_MASK          ;
; out  dx,ax                       ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		mov  	dx,GC_INDEX
		mov  	al,BIT_MASK
		out  	dx,al
		inc  	dx
		in   	al,dx
		mov  	[savedbitmask],al
		xor  	ax,ax
		out  	dx,al

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		mov  	dx,SC_INDEX
		mov  	al,MAP_MASK
		out  	dx,al
		inc  	dx
		in   	al,dx
		mov  	[savedmapmask],al
		mov  	al,0ffh
		out  	dx,al



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		cld

;Restore old background 3 bytes x 8 rows
;
; We need a pointer to the save buffer and a pointer to the current mouse
;  position.

		mov  	ax,0A000h
		mov  	es,ax
		cmp  	[inter_ok],2
		je   	@@Save_Da_Background
		mov  	di,[oldinfopos]
		mov  	si,MOUSE_SAVE_BUFFER

		mov  	bx,[_Mouse_Top]
		cmp  	bx,[_Mouse_Bottom]
		jl   	@@Mouse_Row_Loop_Restore
		mov  	bx,[_Mouse_Bottom]
@@Mouse_Row_Loop_Restore:
		mov  	cx,[_Mouse_Left]
		rep  	movs BYTE PTR es:[di],BYTE PTR es:[si]
		add  	di,_Virtual_Width_Addr
		sub  	di,[_Mouse_Left]
		dec  	bx
		jnz  	@@Mouse_Row_Loop_Restore

;Save current background 3 bytes x 8 rows
;
; Now we need a save buffer pointer and a new mouse position pointer, thus
;  we need the x and y coordinates as well.

@@Save_Da_Background:
		mov  	ax,_Virtual_Width_Pix
		mov  	bx,[_mousey]
		mov  	cx,8
		mov  	dx,cx
		add  	dx,bx
		sub  	dx,[MVHot]
		cmp  	dx,_Virtual_Width_Pix
		jle  	@@Bottom_Not_Clipped
		mov  	cx,_Virtual_Width_Pix
		sub  	cx,bx
		add  	cx,[MVHot]
@@Bottom_Not_Clipped:
		mov  	[_Mouse_Bottom],cx
		mov  	cx,8
		sub  	bx,[MVHot]
		js   	@@Above_The_Top
		jmp  	SHORT @@Not_Above_The_Top
@@Above_The_Top:
		add  	cx,[_mousey]
		sub  	cx,[MVHot]
		xor  	bx,bx
@@Not_Above_The_Top:
		mul  	bx
		mov  	[_Mouse_Top],cx
		mov  	si,[_mousex]
		mov  	dx,3
		sub  	si,[MHHot]
		js   	@@Off_The_Left
		jmp  	SHORT @@Not_Off_The_Left
@@Off_The_Left:
		xor  	si,si
		mov  	cx,[MHHot]
		sub  	cx,[_mousex]
		shr  	cx,1
		shr  	cx,1
		inc  	cx
		sub  	dx,cx
@@Not_Off_The_Left:
		mov  	[_Mouse_Left],dx    ; _Mouse_Left is equal to the number of bytes needed
		shr  	si,1
		shr  	si,1
		mov  	bx,_Virtual_Width_Addr   ; save the number of bytes we can write at the right edge of
		sub  	bx,si   ;  the screen to account for clipping.
		mov  	bh,bl   ;  save it in bh.
		add  	si,ax
		add  	si,[_MousePage_Offset]
		mov  	[oldinfopos],si

		mov  	dx,si   ; save the x,y position in order to draw the cursor

		mov  	di,MOUSE_SAVE_BUFFER

		mov  	ax,[_Mouse_Top]
		cmp  	ax,[_Mouse_Bottom]
		jle  	@@Mouse_Row_Loop_Save
		mov  	ax,[_Mouse_Bottom]
@@Mouse_Row_Loop_Save:
		mov  	cx,[_Mouse_Left]
		rep  	movs BYTE PTR es:[di],BYTE PTR es:[si]
		add  	si,_Virtual_Width_Addr
		sub  	si,[_Mouse_Left]
		dec  	ax
		jnz  	@@Mouse_Row_Loop_Save

	   ;Draw that mouse cursor!
	   ;
	   ; Ah, here's where it gets good.  We need the x,y coordinates, a pointer to
	   ;  the mouse color info, and a pointer to the mask info.

		mov  	bp,[MMaskPtr]               ; ax = mask manipulation
		add  	bp,8                        ; bx = bl = loop counter. bh = right edge bytes
		mov  	cx,[_Mouse_Top]		  ; cx = cl = shift counter ch = save shift.
		sub  	bp,cx
		cmp  	cx,[_Mouse_Bottom]
		jl   	@@No_Bottom_Clipping_Here
		mov  	cx,[_Mouse_Bottom]
@@No_Bottom_Clipping_Here:
		mov  	bl,cl     ; set up the number of lines to draw according to _Mouse_Top.

						 ; dx = needed for out instructions.
						 ; di \__ Copy from display mem to display mem.
		mov 	di,dx                       ; si /
		mov 	si,MOUSE_SAVE_BUFFER - 4    ; bp = mask offset pointer.
						 ; es = Display mem segment register
						 ; ds = Mask display segment register.
						 ;       Always points to data segment?
		mov  	dx,SC_INDEX                 ;         Yup.  Now it does.
		mov  	al,MAP_MASK                 ;
		out  	dx,al                       ;
		inc  	dx

		mov  	cx,[_mousex]
		add  	cx,8
		sub  	cx,[MHHot]
		and  	cx,00000011b
		mov  	ch,cl

@@Draw_Cursor_Loop:
		mov  	cl,ch
		mov  	al,ds:[bp]
		inc  	bp
		xor  	ah,ah
		shl  	ax,cl


		cmp  	[_Mouse_Left],3
		jne  	@@Continue_1
		out  	dx,al
		movs 	BYTE PTR es:[di],BYTE PTR es:[si]
		dec  	si
		cmp  	bh,1
		jne  	@@Continue_1
		add  	di,79  					;*******************
		jmp		SHORT @@Skip_Here_For_Clipping_Right
@@Continue_1:
		mov  	cl,4
		shr  	ax,cl
		cmp  	[_Mouse_Left],2
		jl   	@@Continue_2
		out  	dx,al
		movs 	BYTE PTR es:[di],BYTE PTR es:[si]
		dec  	si
		cmp  	bh,2
		jne  	@@Continue_2
		add  	di,78					;*******************
		jmp 	SHORT @@Skip_Here_For_Clipping_Right
@@Continue_2:
		mov  	cl,4
		shr  	ax,cl
		out  	dx,al
		movs 	BYTE PTR es:[di],BYTE PTR es:[si]
		dec  	si
		add  	di,_Virtual_Width_Addr
		sub  	di,[_Mouse_Left]

@@Skip_Here_For_Clipping_Right:
		dec  	bl
		jnz  	@@Draw_Cursor_Loop
		mov  	al,0fh
		out  	dx,al

	   ; mov  dx,GC_INDEX
	   ; mov  ax,0ff00h+BIT_MASK
	   ; out  dx,ax

	   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		mov  	dx,GC_INDEX
		mov  	al,BIT_MASK
		mov  	ah,[savedbitmask]
		out  	dx,ax

		mov  	dx,SC_INDEX
		mov  	al,MAP_MASK
		mov  	ah,[savedmapmask]
		out  	dx,ax

	   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

@@Postfix:
		pop  	ds
		pop  	es
		pop  	bp
		sti
		ret
_MouseCursorDisplay endp




;----------------------------------------------------------------------------
; void MouseDelay(void);
;

difference     DW   0

_MouseDelay proc
		Prefix
		mov  [cs:difference],THE_DELAY
		push es
		mov  ax,0040h
		mov  es,ax
		mov  di,006Ch
		mov  ax,[word ptr es:di]
@@Da_Loop:
		mov  dx,[word ptr es:di]
		sub  dx,ax
		cmp  dx,[cs:difference]               ; Mouse Delay
		jl   @@Da_Loop
		pop  es
		Postfix
_MouseDelay endp



;----------------------------------------------------------------------------
; void SetMousePos(int x, int y);

	public _SetMousePos
_SetMousePos proc
ARG  x:word, y:word
		Prefix

		mov  	ax,0004h
		mov  	cx,[x]
		mov  	dx,[y]
		int  	33h
		Postfix
_SetMousePos endp



;----------------------------------------------------------------------------
; void SetMousePort(void);
;
	public  _SetMousePort
_SetMousePort proc
ARG  x1:word, y1:word, x2:word, y2:word

		Prefix
		mov  	ax,0007h
		mov  	cx,x1
		cmp  	cx,0
		jge  	@@x1_ok
		xor  	cx,cx
@@x1_ok:
		mov  	dx,x2
		cmp  	dx,_Virtual_Width_Pix
		jle  	@@x2_ok
		mov  	dx,_Virtual_Width_Pix
@@x2_ok:
		int  	33h
		mov  	ax,0008h
		mov  	cx,y1
		cmp  	cx,0
		jge  	@@y1_ok
		xor  	cx,cx
@@y1_ok:
		mov  	dx,y2
		cmp  	dx,_Virtual_Height_Pix
		jle  	@@y2_ok
		mov  	dx,_Virtual_Height_Pix
@@y2_ok:
		int  	33h
		Postfix
_SetMousePort endp




;----------------------------------------------------------------------------
; void MouseNonePressed(void);
;
	public _MouseNonePressed
_MouseNonePressed proc
		Prefix
		cmp  	_MKP,0
		je   	@@First_Jump
		call 	_mousedelay

@@First_Jump:
		xor  	ax,ax
		mov  	[_MKP],ax
		cmp  	[_mousekey],0
		jne  	@@NOT
		mov  	ax,1
		mov  	_MKP,ax
		jmp  	SHORT @@DaEnd
@@NOT:
		mov  	ax,0
@@DaEnd:
		Postfix
_MouseNonePressed endp




;----------------------------------------------------------------------------
; void _MouseLeftPressed(void);
;
	public _MouseLeftPressed
_MouseLeftPressed proc
		Prefix
		cmp  	_MKP,0
		je   	@@First_Jump
		call 	_MouseDelay

@@First_Jump:
		xor  	ax,ax
		mov  	[_MKP],ax
		cmp  	[_mousekey],2
		jne  	@@NOT
		mov  	ax,1
		mov  	_MKP,ax
		jmp  	SHORT @@DaEnd
@@NOT:
		mov  	ax,0
@@DaEnd:
		Postfix
_MouseLeftPressed endp



;----------------------------------------------------------------------------
; void MouseRightPressed(void);
;
	public _MouseRightPressed
_MouseRightPressed proc

		Prefix
		cmp  	_MKP,0
		je   	@@First_Jump
		call 	_mousedelay

@@First_Jump:
		xor  	ax,ax
		mov  	[_MKP],ax
		cmp  	[_mousekey],8
		jne  	@@NOT
		mov  	ax,1
		mov  	_MKP,ax
		jmp  	SHORT @@DaEnd
@@NOT:
		mov  ax,0
@@DaEnd:
		Postfix
_MouseRightPressed endp



;----------------------------------------------------------------------------
; void MouseBothPressed(void);
;
	public _MouseBothPressed
_MouseBothPressed proc
		Prefix

		cmp  	_MKP,0
		je   	@@First_Jump
		call 	_mousedelay

@@First_Jump:
		xor  	ax,ax
		mov  	[_MKP],ax
		cmp  	[_mousekey],10
		jne  	@@NOT
		mov  	ax,1
		mov  	_MKP,ax
		jmp  	SHORT @@DaEnd
@@NOT:
		mov  ax,0
@@DaEnd:
		Postfix
_MouseBothPressed endp



;----------------------------------------------------------------------------
; void MouseCenterPressed(void);
;
	public _MouseCenterPressed
_MouseCenterPressed proc

		Prefix
		cmp  	_MKP,0
		je   	@@First_Jump
		call 	_mousedelay

@@First_Jump:
		xor  	ax,ax
		mov  	[_MKP],ax
		cmp  	[_mousekey],32
		jne  	@@NOT
		mov  	ax,1
		mov  	_MKP,ax
		jmp  	SHORT @@DaEnd
@@NOT:
		mov  ax,0
@@DaEnd:
		Postfix
_MouseCenterPressed endp


;----------------------------------------------------------------------------
; void MouseCenterLeftPressed(void);

	public _MouseCenterLeftPressed
_MouseCenterLeftPressed proc

		Prefix

		cmp  	_MKP,0
		je   	@@First_Jump
		call 	_mousedelay

@@First_Jump:
		xor  	ax,ax
		mov  	[_MKP],ax
		cmp  	[_mousekey],34
		jne  	@@NOT
		mov  	ax,1
		mov  	_MKP,ax
		jmp  	SHORT @@DaEnd
@@NOT:
		mov  ax,0
@@DaEnd:
		Postfix
_MouseCenterLeftPressed endp



;----------------------------------------------------------------------------
; int MouseCenterRightPressed(void);
;
	public _MouseCenterRightPressed
_MouseCenterRightPressed proc
		Prefix

		cmp  	_MKP,0
		je   	@@First_Jump
		call 	_mousedelay

@@First_Jump:
		xor  	ax,ax
		mov  	[_MKP],ax
		cmp  	[_mousekey],40
		jne  	@@NOT
		mov  	ax,1
		mov  	_MKP,ax
		jmp  	SHORT @@DaEnd
@@NOT:
		mov  	ax,0
@@DaEnd:
		Postfix
_MouseCenterRightPressed endp


;----------------------------------------------------------------------------
; int MouseAllPressed(void);

	public _MouseAllPressed
_MouseAllPressed proc

		Prefix
		cmp  	_MKP,0
		je   	@@First_Jump
		call 	_mousedelay

@@First_Jump:
		xor  	ax,ax
		mov  	[_MKP],ax
		cmp  	[_mousekey],42
		jne  	@@NOT
		mov  	ax,1
		mov  	_MKP,ax
		jmp  	SHORT @@DaEnd
@@NOT:
		mov  	ax,0
@@DaEnd:
		Postfix
_MouseAllPressed endp



;----------------------------------------------------------------------------
; void MouseSetCursorShape(void);

	 Public _MouseSetCursorShape
_MouseSetCursorShape proc
ARG  curstype:word
;Prefix
		push 	bp
		mov  	bp,sp
		push 	ds
		push 	di
		push 	si

		mov  	ax,@data
		mov  	ds,ax

		call 	far ptr _MouseHideCursor

		mov  	ax,[curstype]
		mov  	dx,10
		mul  	dx
		mov  	bx,OFFSET StandardCurs
		add  	ax,bx
		mov  	di,ax

		mov  	si,OFFSET MMaskPtr
		mov  	ds:[si],ax
		mov  	ax,SEG StandardCurs
		mov  	es,ax

		add  	di,8
		mov  	al,es:[di]
		xor  	ah,ah
		mov  	[MHHot],ax
		inc  	di
		mov  	al,es:[di]
		mov  	[MVHot],ax

		call 	far ptr _MouseShowCursor


		mov  	ax,01h
		mov  	cx,[_mousex]
		mov  	dx,[_mousey]
		call 	far ptr _MouseCursorDisplay

	   ;Postfix
		pop  	si
		pop  	di
		pop  	ds
		pop  	bp
		ret
_MouseSetCursorShape endp



;----------------------------------------------------------------------------
; void MouseSetPage(VRAM_PTR mpageoffset);

	Public _MouseSetPage
_MouseSetPage proc far
ARG  mpageoffset:word
		push 	bp
		mov  	bp,sp
		push 	ds

		mov  	ax,@data
		mov  	ds,ax

		mov  	ax,[mpageoffset]
		mov  	[_MousePage_Offset],ax

		pop  	ds
		pop  	bp
		ret
_MouseSetPage endp

;----------------------------------------------------------------------------

 db "Mike Duffy's Xmouse Library. Version 1.2 Copyright 1992 Mike Duffy."

;----------------------------------------------------------------------------
End
