include hobbes.inc
include extrn.inc


.CODE

;----------------------------------------------------------------------------
; void Set1Palette( int entry,
;                   char red_level, char green_level, char blue_level )
;

		public  _Set1Palette
_Set1Palette proc
ARG	ENTRY:WORD, R_LVL:BYTE, G_LVL:BYTE, B_LVL:BYTE
		push    bp
		mov     bp,sp
		push	ds
		mov		ax,@data
		mov		ds,ax
;        mov     dx,03dah
;pal1_retr1:
;        in      al,dx           ; wait for scan to reach top of screen
;        test    al,8
;        jnz     pal1_retr1
;pal1_retr2:
;        in      al,dx           ; wait for scan to reach bottom of screen
;        test    al,8
;        jz      pal1_retr2

		mov     dx,03c8h                ; set up for a blitz-write
		mov     ax,ENTRY                ; from this register
	cli				; critical section:  no ints
	out	dx,al			; starting register
	inc	dx			; set up to update colors
		mov     al,R_LVL
		out     dx,al
		mov     al,G_LVL
		out     dx,al
		mov     al,B_LVL
		out     dx,al                   ; whap!  Zango!  They're updated!
	sti				; end of critical section
		pop		ds
		pop     bp
        ret
_Set1Palette  endp



;----------------------------------------------------------------------------
; void Set256Palette( unsigned char palette[256][3] )
;
		public  _Set256Palette
_Set256Palette proc
ARG	PSA:WORD
		push    bp
		mov     bp,sp
		push    ds
		push    si
        mov     ds,word ptr (PSA + 2)
        mov     si,PSA
		mov     cx,768
        mov     dx,03dah
pal_retr1:
		in      al,dx           ; wait for scan to reach top of screen
        test    al,8
		jnz     pal_retr1
pal_retr2:
		in      al,dx           ; wait for scan to reach bottom of screen
		test    al,8
		jz      pal_retr2

        mov     dx,03c8h                ; set up for a blitz-write
        mov     ax,0                    ; from this register
	cli				; critical section:  no ints
	out	dx,al		; starting register
	inc	dx			; set up to update colors
	rep	outsb		; whap!  Zango!  They're updated!
	sti				; end of critical section

        pop     si
		pop     ds
        pop     bp
        ret
_Set256Palette  endp


;----------------------------------------------------------------------------
; void Get256Palette( unsigned char palette[256][3] )
;
		public  _Get256Palette
_Get256Palette proc
ARG PSA:WORD
        push    bp
        mov     bp,sp
        mov     es,word ptr (PSA + 2)   ; target palette segment
        mov     dx,PSA                  ; target palette offset
		mov     cx,0ffh                 ; get all 256 entries
        mov     bx,0                    ; start with the first entry
        mov     ax,1017h                ; read a block of dac registers
		int     10h                     ; do it
		pop     bp
		ret
_Get256Palette  endp



;----------------------------------------------------------------------------
;
; VGA Palette fading code by Eirik Milch Pedersen <thaco@solan.unit.no>
; Only for 186 and better with VGA
;
.186
_VGA_fadeout proc C uses si di es ds, steps:WORD, pp1:DWORD, pp2:DWORD
public _VGA_fadeout
	  mov 	bx,steps

out_loop1:
	  mov 	cx,768
	  les 	di,pp1
	  lds 	si,pp2
	  push 	si

out_loop2:
	  xor 	ah,ah
	  mov 	al,[es:di]
;  shr al,1
;  shr al,1	; normalize 8 bit RGB to 6 bits
	  mul 	bx
	  div 	steps
	  mov 	[ds:si],al
	  inc 	di
	  inc 	si
	  loop 	out_loop2

	  mov 	dx,3DAh
retraceout_loop1:
	  in 	al,dx
	  and 	al,08h
	  jnz 	retraceout_loop1
retraceout_loop2:
	  in 	al,dx
	  and 	al,08h
	  jz 	retraceout_loop2

	  pop si

	  mov 	dx,3C8h
	  xor 	al,al
	  out 	dx,al
	  mov 	cx,768
	  mov 	dx,3C9h
	  cld
	  rep outsb

	  dec 	bx
	  jnl 	out_loop1

	  ret
_VGA_fadeout endp


;----------------------------------------------------------------------------

_VGA_fadein proc c uses si di es ds, steps:WORD, pp1:DWORD, pp2:DWORD
public _VGA_fadein
	  mov 	bx,0
in_loop1:
	  mov 	cx,768
	  les 	di,pp1
	  lds 	si,pp2
	  push 	si

in_loop2:
	  xor 	ah,ah
	  mov 	al,[es:di]
	  mul 	bx
	  div 	steps
	  mov 	[ds:si],al
	  inc 	di
	  inc 	si
	  loop 	in_loop2

	  mov 	dx,3DAh
retracein_loop1:
	  in 	al,dx
	  and 	al,08h
	  jnz 	retracein_loop1
retracein_loop2:
	  in 	al,dx
	  and 	al,08h
	  jz 	retracein_loop2

	  pop	 si

	  mov 	dx,3C8h
	  xor 	al,al
	  out 	dx,al
	  mov 	cx,768
	  mov 	dx,3C9h
	  cld
	  rep 	outsb

	  inc 	bx
	  cmp 	bx,steps
	  jng 	in_loop1
	  ret
_VGA_fadein endp

;----------------------------------------------------------------------------
END