include hobbes.inc
include extrn.inc

public  _PixelClip
public  _Pixel
public  _PixelSwap
public  _PixelROP
public  _ReadPixel


.CODE
;----------------------------------------------------------------------------
; void PixelClip	(int X, int Y, COLOR)
; void Pixel		(int X, int Y, COLOR)
; COLOR PixelSwap	(int X, int Y, COLOR)
;

_PixelClip proc X:WORD, Y:WORD, COLOR:WORD
		push    bp
		mov     bp,sp
		push    ds
		mov     ax,@data
		mov     ds,ax
		mov     ax,X
		cmp     ax,_ClipLeft
		jl      @@pc_exit
		cmp     ax,_ClipRight
		jg      @@pc_exit
		mov     ax,Y
		cmp     ax,_ClipTop
		jl      @@pc_exit
		cmp     ax,_ClipBottom
		jg      @@pc_exit
		jmp     short pc_okay
@@pc_exit:
		pop     ds
		pop     bp
		ret
_PixelClip      endp

_Pixel proc
		push    bp
		mov     bp,sp
		push    ds
		mov     ax,@data
		mov     ds,ax
pc_okay:
		mov     es,_ModeX_Segment     ; put video segment in ES

		mov     bx,Y
		shl     bx,1
		mov     bx,word ptr _RowOffset[bx]
		add		bx,_Display_Offset
		mov     ax,X
		mov     cl,al           ; prepare CL to compute plane
		shr     ax,2            ; X/4 = offset of pixel in scan line
		add     bx,ax           ; final offset of pixel in page

		and     cl,011b         ; CL = pixel's plane
		mov     ax,1100h+MAP_MASK ; AL = index in SC of Map Mask reg
		shl     ah,cl           ; set only the bit for the pixel's plane to 1
		mov     dx,SC_INDEX     ; set the Map Mask to enable only
		out     dx,ax           ;   the pixel's plane

		mov     al,byte ptr COLOR
		mov     es:[bx],al      ; draw the pixel in the desired color

		pop     ds
		pop     bp
		ret
_Pixel          endp

_PixelSwap      proc
		push    bp
		mov     bp,sp
		push    ds
		mov     ax,@data
		mov     ds,ax
		mov     es,_ModeX_Segment     ; put video segment in ES

		mov     bx,Y
		shl     bx,1
		mov     bx,word ptr _RowOffset[bx]
		mov     ax,X
		shr     ax,2            ; X/4 = offset of pixel in scan line
		add     bx,ax           ; final offset of pixel in page

		mov     cl,byte ptr X
		and     cl,011b         ; CL = pixel's plane
		mov     ah,cl
		mov     al,READ_MAP
		mov     dx,GC_INDEX
		out     dx,ax
		mov     ax,0100h+MAP_MASK ; AL = index in SC of Map Mask reg
		shl     ah,cl           ; set only the bit for the pixel's plane to 1
		mov     dx,SC_INDEX     ; set the Map Mask to enable only
		out     dx,ax           ;   the pixel's plane

		mov     al,byte ptr COLOR
		xchg    es:[bx],al      ; draw the pixel in the desired color

		pop     ds
		pop     bp
		ret
_PixelSwap      endp



;----------------------------------------------------------------------------
;    COLOR ReadPixel(int X, int Y);

_ReadPixel proc X:WORD, Y:WORD
		push    bp
		mov     bp,sp
		push	ds
		mov		ax,@data
		mov		ds,ax

;		mov     ax,_Virtual_Width
;		mul     Y  ;offset of pixel's scan line in page
		mov		di,Y
		shl		di,1
		mov		ax,word ptr _RowOffset[di]
		mov     bx,X
		shr     bx,1
		shr     bx,1    ;X/4 = offset of pixel in scan line
		add     bx,ax   ;offset of pixel in page
		add     bx,_Display_Offset ;offset of pixel in display memory
		mov     ax,_ModeX_Segment
		mov     es,ax   ;point ES:BX to the pixel's address

		mov     ah,byte ptr X
		and     ah,011b ;AH = pixel's plane
		mov     al,READ_MAP ;AL = index in GC of the Read Map reg
		mov     dx,GC_INDEX ;set the Read Map to read the pixel's
		out     dx,ax       ; plane

		mov     al,es:[bx] ;read the pixel's color
		sub     ah,ah   ;convert it to an unsigned int

		pop		ds
		pop     bp
		ret
_ReadPixel     endp


;----------------------------------------------------------------------------
; void PixelROP(int x, int y, COLOR, ROP);
;
		public  _PixelROP
_PixelROP proc far
ARG posX, posY, COLOR, ROP
		push    bp
		mov     bp,sp
		push	ds
		mov		ax,@data
		mov		ds,ax

		mov     ax,_Virtual_Width_Addr
		mul     posY  ;offset of pixel's scan line in page
		mov     bx,posX
		shr     bx,1
		shr     bx,1    ;X/4 = offset of pixel in scan line
		add     bx,ax   ;offset of pixel in page
		add     bx,_Draw_Offset ;offset of pixel in display memory
		mov     ax,_ModeX_Segment
		mov     es,ax   ;point ES:BX to the pixel's address

		mov     cl,byte ptr posX
		and     cl,011b ;CL = pixel's plane
		mov     ax,0100h + MAP_MASK ;AL = index in SC of Map Mask reg
		shl     ah,cl   ;set only the bit for the pixel's plane to 1
		mov     dx,SC_INDEX ;set the Map Mask to enable only the
		out     dx,ax       ; pixel's plane

		;select the Function
		mov		al,FUN_SELECT
		mov		ah,byte ptr ROP
		mov     dx,GC_INDEX
		out     dx,ax

		;prime the latches
		mov     ah,byte ptr X
		and     ah,011b ;AH = pixel's plane
		mov     al,READ_MAP ;AL = index in GC of the Read Map reg
;		mov     dx,GC_INDEX ;set the Read Map to read the pixel's
		out     dx,ax       ; plane
		mov     al,es:[bx] ;read the pixel's color

		mov     al,byte ptr COLOR
		mov     es:[bx],al ;draw the pixel in the desired color

		;reset the function to PUT
		mov		al,FUN_SELECT
		xor		ah,ah
;		mov		ah,0		;PUT
;		mov     dx,GC_INDEX
		out     dx,ax

		pop		ds
		pop     bp
		ret
_PixelROP endp


END
