#include "hobbes.h"

void Rectangle(int x0, int y0, int x1, int y1, COLOR c) {
	HLine(x0, x1, y0, c);
	HLine(x0, x1, y1, c);
	y0++; y1--;
	VLine(x0, y0, y1, c);
	VLine(x1, y0, y1, c);
}

void RectangleClip(int x0, int y0, int x1, int y1, COLOR c) {
	HLineClip(x0, x1, y0, c);
	HLineClip(x0, x1, y1, c);
	y0++; y1--;
	VLineClip(x0, y0, y1, c);
	VLineClip(x1, y0, y1, c);
}

void RectanglePattern(int x0, int y0, int x1, int y1, PATTERN p) {
	HLinePattern(x0, x1, y0, p);
	HLinePattern(x0, x1, y1, p);
	y0++; y1--;
	VLinePattern(x0, y0, y1, p);
	VLinePattern(x1, y0, y1, p);
}

void RectanglePatternClip(int x0, int y0, int x1, int y1, PATTERN p) {
	HLinePatternClip(x0, x1, y0, p);
	HLinePatternClip(x0, x1, y1, p);
	y0++; y1--;
	VLinePatternClip(x0, y0, y1, p);
	VLinePatternClip(x1, y0, y1, p);
}

