/////////////////////////////////////////////////////////////////////////////
//     FILE: DRAW.CPP
// Image editor application for GRAPH.LIB and IO.LIB
/////////////////////////////////////////////////////////////////////////////

#include <mio.h>
#include <mgr.h>
#include <mmulle.h>
#include <mevent.h>
#include <mwin.h>
#include <mparent.h>
#include <mcontrol.h>
#include "draw.h"

/*--------------------------------------*/
 RECT CanvasArea    (6,21,250,150);
 RECT ColorsArea    (5,155,165,195);
 RECT HeaderArea    (5,15,250,150);
 RECT NewButton     (255,20,315,30);
 RECT LoadButton    (255,35,315,45);
 RECT SaveButton    (255,50,315,60);
 RECT SizeButton    (255,65,315,75);
 RECT QuitButton    (255,80,315,90);
 RECT DrawingButton (255,95,315,105);
 RECT FillButton    (255,110,315,120);
 RECT EraseButton   (255,125,315,135);
 RECT MagnifyButton (255,140,315,150);
 RECT ScrollUButton (275,155,295,174);
 RECT ScrollDButton (275,176,295,195);
 RECT ScrollRButton (255,155,270,195);
 RECT ScrollLButton (300,155,315,195);
/*--------------------------------------*/

/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/
 int               main ()
/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/
{
    initgraph();
    Initialize();
    root.Realize();
    root.Run();
    closegraph();
    return (0);
}

/********************************************/
 void           Initialize (void)
/********************************************/
{
MULLE datafile;
Canvas * DrawSpace;
MButton * newButton;
MCMap * colMap;

    DrawSpace = new Canvas;
    newButton = new MButton (NewButton, "New", NEWB_HANDLE);
    newButton->SetUserHandler (NewPixmap);
    newButton = new MButton (LoadButton, "Load", LOADB_HANDLE);
    newButton->SetUserHandler (LoadPixmap);
    newButton = new MButton (SaveButton, "Save", SAVEB_HANDLE);
    newButton->SetUserHandler (SavePixmap);
    newButton = new MButton (SizeButton, "Resize", SIZEB_HANDLE);
    newButton->SetUserHandler (ResizePixmap);
    newButton = new MButton (QuitButton, "Quit", QUITB_HANDLE);
    newButton->SetUserHandler (QuitApp);
    newButton = new MButton (DrawingButton, "Draw", DRAWB_HANDLE);
    newButton->SetUserHandler (LoadDraw);
    newButton = new MButton (FillButton, "Fill", FILLB_HANDLE);
    newButton->SetUserHandler (LoadFill);
    newButton = new MButton (EraseButton, "Erase", ERASEB_HANDLE);
    newButton->SetUserHandler (LoadErase);
    newButton = new MButton (MagnifyButton, "Magnify", MAGNIFYB_HANDLE);
    newButton->SetUserHandler (LoadMagnify);
    newButton = new MButton (ScrollUButton, "/\\", SCROLLBU_HANDLE);
    newButton->SetUserHandler (ScrollPixmapUp);
    newButton = new MButton (ScrollDButton, "\\/", SCROLLBD_HANDLE);
    newButton->SetUserHandler (ScrollPixmapDown);
    newButton = new MButton (ScrollRButton, "<", SCROLLBL_HANDLE);
    newButton->SetUserHandler (ScrollPixmapLeft);
    newButton = new MButton (ScrollLButton, ">", SCROLLBR_HANDLE);
    newButton->SetUserHandler (ScrollPixmapRight);
    colMap = new MCMap (ColorsArea, 5, 5, COLORS_HANDLE);
    FinishSetup (HROOT);

    datafile.SetMainFile ("draw.dat");
    mouse.Load ("draw.dat", datafile.GetOffset ("arrow.cur"));
    gr.font.Load ("draw.dat", datafile.GetOffset ("default.fnt"));
}

/********************************************/
       Canvas :: Canvas (void)
/********************************************/
: MScGrid (CanvasArea, 1, 1, CANVAS_HANDLE)
{
    memset (color, 0x00, N_COLOR_TYPES);
    pixmap = new IMAGE (MAXX, MAXY, NULL);
    pixmap->Clear();
    filename.Resize (13);
    filename.Clear();
    ResizeWorld (MAXX, MAXY);
    mode = DRAWING;
}

/********************************************/
 WORD Canvas :: Handler
/********************************************/
(EVENT event)
{
static int oldx,oldy;
int status = EVENT_NOT_USED;

    if ((event->button & leftButton) && (IsInside (box, event->xpos, event->ypos)))
    {
       mouse.Hide();
       push_DC();
       setviewport (box);

       // First draw on screen
       if (CellLength == 1)
       {
	  switch (mode){
	     case DRAWING:
		  if (oldx != event->xpos || oldy != event->ypos)
		     line (oldx,oldy, event->xpos,event->ypos);
		  else
		     putpixel (event->xpos,event->ypos);
		  break;
	     case FILLING:
		  floodfill (event->xpos, event->ypos);
		  break;
	     case ERASING:
		  bar (event->xpos, event->ypos, event->xpos + 10, event->ypos + 10);
		  break;
	     case MAGNIFYING:
		  if (CellLength == 1)
		  {
		     SetCellSize (5,5);
		     SetSpeed (5);
		  }
		  CreateEvent (REFRESH_WINDOW, 0, NULL, 0L, CANVAS_HANDLE);
		  break;
	  }

	  // Now draw to pixmap

	  setdpy (pixmap->GetBitmap(), pixmap->GetLength(), pixmap->GetWidth());
	  switch (mode){
	     case DRAWING:
		  if (oldx != event->xpos || oldy != event->ypos)
		     line (oldx - box.left + vxpos,
			   oldy - box.top + vypos,
			   event->xpos - box.left + vxpos,
			   event->ypos - box.top + vypos);
		  else
		     putpixel (event->xpos - box.left + vxpos,
			       event->ypos - box.top + vypos);
		  break;
	     case FILLING:
		  floodfill ((event->xpos - box.left) + vxpos,
			     (event->ypos - box.top) + vypos);
		  break;
	     case ERASING:
		  bar (event->xpos - box.left + vxpos,
		       event->ypos - box.top + vypos,
		       event->xpos - box.left + vxpos + 10,
		       event->ypos - box.top + vypos + 10);
		  break;
	  }
       }
       else
       {
	  switch (mode){
	     case DRAWING:
		  push_DC();
		  setdpy (pixmap->GetBitmap(), pixmap->GetLength(), pixmap->GetWidth());
		  putpixel ((event->xpos - box.left + vxpos) / CellLength,
			    (event->ypos - box.top + vypos) / CellWidth);
		  pop_DC();
		  Draw ((event->xpos - box.left + vxpos) / CellLength,
			(event->ypos - box.top + vypos) / CellWidth);
		  break;
	     case MAGNIFYING:
		  SetCellSize (1,1);
		  SetSpeed (3);
		  CreateEvent (REFRESH_WINDOW, 0, NULL, 0L, CANVAS_HANDLE);
		  break;
	  }
       }

       pop_DC();
       mouse.RescanBackgr();
       mouse.Show();
       status = EVENT_USED;
    }
    else
       status = MWindow :: Handler (event);

    oldx = event->xpos;
    oldy = event->ypos;

    return (status);
}

/********************************************/
 void Canvas :: Draw
/********************************************/
(int cx, int cy)
{
    setfillstyle (SOLID_FILL, *(BYTE*)(pixmap->GetBitmap() + (cy * pixmap->GetLength() + cx)));
    bar (box.left - vxpos + cx * CellLength,
	 box.top - vypos + cy * CellWidth,
	 box.left - vxpos + (cx + 1) * CellLength - 1,
	 box.top - vypos + (cy + 1) * CellWidth - 1);
}

/********************************************/
 void Canvas :: Draw (void)
/********************************************/
{
POINT TopLeft;
int x,y;
    mouse.Hide();
    push_DC();
    setviewport (box);
    if (CellLength == 1 && CellWidth == 1)
       pixmap->Put (box.left - vxpos, box.top - vypos);
    else
    {
       TopLeftCell (TopLeft);
       for (y = 0; y < GetVisibleWidth(); ++ y)
	  for (x = 0; x < GetVisibleLength(); ++ x)
             Draw (x + TopLeft.x, y + TopLeft.y);
    }
    setcolor (15);
    setviewport (box.left - 2, box.top - 2, box.right + 2, box.bottom + 2);
    rectangle (box.left - 1, box.top - 1, box.right, box.bottom);
    pop_DC();
    mouse.RescanBackgr();
    mouse.Show();
}
