
#define DRAWING                   1           /*********************/
#define FILLING                   2           /*                   */
#define ERASING                   3           /*     M O D E S     */
#define MAGNIFYING                4           /*                   */
#define ACCEPT                    7           /*                   */
#define CANCEL                    8           /*********************/

#define AREAS                  0x01
#define CONTROLS               0x02
#define INDICATORS             0x04
#define BACKGROUND             0x08
#define CLEAR_DRAW_AREA        0x10
#define EVERYTHING             0xFF

#define EN_SIZE_HOR     64
#define EN_SIZE_VERT    30

#define CANVAS_HANDLE          0x1001
#define COLORS_HANDLE          0x1002
#define HEADER_HANDLE          0x1003
#define NEWB_HANDLE            0x1004
#define LOADB_HANDLE           0x1005
#define SAVEB_HANDLE           0x1006
#define SIZEB_HANDLE           0x1007
#define QUITB_HANDLE           0x1008
#define DRAWB_HANDLE           0x1009
#define FILLB_HANDLE           0x100A
#define ERASEB_HANDLE          0x100B
#define MAGNIFYB_HANDLE        0x100C
#define SCROLLBU_HANDLE        0x1010
#define SCROLLBD_HANDLE        0x1011
#define SCROLLBL_HANDLE        0x1012
#define SCROLLBR_HANDLE        0x1013

/*-----------------------------------------------------------*/
  void           Initialize (void);
  WORD           NewPixmap (...);
  WORD           LoadPixmap (...);
  WORD           SavePixmap (...);
  WORD           ResizePixmap (...);
  WORD           QuitApp (...);
  WORD           LoadDraw (...);
  WORD           LoadFill (...);
  WORD           LoadErase (...);
  WORD           LoadMagnify (...);
  WORD           ScrollPixmapUp (...);
  WORD           ScrollPixmapDown (...);
  WORD           ScrollPixmapLeft (...);
  WORD           ScrollPixmapRight (...);
  void           AskFilename (BYTE * Buffer);
  void           AskSize (WORD * length, WORD * width);
/*-----------------------------------------------------------*/

class Canvas : public MScGrid {
protected:
    cArray                   filename;
    IMAGE *                  pixmap;
    int                      mode;
public:
			     Canvas (void);
    virtual WORD             Handler (EVENT event);
    virtual inline void      Draw (void);
    virtual void             Draw (int cx, int cy);
    friend WORD              SetFilename (...);
    friend WORD              SetPixmapLength (...);
    friend WORD              SetPixmapWidth (...);
    friend WORD              NewPixmap (...);
    friend WORD              LoadPixmap (...);
    friend WORD              SavePixmap (...);
    friend WORD              ResizePixmap (...);
    friend WORD              ScrollPixmapUp (...);
    friend WORD              ScrollPixmapDown (...);
    friend WORD              ScrollPixmapLeft (...);
    friend WORD              ScrollPixmapRight (...);
    friend WORD              QuitApp (...);
    friend WORD              LoadDraw (...);
    friend WORD              LoadFill (...);
    friend WORD              LoadErase (...);
    friend WORD              LoadMagnify (...);
			    ~Canvas (void);
};

