
#ifndef __MCOMPLEX_H
#define __MCOMPLEX_H

#include <math.h>

#define COMPLEX_ID           0x010A

typedef struct tagFPOINT{
    float x;
    float y;
}FPOINT;

class Complex : public MObject {
public:
    float                    real;
    float                    imag;
public:
			     Complex (void);
			     Complex (float Real, float Imag);
    Complex&                 operator= (const Complex& number);
    Complex&                 operator= (const FPOINT& number);
    Complex&                 operator+ (const Complex& number);
    Complex&                 operator- (const Complex& number);
    friend Complex&          operator+ (const Complex& num1, const Complex& num2);
    Complex&                 operator* (const Complex& number);
    Complex&                 operator* (float number);
    Complex&                 operator/ (const Complex& number);
    float                    Magnitude (void);
    void	             Normalize (void);
    friend Complex&          sin (Complex&);
    friend Complex&          cos (Complex&);
    virtual inline classType isA (void) {return (COMPLEX_ID);};
			    ~Complex (void);
};

#endif
