////////////////////////////////////////////////////////////////////////////
// MEVENT.H
//
// header file for MEvent.
////////////////////////////////////////////////////////////////////////////

#ifndef __MEVENT_H
#define __MEVENT_H

#define Nothing              0x00
#define KeyPressed           0x01
#define MouseMoved           0x02
#define ButtonPress          0x04
#define ButtonRelease        0x08

#define HNUL                    0
#define MAX_EVENTS             50

#define MEVENT_ID               0x010B

class MEvent : public MObject {
public:
    WORD          dest;    // Handle of reciever, HNUL if for all
    WORD          type;
    int           xpos;
    int           ypos;
#ifdef __MMOUSE_H
    buttonType    button;
#endif
    WORD          key;
    WORD          dSize;
    void *        data;
    LONG          value;
public:
    virtual inline classType isA (void) {return (MEVENT_ID);};
};

typedef MEvent *             EVENT;

///////////////////////////////// Prototypes /////////////////////////////////
 EVENT        GetEvent (void);
 void         WaitEvent (EVENT event);
 void         CreateEvent (WORD AType, WORD TDSize,
			   void * AData, LONG AValue, WORD ADest = 0);
 void         FlushEvents (void); 
//////////////////////////////////////////////////////////////////////////////

#endif
