
#ifndef __MFONTS_H
#define __MFONTS_H

#define NOL              256      // Number of letters
#define ID_STR_LEN        16
#define ID_STRING           "Bitmap font file\x0"

#define MFONT_ID           0x010C

class MFont : public Atom {
protected:
    BYTE                     Filename [MAX_FILE_NAME];
public:
    BYTE                     length;
    BYTE                     width;
public:
		             MFont (void);
    virtual int              PrintCharacter (int x,int y,int ascii);
    virtual int              PrintString (int x,int y,char *string);
    virtual void             LoadDirect (int fp);
    virtual void             SaveDirect (int fp);
    virtual void             ActivatePoint (WORD letter, WORD xpos, WORD ypos);
    virtual void             DeactivatePoint (WORD letter, WORD xpos, WORD ypos);
    virtual inline classType isA (void) {return (MFONT_ID);};
    virtual void             TogglePoint (WORD letter, WORD xpos, WORD ypos);
    virtual BOOL             ReadPoint (WORD letter, WORD xpos, WORD ypos);
    virtual void             Resize (WORD len, WORD wid);
    inline LPSTR             GetFilename (void) { return (Filename);};
		            ~MFont (void);
};
typedef MFont FONT;

#endif
