
#ifndef __MMEM_H
#define __MMEM_H

#include <dos.h>
#include <alloc.h>
#include <mmemutil.h>

#define ATOM_ID              0x0113

typedef enum {
    GetFrom,
    PutOn
} WAY;

class Atom : public MObject, public MFileOp {
protected:
    SIZE                     size;
    SIZE                     elSize;
    WORD                     nElem;
    void *                   mem;
public:
			     Atom (void);
			     Atom (const Atom& atom);
			     Atom (WORD n_elem, SIZE n_elSize = 1);
    virtual void             Clear (void);
    virtual void             Fill (void *sample);
    virtual inline WORD      GetMaxElem (void);
    virtual inline classType isA (void) {return (ATOM_ID);};
    virtual inline void      Move (WAY Way, WORD Offset, PTR Where, SIZE HowMuch);
    virtual inline void      Move (WAY Way, WORD Offset, PTR Where, SIZE HowMany, WORD OfHowMuch, WORD Skip = 0, WORD Ignore = 0);
    virtual void             LoadDirect (int fp);
    virtual void             SaveDirect (int fp);
    virtual Atom&            operator+ (const Atom& a1);
    virtual Atom&            operator= (const Atom& a1);
    virtual void *           operator[] (DWORD index);
    virtual                  operator void*() const;
    virtual                  operator BYTE*() const;
    friend istream&          operator>> (istream&, Atom&);
    virtual void             Resize (WORD n_nelem, SIZE n_elSize = 0);
    virtual void             ForEach (IterFuncType func, void * param);
    virtual void *           FirstThat (CondFuncType test, void * param);
    virtual void *           LastThat (CondFuncType test, void * param);
			    ~Atom (void);
};
typedef Atom ATOM;

#endif
