
#ifndef __MMOUSE_H
#define __MMOUSE_H

#define MMOUSE_ID            0x0115

#define DEFAULT_MOUSE_REP_DELAY   25   // Interval between click signals

typedef enum {
    noButtons    = 0x00,
    leftButton   = 0x01,
    rightButton  = 0x02,
    reset        = 0xff,
    eitherButton = 0x03
} buttonType;

class MMouse : public MMob {
protected:
    BYTE                     nbutton;
    BYTE                     obutton;
public:
    DWORD                    RepeatDelay;
protected:
    void                     DefaultCursor (void);
public:
			     MMouse (void);
    void                     MoveTo (int x,int y);
    buttonType               buttonStatus (void);
    void                     Update (void);
    virtual inline classType isA (void) {return (MMOUSE_ID);};
    inline void              SetRepeatDelay (DWORD NewDelay) { RepeatDelay = NewDelay;};
    BOOL                     isPressed (buttonType myButtons);
    BOOL                     isClicked (buttonType myButtons);
    BOOL                     isInBox (int x1, int y1, int x2, int y2);
    BOOL                     isInBox (const RECT& ABox);
			    ~MMouse (void);
};

#ifndef MOUSE_UNIT
extern MMouse mouse;
#endif
#endif
