
#ifndef __MMULLE_H
#define __MMULLE_H

#define MAXFILES            50
#define ID_LENGTH            9
#define RECORD_LENGTH       20

#define NOT_MULLE_FILE       1
#define INVALID_FILE         2

#define MULLE_HEADER          "Multifile"
#define MULLE_HEADER_LENGTH  9 

typedef struct pakfile {
    BYTE         name[13];       // record's name
    DWORD        offset;         // record's position in the file - header
    DWORD        size;           // record's size
} P_FILE;

class multifile : public MObject {
protected:
    BYTE                     filename[13];
    WORD                     nFiles;            // Number of files packed in main file
    WORD                     headLen;           // Length of the header
    P_FILE *                 files;
public:
		             multifile (void);
		             multifile (BYTE name[13]);
    void                     SetMainFile (BYTE name[13]);
    void                     ReadMainFile (void);
    inline char*             GetMainFileName (void) { return (filename); };
    DWORD                    GetOffset (BYTE name[13]);
    void                     ReadData (BYTE name[13], ATOM& buffer);
    void *                   ReadData (BYTE name[13]);
		            ~multifile (void);
};
typedef multifile MULLE;

#endif
