
#ifndef __MOBJECT_H
#define __MOBJECT_H

#ifndef __OBJECT_H
typedef unsigned int         classType;
typedef unsigned int         hashValueType;
#endif

#define MOBJECT_ID      100
#define USER_NEW_AND_DELETE

/////////////////////////////////////////////////////////////////////////////

#ifdef __OBJECT_H
class MObject : public Object {
#else
class MObject {
#endif
public:
			     MObject (void);
#ifdef USER_NEW_AND_DELETE
    void *                   operator new (size_t s);
    void                     operator delete (void *p);
#endif
    virtual classType        isA (void);
#ifdef __OBJECT_H
    virtual LPSTR            nameOf (void);
    virtual hashValueType    hashValue (void);
    virtual int              isEqual (const Object& o);
#else
    friend ostream&	     operator<< (ostream& os, MObject& o);
#endif
    virtual void             printOn (ostream& os);
			    ~MObject (void) {};
};

//////////////////////////////////////////////////////////////////////////////
 typedef                     void (* IterFuncType) (MObject * , void *);
 typedef                     BOOL (* CondFuncType) (MObject * , void *);
//////////////////////////////////////////////////////////////////////////////

#endif
