#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>
#include <mlabel.h>
#include <mbutton.h>
#include <mcheck.h>

//////////////////////// CHECK control ////////////////////////////////////

/********************************************/
      MCheck :: MCheck
/********************************************/
(int x1, int y1, int x2, int y2, BYTE ALabel[], WORD AHandle, WORD AParent)
: MButton (x1, y1, x2, y2, ALabel, AHandle, AParent)
{
    State = Off;
}

/********************************************/
      MCheck :: MCheck
/********************************************/
(const RECT& ABox, BYTE ALabel[], WORD AHandle, WORD AParent)
: MButton (ABox, ALabel, AHandle, AParent)
{
    State = Off;
}

/********************************************/
 inline void MCheck :: SetState
/********************************************/
(StateType NewState)
{
    State = NewState;
}

/********************************************/
 inline StateType MCheck :: GetState (void)
/********************************************/
{
    return (State);
}

/********************************************/
 void MCheck :: Draw (void)
/********************************************/
{
    if (Refresh)
    {
       mouse.Hide();
       push_DC();
       setviewport (box);
       setfillstyle (SOLID_FILL, 7);
       bar (box);

       if (Disabled)
	  setcolor (7);
       else
       {
	  if (State == On)
	     setcolor (15);
	  else
	     setcolor (0);
       }
       hor_line (box.left, box.right - 1, box.bottom - 1);
       vert_line (box.top, box.bottom - 1, box.right - 1);

       if (Disabled)
	  setcolor (7);
       else
       {
	  if (State == On)
	     setcolor (0);
	  else
	     setcolor (15);
       }
       hor_line (box.left, box.right - 2, box.top);
       vert_line (box.top, box.bottom - 1, box.left);

       setcolor (0);
       outtextxy (box.left + 5, box.top + 2, label);

       pop_DC();
       mouse.RescanBackgr();
       mouse.Show();
    }
}

/********************************************/
 WORD MCheck :: Handler
/********************************************/
(EVENT event)
{
WORD status = EVENT_NOT_USED;
    if (event->dest == HNUL || event->dest == Handle)
    {
       if ((event->type & MouseMoved) && (IsInside (box, event->xpos, event->ypos)) && !Disabled)
       {
	  Activate();
	  Draw();
	  status = EVENT_USED;
       }
       else if ((event->type & MouseMoved) && (!IsInside (box, event->xpos, event->ypos)) && IsActive && !Disabled)
       {
	  Deactivate();
	  Draw();
       }
       else
       {
	  if ((IsInside (box, event->xpos, event->ypos)) && (!Disabled) && ((void*)UserHandler != NULL))
	  {
	     status = UserHandler();
	     if (State == Off)
		State = On;
	     else
		State = Off;
	  }
       }
    }
    return (status);
}

/********************************************/
      MCheck :: ~MCheck (void)
/********************************************/
{
}

/////////////////////////////////////////////////////////////////////////
