#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>
#include <minput.h>

/********************************************/
      MGetInput :: MGetInput
/********************************************/
(int x1, int y1, int x2, int y2, char * APrompt, WORD MaxChar, WORD AHandle, WORD AParent)
: MWindow (x1, y1, x2, y2, AHandle, AParent)
{
BYTE DefaultColors [N_COLOR_TYPES] = {7,0,8,15, 7,0,8,15, 7,8,24,27, 0};

    memcpy (color, DefaultColors, N_COLOR_TYPES);
    Prompt = APrompt;
    UserString.Resize (MaxChar + 1);
    UserString.Clear();
    Buffer = NULL;
    cPos = 0;
}

/********************************************/
      MGetInput :: MGetInput
/********************************************/
(const RECT& ABox, BYTE * APrompt, WORD MaxChar,
 WORD AHandle, WORD AParent)
: MWindow (ABox, AHandle, AParent)
{
BYTE DefaultColors [N_COLOR_TYPES] = {7,0,8,15, 7,0,8,15, 7,8,24,27, 0};

    memcpy (color, DefaultColors, N_COLOR_TYPES);
    Prompt = APrompt;
    UserString.Resize (MaxChar + 1);
    UserString.Clear();
    Buffer = NULL;
    cPos = 0;
}

/********************************************/
 void MGetInput :: Draw (void)
/********************************************/
{
WORD InputBoxOffset;

    if (Refresh)
    {
       mouse.Hide();
       push_DC();
       setviewport (box);

       if (Disabled)
	  setfillstyle (SOLID_FILL, color [DisabledBack]);
       else if (IsActive)
	  setfillstyle (SOLID_FILL, color [ActiveBack]);
       else
	  setfillstyle (SOLID_FILL, color [NormalBack]);

       bar (box);

       if (Disabled)
	  setcolor (color [DisabledDarkBorder]);
       else if (IsActive)
	  setcolor (color [ActiveDarkBorder]);
       else
	  setcolor (color [NormalDarkBorder]);

       hor_line (box.left, box.right - 1, box.bottom - 1);
       vert_line (box.top, box.bottom - 1, box.right - 1);

       if (Disabled)
	  setcolor (color [DisabledLightBorder]);
       else if (IsActive)
	  setcolor (color [ActiveLightBorder]);
       else
	  setcolor (color [NormalLightBorder]);

       hor_line (box.left, box.right - 1, box.top);
       vert_line (box.top, box.bottom - 1, box.left);

       if (Disabled)
	  setcolor (color [DisabledFront]);
       else if (IsActive)
	  setcolor (color [ActiveFront]);
       else
	  setcolor (color [NormalFront]);

       InputBoxOffset = outtextxy (box.left + 6, box.top + 3, (BYTE*)Prompt);
       outtextxy (box.left + InputBoxOffset + 9, box.top + 3, (BYTE*)UserString);

       pop_DC();
       mouse.RescanBackgr();
       mouse.Show();
    }
}

/********************************************/
 WORD MGetInput :: Handler
/********************************************/
(EVENT event)
{
WORD status = EVENT_NOT_USED;
    if (event->dest == HNUL || event->dest == Handle)
    {
       if ((event->type & MouseMoved) && (IsInside (box, event->xpos, event->ypos)) && !IsActive && !Disabled)
       {
	  Activate();
	  Draw();
	  status = EVENT_USED;
	  CreateEvent (SET_FOCUS, 0, NULL, Handle, HNUL);
       }
       if (event->type == SET_FOCUS && IsActive && event->value != Handle)
       {
	  Deactivate();
	  Draw();
       }
       if (IsActive && (event->type & KeyPressed))
       {
	  InterpretKeystroke (event);
          Draw();
	  status = EVENT_USED;
       }
    }
    return (status);
}

/********************************************/
 void MGetInput :: InterpretKeystroke
/********************************************/
(EVENT event)
{
    if (event->key == BACKSPACE && cPos > 0)
    {
       --cPos;
       UserString [cPos] = '\x0';
    }
    else if (event->key == ENTER)
    {
       if ((void*)UserHandler != NULL)
	  UserHandler((BYTE*)UserString);
    }
    else if (event->key > ESCAPE && event->key < 127 && cPos < UserString.GetMaxElem() - 1)
    {
       UserString [cPos] = (char)event->key;
       ++ cPos;
    }
    else
       UserString [cPos] = '\x0';
}

/********************************************/
 void MGetInput :: SetBuffer
/********************************************/
(BYTE * ABuffer)
{
    Buffer = ABuffer;
}

/********************************************/
 void MGetInput :: FlushToBuffer (void)
/********************************************/
{
    if (Buffer != NULL)
       strcpy (Buffer, (BYTE*)UserString);
}

/********************************************/
 void MGetInput :: LoadDirect
/********************************************/
(int fp)
{
    read (fp, &box, sizeof(RECT));
    read (fp, (BYTE*)UserString, UserString.GetMaxElem());
}

/********************************************/
 void MGetInput :: SaveDirect
/********************************************/
(int fp)
{
    write (fp, &box, sizeof(RECT));
    write (fp, (BYTE*)UserString, UserString.GetMaxElem());
}

/********************************************/
 inline void MGetInput :: SetDefault
/********************************************/
(BYTE * NewString)
{
    UserString = NewString;
}

/********************************************/
      MGetInput :: ~MGetInput (void)
/********************************************/
{
    if (Buffer != NULL)
       strcpy (Buffer, (BYTE*)UserString);
}

///////////////////////////////////////////////////////////////////////////
