#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>
#include <mscroll.h>

/********************************************/
      MScroller :: MScroller
/********************************************/
(int x1, int y1, int x2, int y2, WORD AHandle, WORD AnHParent)
: MWindow (x1,y1,x2,y2,AHandle,AnHParent)
{
    World.Set (0,0,box.length,box.width);
    vxpos = 0;
    vypos = 0;
    speed = 3;
    WrapX = FALSE;
    WrapY = FALSE;
}

/********************************************/
      MScroller :: MScroller
/********************************************/
(const RECT& ABox, WORD AHandle, WORD AnHParent)
: MWindow (ABox,AHandle,AnHParent)
{
    World.Set (0,0,box.length,box.width);
    vxpos = 0;
    vypos = 0;
    speed = 3;
    WrapX = FALSE;
    WrapY = FALSE;
}

/********************************************/
 void MScroller :: SetWindowPosition
/********************************************/
(int Newx, int Newy)
{
    if (Newx + box.length > World.length)
       vxpos = World.length - box.length;
    else if (Newx < 0)
       vxpos = 0;
    else
       vxpos = Newx;

    if (Newy + box.width > World.width)
       vypos = World.width - box.width;
    else if (Newy < 0)
       vypos = 0;
    else
       vypos = Newy;
}

/********************************************/
 void MScroller :: ResizeWorld
/********************************************/
(WORD NewLength, WORD NewWidth)
{
int refresh = FALSE;

    World.right = World.left + NewLength;
    World.bottom = World.top + NewWidth;
    World.length = NewLength;
    World.width = NewWidth;
    if (World.left + vxpos + box.length > World.right)
    {
       if (box.length > NewLength)
       {
	  vxpos = 0;
          ResizeBox (NewLength, box.width);
       }
       else
       {
	  vxpos = World.right - box.length;
          refresh = TRUE;
       }
    }
    if (World.top + vypos + box.width > World.bottom)
    {
       if (box.width > NewWidth)
       {
	  vypos = 0;
          ResizeBox (box.length, NewWidth);
       }
       else
       {
	  vypos = World.bottom - box.width;
          refresh = TRUE;
       }
    }

    if (refresh)
       CreateEvent (REFRESH_WINDOW, 0, NULL, 0L, Handle);
}

/********************************************/
 void MScroller :: ResizeWorld
/********************************************/
(const RECT& NewWorld)
{
BOOL refresh = FALSE;

    World = NewWorld;

    if (World.left + box.length + vxpos > World.right)
    {
       if (box.length > World.length)
       {
	  vxpos = 0;
          ResizeBox (World.length, box.width);
       }
       else
       {
	  vxpos = World.right - box.length;
          refresh = TRUE;
       }
    }
    if (World.top + box.width + vypos > World.bottom)
    {
       if (box.width > World.width)
       {
	  vypos = 0;
          ResizeBox (box.length, World.width);
       }
       else
       {
	  vypos = World.bottom - box.width;
	  refresh = TRUE;
       }
    }

    if (refresh)
       CreateEvent (REFRESH_WINDOW, 0, NULL, 0L, Handle);
}

/********************************************/
 void MScroller :: Scroll
/********************************************/
(Direction where)
{
    if (where == Down)
    {
       if (vypos >= speed || WrapY)
       {
	  vypos -= speed;
	  while (vypos < 0)
	     vypos += World.width;
       }
       else
	  vypos = 0;
    }
    else if (where == Up)
    {
       if ((vypos < World.width - box.width - speed) || WrapY)
       {
	  vypos += speed;
	  while (vypos > World.width)
	     vypos -= World.width;
       }
       else
	  vypos = World.width - box.width;
    }
    else if (where == Right)
    {
       if (vxpos >= speed || WrapX)
       {
	  vxpos -= speed;
	  while (vxpos < 0)
	     vxpos += World.length;
       }
       else
	  vxpos = 0;
    }
    else if (where == Left)
    {
       if ((vxpos < World.length - box.length - speed) || WrapX)
       {
	  vxpos += speed;
	  while (vxpos > World.length)
	     vxpos -= World.length;
       }
       else
	  vxpos = World.length - box.length;
    }
}

/********************************************/
 void MScroller :: SetSpeed
/********************************************/
(WORD NewSpeed)
{
    if (speed < World.length)
       speed = NewSpeed;
}

/********************************************/
 void MScroller :: LoadDirect
/********************************************/
(int fp)
{
    read (fp, &box, sizeof(RECT));
}

/********************************************/
 void MScroller :: SaveDirect
/********************************************/
(int fp)
{
    write (fp, &box, sizeof(RECT));
}

/********************************************/
      MScroller :: ~MScroller (void)
/********************************************/
{
}
