#include <mstd.h>
#include <mobject.h>
#include <mrect.h>

//////////////////////////// IntPoint class //////////////////////////////////

/********************************************/
      IntPoint :: IntPoint (void)
/********************************************/
{
    x = 0;
    y = 0;
}

/********************************************/
      IntPoint :: IntPoint
/********************************************/
(int anX, int aY)
{
    x = anX;
    y = aY;
}

/********************************************/
 inline IntPoint& IntPoint :: operator=
/********************************************/
(const IntPoint& APoint)
{
    x = APoint.x;
    y = APoint.y;
    return (*this);
}

//////////////////////////// SimpleRect class ////////////////////////////////

/********************************************/
      SimpleRect :: SimpleRect (void)
/********************************************/
{
    left = top = 0;
    right = 320;
    bottom = 200;
}

/********************************************/
      SimpleRect :: SimpleRect
/********************************************/
(int x1, int y1, int x2, int y2)
{
    left = x1;
    top = y1;
    right = x2;
    bottom = y2;
}

/********************************************/
 void SimpleRect :: Set
/********************************************/
(int x1, int y1, int x2, int y2)
{
    left = x1;
    top = y1;
    right = x2;
    bottom = y2;
}

/********************************************/
 RECT& SimpleRect :: operator=
/********************************************/
(const RECT& ARect)
{
    left = ARect.left;
    right = ARect.right;
    top = ARect.top;
    bottom = ARect.bottom;
    return (*this);
}

/////////////////////// ViewPort class ///////////////////////////////////////

/********************************************/
      ViewPort :: ViewPort (void)
/********************************************/
{
    left = top = 0;
    right = 320;
    bottom = 200;
    length = 320;
    width = 200;
}

/********************************************/
      ViewPort :: ViewPort
/********************************************/
(int x1, int y1, int x2, int y2)
{
    left = x1;
    right = x2;
    top = y1;
    bottom = y2;
    length = x2 - x1;
    width = y2 - y1;
}

/********************************************/
      ViewPort :: ViewPort
/********************************************/
(const RECT& ARect)
{
    left = ARect.left;
    right = ARect.right;
    top = ARect.top;
    bottom = ARect.bottom;
    length = right - left;
    width = bottom - top;
}

/********************************************/
 void ViewPort :: Set
/********************************************/
(int x1, int y1, int x2, int y2)
{
    left = x1;
    right = x2;
    top = y1;
    bottom = y2;
    length = x2 - x1;
    width = y2 - y1;
}

/********************************************/
 RECT& ViewPort :: operator=
/********************************************/
(const RECT& ARect)
{
    left = ARect.left;
    right = ARect.right;
    top = ARect.top;
    bottom = ARect.bottom;
    length = ARect.right - ARect.left;
    width = ARect.bottom - ARect.top;
    return (*this);
}

//////////////////////////////////////////////////////////////////////////////
