////////////////////////////////////////////////////////////////////////////////
// FILE: MERROR
// 	Provides tools for displaying errors n text mode.
////////////////////////////////////////////////////////////////////////////////

#include <conio.h>
#include <mstd.h>
#include <mobject.h>
#include <mmemutil.h>
#include <merror.h>
#include <iomanip.h>

/********************************************/
 inline char *     Repeat
/********************************************/
(char ch, WORD nReps)
{
char *str;
    str = (char*) AllocMem (nReps * sizeof(char) + 1);
    strnset (str, ch, nReps);
    return (str);
}

/********************************************/
 void          PrintTextError
/********************************************/
(char * message, BOOL DoExit, ostream& os)
{
int len, rlen;
void *buf;
    len = strlen (message);
    rlen = max (len, 20);
    if (!DoExit)
    {
       buf = AllocMem (10 * (rlen + 2));
       gettext (1,1, rlen + 1,5, buf);
    }
    textattr (0x04);
    gotoxy (1,1);
    os << "" << Repeat (0xDF, rlen) << "\n";
    os << "" << setw(rlen) << setfill('*') << "**** ERROR" << "\n";
    os << "" << setw(rlen) << setfill(' ') << " - " << message << "\n";
    if (DoExit)
       os << "" << " Press a key to exit." << "\n";
    os << "" << Repeat (0xDC, rlen) << "\n";

    while (kbhit()) getch();
    while (!kbhit());

    if (DoExit)
       exit(1);
    else
    {
       puttext (1,1, rlen + 1,5, buf);
       FreeMem (buf);
    }
}

