////////////////////////////////////////////////////////////////////////////////
// FILE: MMEMUTIL
////////////////////////////////////////////////////////////////////////////////

#pragma inline
#include <dos.h>
#include <alloc.h>
#include <mstd.h>
#include <mmemutil.h>
#include <merror.h>

////////////////////////////////////////////////////////////////////////////
// Accessory memory management functions, that require assembler.
////////////////////////////////////////////////////////////////////////////

/********************************************/
 void *           AllocMem
/********************************************
 Allocates a nonzero memory block. Returns pointer
 to allocated memory on success, exits on error.
*/
(LSIZE size)
{
void *ptr = NULL;
    if (size > 0)
    {
       ptr = calloc (1, size);
       if (ptr == NULL)
	  PrintTextError ("Null pointer in AllocMem!");
    }
    return (ptr);
}

/********************************************/
 void *          ReallocMem
/********************************************
 Resizes old memory block or if it is NULL,
 allocates a new one. Returns pointer to the
 new block on success, exits on error.
*/
(void *ptr, LSIZE size)
{
void *NewPtr = NULL;

    if (ptr != NULL)
       NewPtr = realloc (ptr, size);
    else
       NewPtr = calloc (1, size);

    if (NewPtr == NULL && size > 0)
       PrintTextError ("Null pointer in ReallocMem!");
    return (NewPtr);
}


/********************************************/
 void             FreeMem
/********************************************
 Frees allocated memory.
*/
(void *ptr)
{
    if (ptr != NULL)
       free (ptr);
}

/********************************************/
 void              MoveMem
/********************************************
 Moves size bytes from src to dest. Very fast.
*/
(void *src, void *dest, WORD size)
{
asm PUSH ES                // Save original DS and ES on stack
asm PUSH DS

asm LES BX, src            // Load high word of src in ES
asm PUSH ES
asm POP DS                 // Load source address in DS
asm MOV SI, BX             // DS:SI is now src pointer
asm LES BX, dest           // Load high word of dest in ES
asm MOV DI, BX             // ES:DI is now dest pointer

asm XOR DX, DX
asm MOV AX, size
asm MOV BX, 2
asm DIV BX
asm MOV CX, AX             // Set counter to run length
asm CMP DX, 0
asm JE MainLoop
asm LODSB                  // If length is odd, output the remaining byte
asm STOSB
MainLoop:
asm CLD                    // Clear direction flag to 1
asm REP MOVSW              // Move src to dest

asm POP DS                 // Restore original DS and ES
asm POP ES
}

/********************************************/
 void              MoveMem
/********************************************
 Moves run bytes count times, skipping dskip
 bytes in dest and sskip bytes in src.
*/
(void *src, void *dest, WORD count,
 WORD run, WORD dskip, WORD sskip)
{
asm PUSH ES                // Save original DS and ES on stack
asm PUSH DS

asm LES BX,src             // Load high word of src in ES
asm PUSH ES
asm POP DS                 // Load source address in DS
asm MOV SI,BX              // DS:SI is now src pointer
asm LES BX,dest            // Load high word of dest in ES
asm MOV DI,BX              // ES:DI is now dest pointer

asm XOR AX, AX
Start:
asm PUSH AX

asm XOR DX, DX
asm MOV AX, run
asm MOV BX, 2
asm DIV BX
asm MOV CX, AX             // Set counter to run length

asm CMP DX, 0
asm JE MainLoop
asm LODSB                  // If length is odd, output the remaining byte
asm STOSB

MainLoop:
asm POP AX
asm CLD                    // Clear direction flag to 1
asm REP MOVSW              // Move run to dest
asm ADD DI,dskip           // Skip in destination
asm ADD SI,sskip           // Skip in source
asm INC AX                 // Increment AX by 1
asm CMP AX,count           // Is AX == count
asm JNE Start:             // If AX is not count, start on new run

asm POP DS                 // Restore original DS and ES
asm POP ES
}

/********************************************/
 void           MoveMemMasked
/********************************************
 Moves run bytes count times, skipping dskip
 bytes in dest and sskip bytes in src.
*/
(void *src, void *dest, WORD count,
 WORD run, WORD dskip, WORD sskip)
{
asm PUSH ES                // Save original DS and ES on stack
asm PUSH DS

asm LES BX,src             // Load high word of src in ES
asm PUSH ES
asm POP DS                 // Load source address in DS
asm MOV SI,BX              // DS:SI is now src pointer
asm LES BX,dest            // Load high word of dest in ES
asm MOV DI,BX              // ES:DI is now dest pointer

asm XOR DX,DX              // Make DX a row counter
RowLoop:
asm MOV CX,run             // Reset counter to the run length
asm CLD                    // Clear direction flag to 1
ColLoop:
asm LODSB                  // Load bitmap pixel in AL
asm OR AL,AL               // If AL is 0 then do not draw
asm JNZ Pixel
asm INC DI
asm JMP EndLoop
Pixel:
asm STOSB                  // Plot the point on the screen
EndLoop:
asm LOOP ColLoop
asm ADD DI,dskip           // Skip in destination
asm ADD SI,sskip           // Skip in source
asm INC DX                 // Increment AX by 1
asm CMP DX,count           // Is DX == count
asm JNE RowLoop            // If DX is not zero, start on new run

asm POP DS                 // Restore original DS and ES
asm POP ES
}


/********************************************/
 void             int33
/********************************************
 Fast implementation of interrupt 0x33 for mouse operations.
*/
(union REGS *inregs, union REGS *outregs)
{
    _AX = inregs->x.ax;
    _CX = inregs->x.cx;
    _DX = inregs->x.dx;
    _BX = inregs->x.bx;
asm INT 33H
asm PUSH BX
    outregs->x.ax = _AX;
    outregs->x.cx = _CX;
    outregs->x.dx = _DX;
asm POP CX                   // BX is used for addressing
    outregs->x.bx = _CX;
}

