#include <mio.h>
#include <mgr.h>

MMouse mouse;

/********************************************/
      MMouse :: MMouse (void)
/********************************************/
{
union REGS in_regs,out_regs;
    in_regs.x.ax = 0;                  // Initialize mouse driver
    int33 (&in_regs,&out_regs);
    RepeatDelay = DEFAULT_MOUSE_REP_DELAY;
    DefaultCursor();
    MoveTo (MAXX/2, MAXY/2);
}

/********************************************/
 void MMouse :: MoveTo
/********************************************/
(int x,int y)
{
union REGS in_regs,out_regs;
    in_regs.x.ax = 4;
    in_regs.x.cx = x;
    in_regs.x.dx = y;
    int33 (&in_regs,&out_regs);
    MMob :: MoveTo (x,y);
}

/********************************************/
 void MMouse :: DefaultCursor (void)
/********************************************
DESCRIPTION: Defines default 5x5 arrow cursor.
*/
{
BYTE arrow_res[25] = {0x0F,0x0F,0x0F,0x0F,0x0F,
		      0x0F,0x0F,0x0F,0x00,0x00,
		      0x0F,0x0F,0x0F,0x00,0x00,
		      0x0F,0x00,0x00,0x0F,0x00,
		      0x0F,0x00,0x00,0x00,0x0F};
cArray *arrow;
union REGS in_regs, out_regs;
    arrow = new cArray (25,(BYTE*)arrow_res);
    SetImage (5,5,*(arrow));
    SetPut (SEETH_PUT);
    delete arrow;
}

/********************************************/
 buttonType MMouse :: buttonStatus (void)
/********************************************/
{
    return ((buttonType) nbutton);
}

/********************************************/
 BOOL MMouse :: isPressed
/********************************************/
(buttonType myButtons)
{
    return (myButtons & nbutton);
}

/********************************************/
 BOOL MMouse :: isClicked
/********************************************/
(buttonType myButtons)
{
    return ((myButtons & obutton) && !isPressed (myButtons));
}

/********************************************/
 BOOL MMouse :: isInBox
/********************************************/
(int x1, int y1, int x2, int y2)
{
    if (x1 <= nx && y1 >= ny && x2 <= nx && y2 >= ny)
       return (TRUE);
    else
       return (FALSE);
}

/********************************************/
 BOOL MMouse :: isInBox
/********************************************/
(const RECT& ABox)
{
    if (ABox.left <= nx && ABox.top <= ny && ABox.right >= nx && ABox.bottom >= ny)
       return (TRUE);
    else
       return (FALSE);
}

/********************************************/
 void MMouse :: Update (void)
/********************************************/
{
union REGS in_regs,out_regs;
    in_regs.x.ax = 3;
    int33 (&in_regs,&out_regs);
    obutton = nbutton;
    nbutton = noButtons;
    switch (out_regs.x.bx)
    {
	case 0x01:  nbutton |= leftButton;  break;
	case 0x02:  nbutton |= rightButton; break;
	default:    nbutton = noButtons;   break;
    }
    MMob :: MoveTo (out_regs.x.cx, out_regs.x.dx);
}

/********************************************/
      MMouse :: ~MMouse()
/********************************************/
{
// All deallocation is done by the MMob
}
