#define MWINDOW_MODULE

#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>
#include <mparent.h>

/////////////////////////// MParent ////////////////////////////////////

MParent root;

/********************************************/
      MParent :: MParent
/********************************************/
(void) : MWindow (0,0,MAXX-1,MAXY-1,HROOT,HNUL)
{
    focus = 0;
    Refresh = TRUE;
    Realized = TRUE;
}

/********************************************/
      MParent :: MParent
/********************************************/
(int x1, int y1, int x2, int y2, WORD AHandle, WORD AnHParent)
: MWindow (x1, y1, x2, y2, AHandle, AnHParent)
{
    focus = 0;
    Refresh = TRUE;
    Realized = TRUE;
}

/********************************************/
      MParent :: MParent
/********************************************/
(const RECT& ABox, WORD AHandle, WORD AnHParent)
: MWindow (ABox, AHandle, AnHParent)
{
    focus = 0;
    Refresh = TRUE;
    Realized = TRUE;
}

/********************************************/
 WORD MParent :: Run (void)
/********************************************/
{
EVENT event;
WORD status = NORMAL;
MWindow *control;

    if (!Realized)
       return (REALIZE_FIRST);
    else
       Draw();

    FlushEvents();
    do
    {
       event = GetEvent();
       status = Handler (event);
       delete event;
    }
    while (status != SHELL_QUIT && !Children.IsEmpty());

    FlushEvents();
    CreateEvent (REFRESH_WINDOW, 0, NULL, 0L, HParent);
    return (status);
}

/********************************************/
 void MParent :: Draw (void)
/********************************************/
{
MWindow * AChild;
    if (Realized)
    {
       if (Refresh)
       {
	  mouse.Hide();
	  push_DC();
	  setviewport (box);
	  setfillstyle (SOLID_FILL, color [NormalBack]);
	  bar (box);
	  setcolor (color [NormalDarkBorder]);
	  rectangle (box);
          if (DrawShadow)
	  {
             setviewport (box.left, box.top, box.right + SHADOW_WIDTH, 
					     box.bottom + SHADOW_WIDTH);
             setfillstyle (SOLID_FILL, 0);
	     setcolor (0);
	     bar (box.right + 1, box.top + SHADOW_WIDTH, 
		  box.right + SHADOW_WIDTH, box.bottom + SHADOW_WIDTH);
	     bar (box.left + SHADOW_WIDTH, box.bottom + 1, 
		  box.right, box.bottom + SHADOW_WIDTH);
	  }
	  pop_DC();
	  mouse.RescanBackgr();
	  mouse.Show();
       }
       Children.Start();
       while (Children.OnList())
       {
          AChild = (MWindow*) Children.Retrieve();
	  AChild->Draw();
	  Children.MoveDown();
       }
    }
}

/********************************************/
 void MParent :: Realize (void)
/********************************************/
{
EVENT event;
WORD count = 0;
    do
    {
       event = GetEvent();

       if (event->dest == Handle)
       {
	  if (event->type == ADD_CHILD)
	     AddChild ((MTree*)event->data);
	  else if (event->type == REMOVE_CHILD)
	     DeleteChild ((MTree*)event->data);
	  else if (event->type == STOP_ADDING)
	     break;
       }
       else if (event->dest != HNUL)
	  CreateEvent (event->type, event->dSize, event->data, event->value, event->dest);

       delete event;
       ++ count;
    }
    while (count < Children.MaxSize);
    Realized = TRUE;
}

#pragma argsused
/********************************************/
 void MParent :: SetFocus
/********************************************/
(WORD AHandle)
{
MWindow * AChild;
    Children.Start();
    while (Children.OnList())
    {
       AChild = (MWindow*) Children.Retrieve();
       if (AChild->Handle == AHandle)
	  focus = Children.GetCurrentOffset();
       Children.MoveDown();
    }
    Children.SetCurrentOffset (focus);
}

/********************************************/
 inline void MParent :: EnableShadow (void)
/********************************************/
{
    DrawShadow = TRUE;
}

/********************************************/
 inline void MParent :: DisableShadow (void)
/********************************************/
{
    DrawShadow = FALSE;
}

/********************************************/
 static BOOL      IsSought
/********************************************/
(MObject * win, void * param)
{
    return (((MWindow*)win)->Handle == *(WORD*)param);
}

/********************************************/
 MWindow * MParent :: Find
/********************************************/
(WORD handle)
{
MWindow * found = NULL;
    found = (MWindow*) MTree :: Find (IsSought, &handle);
    return (found);
}

/********************************************/
      MParent :: ~MParent (void)
/********************************************/
{
}

/////////////////////////////////////////////////////////////////////////////

/********************************************/
 void            FinishSetup
/********************************************/
(WORD Handle)
{
    CreateEvent (STOP_ADDING, 0, NULL, 0L, Handle);
}
