#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>

///////////////////////////// MWindow class ///////////////////////////

/********************************************/
      MWindow :: MWindow
/********************************************/
(int x1, int y1, int x2, int y2, WORD AHandle, WORD AnHParent)
: MTree (NULL, MAX_CHILDREN)
{
BYTE DefaultColors [N_COLOR_TYPES] = {7,0,8,15, 7,0,8,15, 7,8,24,27, 0};

    memcpy (color, DefaultColors, N_COLOR_TYPES);
    box.Set (x1,y1,x2,y2);
    Handle = AHandle;
    UserHandler = NULL;
    IsActive = FALSE;
    Disabled = FALSE;
    Refresh = TRUE;
    HParent = AnHParent;
    if (HParent != HNUL)
       CreateEvent (ADD_CHILD, sizeof(MWindow*), this, 0L, HParent);
}

/********************************************/
      MWindow :: MWindow
/********************************************/
(const RECT& ABox, WORD AHandle, WORD AnHParent)
: MTree (NULL, MAX_CHILDREN)
{
BYTE DefaultColors [N_COLOR_TYPES] = {7,0,8,15, 7,0,8,15, 7,8,24,27, 0};

    memcpy (color, DefaultColors, N_COLOR_TYPES);
    box = ABox;
    Handle = AHandle;
    UserHandler = NULL;
    IsActive = FALSE;
    Disabled = FALSE;
    Refresh = TRUE;
    HParent = AnHParent;
    if (HParent != HNUL)
       CreateEvent (ADD_CHILD, sizeof(MWindow*), this, 0L, HParent);
}

/********************************************/
 inline void MWindow :: Activate (void)
/********************************************/
{
    IsActive = TRUE;
}

/********************************************/
 inline void MWindow :: Deactivate (void)
/********************************************/
{
    IsActive = FALSE;
}

/********************************************/
 inline void MWindow :: Enable (void)
/********************************************/
{
    Disabled = FALSE;
}

/********************************************/
 inline void MWindow :: Disable (void)
/********************************************/
{
    Disabled = TRUE;
}

/********************************************/
 void MWindow :: Draw (void)
/********************************************/
{
MWindow * AChild;
    if (Refresh)
    {
       mouse.Hide();
       push_DC();
       setviewport (box);
       setfillstyle (SOLID_FILL, color [NormalBack]);
       bar (box);
       pop_DC();
       mouse.RescanBackgr();
       mouse.Show();
    }
    Children.Start();
    while (Children.OnList())
    {
       AChild = (MWindow*) Children.Retrieve();
       AChild->Draw();
       Children.MoveDown();
    }
}

/********************************************/
 inline void MWindow :: ResizeBox
/********************************************/
(WORD NewLength, WORD NewWidth)
{
    box.Set (box.left, box.top, box.left + NewLength, box.top + NewWidth);
    CreateEvent (REFRESH_WINDOW, 0, NULL, 0L, HParent);
}

/********************************************/
 inline void MWindow :: ResizeBox
/********************************************/
(const RECT& NewBox)
{
    box.Set (box.left, box.top, box.left + NewBox.right - NewBox.left,
				box.top + NewBox.bottom - NewBox.top);
    CreateEvent (REFRESH_WINDOW, 0, NULL, 0L, HParent);
}

#pragma argsused
/********************************************/
 WORD MWindow :: Handler
/********************************************/
(EVENT event)
{
WORD status = EVENT_NOT_USED;
MWindow * AChild;

    Children.Start();
    while (Children.OnList() && status == EVENT_NOT_USED)
    {
       AChild = (MWindow*) Children.Retrieve();
       status = AChild->Handler (event);
       Children.MoveDown();
    }

    if (status == EVENT_NOT_USED && (event->dest == HNUL || event->dest == Handle))
    {
       if (event->type == ADD_CHILD)
       {
	  AddChild ((MTree*)event->data);
	  Draw();
       }
       else if (event->type == REMOVE_CHILD)
       {
	  DeleteChild ((MTree*)event->data);
	  Draw();
       }
       else if (event->type == DISABLE_WINDOW)
	  Disable();
       else if (event->type == ENABLE_WINDOW)
	  Enable();
       if (event->type == REFRESH_WINDOW)
          Draw();
       if ((event->type & MouseMoved) && (IsInside (box, event->xpos, event->ypos)) && !IsActive && !Disabled)
       {
	  Activate();
	  status = EVENT_USED;
       }
       if ((event->type & MouseMoved) && (!IsInside (box, event->xpos, event->ypos)) && IsActive && !Disabled)
	  Deactivate();
       else if ((void*)UserHandler != NULL)
	  UserHandler();
    }
    return (status);
}

/********************************************/
 inline void MWindow :: LoadDirect
/********************************************/
(int fp)
{
    read (fp, &box, sizeof(RECT));
}

/********************************************/
 inline void MWindow :: SaveDirect
/********************************************/
(int fp)
{
    write (fp, &box, sizeof(RECT));
}

/********************************************/
 inline void MWindow :: SetUserHandler
/********************************************/
(WORD (*NewUserHandler)(...))
{
    UserHandler = NewUserHandler;
}

/********************************************/
 inline void MWindow :: SetColor
/********************************************/
(BYTE what, BYTE extra, BYTE to)
{
    color [what + extra] = to;
}

/********************************************/
      MWindow :: ~MWindow (void)
/********************************************/
{
}

//////////////////////////////////////////////////////////////////////////////
