/*****************************************************
; Filename 	:  bitmap.h
;
; Date 		:  11-7-94
; Mod. Date	:  29-7-94
;
; Others	
;****************************************************/
#ifndef BITMAP_H
#define BITMAP_H

#ifdef __cplusplus
extern "C" {
#endif

#include "std_defs.h"

typedef struct wgtsprite
{
	int	slot;
	int	width;
	int	height;
	byte	*data;

} WGTSPRITE;

typedef struct wgtspritefile
{
	int	version;
	byte	id[13];			//" Sprite File "
	byte	palette[768];
	int	total;
	
} WGTSPRITE_HEADER;

typedef struct sprite
{
//	int	index;
	int	width;
	int	height;
	byte	*data;

} SPRITE;

typedef struct spriteheader
{
	int		reserved;
	byte		type[8];
	byte		palette[768];
	int		total;
} SPRITE_HEADER;



typedef struct CELHeader {
	int	magic_number;
	int	width;
	int 	height;
	int	x_coord;
	int	y_coord;
	int	compress_type;
	long	image_size;
	int	reserved[8];
	byte	palette[768];
	byte	*image;
} CELHDR;

/*
typedef struct devichdr {

	byte    char[26];
	byte	endcode;
	byte	mode;
	byte	total;
	DIM	*array;
	
} DEVICHDR
*/

// found in image.cpp
extern 		WGTSPRITE_HEADER   *wgt_header;
extern 		SPRITE_HEADER	   *sprite_header;
int 		mtLoadPCX(char *filename);

WGTSPRITE  	**mtLoadWGT(char *filename,byte palette[]);
int 		mtSaveWGT(char *fontname,WGTSPRITE **sprite);
void		mtFreeWGT(WGTSPRITE **sprite);

SPRITE 	**mtLoadBlit(char *filename, byte palette[]); 
int 	mtSaveBlit(char *filename,SPRITE **sprite);

void	mtFreeBlit(SPRITE **sprite);


//found in bitmap.asm
void	mtCPutBlit(int x, int y, int width, int height, byte *buf);
void	mtCPutSprite(int x, int y, int width, int height, byte *buf);

void	mtPutBlit(int x, int y, int width, int height, byte *buf);
void	mtPutSprite(int x, int y, int width, int height, byte *buf);
void    mtCPutFont(int x, int y, int w, int h, byte *buf);

#ifdef __cplusplus
}
#endif

#endif BITMAP_H
