/*                                                            
  
                                                            
                                                            
               Neuromancer's Graphics Library               
                       Version 1.0c                         
                                                            
      This program read in a mtGraph sprite files           
                                                             
  
                                                            
       Project:    MTLIB01.LIB                              
                   DEMO11.CPP                               
                                                             
  
*/

#include <iostream.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include "video.h"
#include "bitmap.h"
#include "palette.h"

extern SPRITE_HEADER *sprite_header;

void main(int argc, char *argv[])
{
	SPRITE		**sprite;
	byte	   	palette[768];
	int		width;

	if (argc!=2)
	{
		cout << "Usage : demo11 <filename> "<<endl;
		cout << "        where filename is a mtGraph <.blt> file"<< endl;
		exit(0);
	}
	
	if ((sprite=mtLoadBlit(argv[1],palette)) == NULL)
	{
		cout << "Error loading :" << argv[1] << endl;
		cout << "mtGraph sprite file required <.blt>"<< endl;
		exit(0);
	}

	mtSetVGAMode();

	mtSetPal(palette,0,255);

	width=5;

	int last = 5;

	if (last > (sprite_header->total))
	{
		last = sprite_header->total;
	}
	
	for(int i = 0; i <= last; i++)
	{	
		mtCPutSprite(width,10,sprite[i]->width, sprite[i]->height,sprite[i]->data);
		width += sprite[i]->width +5;
	}

	getch();

	mtFreeBlit(sprite);
	mtSetTextMode();
	
	cout << "Thank you for using the library!" << endl;

	exit(0);
	
}

   		
		    

		   

		   
 