/*                                                            
  
                                                            
                                                            
               Neuromancer's Graphics Library               
                       Version 1.0c                         
                                                            
     This program displays a WGT sprite file.               
                                                             
  
                                                            
       Project:    MTLIB01.LIB                              
                   DEMO12.CPP                               
                                                             
  
*/
#include <iostream.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include "video.h"
#include "bitmap.h"
#include "palette.h"


extern WGTSPRITE_HEADER *wgt_header;

void main(int argc, char *argv[])
{
	WGTSPRITE	**sprite;
	byte	   	palette[768];
	int		width;

	if (argc!=2)
	{
		cout << "Usage : demo12 <filename> "<<endl;
		cout << "        where filename is a WGT <.spr> file"<< endl;
		exit(0);
	}
	
	if((sprite=mtLoadWGT(argv[1],palette))==NULL)
	{	
		mtSetTextMode();
		cout << "Error loading " << argv[1] << endl;
		cout <<  "WGT sprite file required <.spr>" << endl;
		exit(0);
	}

	mtSetVGAMode();

	mtSetPal(palette,0,255);

	width=5;

	int last = 5;

	if (last > (wgt_header->total))
	{
		last = wgt_header->total;
	}
	
	for(int i = 0; i <= last; i++)
	{	
		mtCPutSprite(width,10,sprite[i]->width, sprite[i]->height,sprite[i]->data);
		width += sprite[i]->width +5;
	}
	
	getch();

	mtFreeWGT(sprite);
	
	mtSetTextMode();

	cout << "Thank you for using the library!" << endl;

	exit(0);
	
	
}

   		
		    

		   

		   
 