/*                                                            
  
                                                            
                                                            
               Neuromancer's Graphics Library               
                       Version 1.0c                         
                                                            
    This program sets up a virtual screen. Flipping can     
    be done by setting the active page and flipping the      
    hidden page.                                             
                                                               
  
                                                            
       Project:    MTLIB01.LIB                              
                   DEMO6.CPP                                
                                                             
  
*/

#include <iostream.h>
#include <stdlib.h> 
#include <conio.h>
#include "video.h"
#include "rect.h"
#include "bitmap.h"


block page1;

void main(void)
{

	mtSetVGAMode();			//Set up VGA Mode

	if ((page1=mtAllocPage(0,0,319,199)) == NULL)
	{
		mtSetTextMode();
		cout <<"Error in setting up virtual screen 1\n"<< endl;
		exit(0);
	}
	mtSetPage(PAGE_1);
	mtClrScr(170);

	mtSetPage(PAGE_0);		//set active page to video screen
	
	mtSetWindow(15,15,304,184);	//set up clip region
	mtClrScr(75);			//clear region to color 15

	while(!kbhit())
	{
		mtCPutPixel(random(320),random(200),random(256));
	}

	getch();

	mtResetWindow();
	mtClrScr(0);
	
	mtSetPage(PAGE_1);
	
	if (mtLoadPCX("pacman.dat")==0)
	{
		mtFreePage(page1);
		mtSetTextMode();
		exit(0);
	}
	
	mtFlipPage(PAGE_1);		//Flip to video screen

	getch();
	
	mtFreePage(page1);
	mtSetTextMode();

	cout << "Thank you for using the library!" << endl;

	exit(0);
	
}

   		
		    

		   

		   
 