/*****************************************************
; Filename 	: fonts.h
;
; Date 		: 29-6-94
; Mod. Date	: 
;
; Others	: 
;****************************************************/
#ifndef FONTS_H
#define FONTS_H

#include "std_defs.h"

typedef struct fonttype
{
	byte	index;
	byte	vspace;	//Space between rows in pixels
	byte	hspace;	//Space between adjacent chars
	byte	width;	//Width of characte
	byte	height;	//Height of character
	byte	*data;	//Actual bitmap

} FONT;

typedef struct font
{
	byte		flag;		//reserved
	byte		type[6];	//" Font "
	byte		first;		//first valid
	byte		last;		//last valid
	byte		total;
	
} FONT_HEADER;

#ifdef __cplusplus
extern "C" {
#endif

extern  FONT_HEADER 	*font_header;

FONT	**mtLoadFont(char *fontname);
int 	mtSaveFont(char *fontname,FONT **font);
void	mtFreeFont(FONT **font);
void 	mtPutc(int x,int y, int c,FONT **font );
void 	mtPrintStr(int x,int y, char* str,FONT **font);
void   mtSetColor(byte col);


#ifdef __cplusplus
}
#endif

#endif FONTS_H

