/*****************************************************
; Filename 	: video.h
;
; Date 		: 11-6-94
; Mod. Date	: 11-7-94
;
; Others	: Obtained from Ferraro
;		: VGA Trainer	(smith9@batis.bis.und.ac.za)
;		; VGL20         (morley@camosun.bc.ca)
;****************************************************/
#ifndef VIDEO_H
#define VIDEO_H

#include "std_defs.h"
#include <dos.h>

#ifdef __cplusplus
extern "C" {
#endif

#define PAGE_0	(block) MK_FP(0xA000,0x0000)
#define PAGE_1	page1
#define PAGE_2	page2

extern	block page1,page2;

void	mtSetVGAMode(void);
void	mtSetTextMode(void);

void	mtCPutPixel(int x, int y, int color);
void	mtPutPixel(int x, int y, int color);
int	mtGetPixel(int x, int y);

void	mtWaitRetrace(void);

//found in block.cpp
block	mtAllocPage(int x1, int y1, int x2, int y2);
void	mtFreePage(block page);

int	mtSetPage(block page);
int	mtFlipPage(block page);
int	mtCopyPage(block src, block dest);
int	mtCopyBlk(int x1,int y1,int x2,int y2,int xoff,int yoff,block src,block dest);
int	mtClipBlk(int *x1,int *y1, int *x2, int *y2);

void	mtClrScr(int color);
void	mtSetWindow(int x1, int y1, int x2, int y2);
void	mtResetWindow(void);

#ifdef __cplusplus
}
#endif

#endif VIDEO_H
