program AdlibTest;

{***************************************************************************}
{																			}
{		Author:				Kevin A. Lee									}
{																			}
{		Last Amended:		28th May, 1993									}
{																			}
{		Description:		Test program for pasKAL graphics library and	}
{							Adlib sound routines. The program simply checks	}
{							to see if an Adlib sound card is present loads	}
{							an instrument and plays a scale using it.		}
{																			}
{***************************************************************************}

uses
  	ADLIB, Crt;



procedure BassNote(Freq, Del: word);
begin
	FMKeyOn(4, Freq, 2);
    FMKeyOn(5, Freq, 2);
    delay(20);
    FMKeyOn(6, C4, 4);
    delay(del);
    FMKeyOff(6);
    FMKeyOff(5);
    FMKeyOff(4);
end; {BassNote}



procedure HarmonyNote(Freq, Del: word);
begin
    FMKeyOn(0, Freq, 4);
    delay(10);
    FMKeyOn(1, Freq, 4);
    delay(10);
    FMKeyOn(2, Freq, 4);
    delay(10);
    FMKeyOn(3, Freq, 4);
    delay(Del);
    FMKeyOff(3);
    delay(10);
    FMKeyOff(2);
    delay(10);
    FMKeyOff(1);
    delay(10);
    FMKeyOff(0);
    delay(10);
end; {HarmonyNote}



var
	TestInst1, TestInst2, TestInst3: FMInstrument;
    i: word;

begin
	WriteLn;
	Write('Checking for Adlib sound card...');
    if (not AdlibExists) then
    begin
    	Write('not found.');
        WriteLn;
        halt(1);
    end;
    Write('found.');
    WriteLn;
    WriteLn('Now playing tune...');

	FMReset;
    LoadSBI('DOCGUTFZ.SBI', TestInst1);
    LoadSBI('BASYKA01.SBI', TestInst2);
    LoadSBI('BDRUM1.SBI', TestInst3);
	FMSetVoice(0, TestInst1);
    FMSetVoice(1, TestInst1);
    FMSetVoice(2, TestInst1);
    FMSetVoice(3, TestInst1);
    FMSetVoice(4, TestInst2);
    FMSetVoice(5, TestInst2);
    FMSetVoice(6, TestInst3);
    for i := 1 to 5 do
    begin
    	BassNote(F4, 250);
        BassNote(F4, 250);
        BassNote(A4b, 250);
        BassNote(G4, 250);
    end;
    HarmonyNote(D4, 500);
    HarmonyNote(F4, 350);
    HarmonyNote(E4b, 600);
	FMReset;
    WriteLn('Done...');
end.